/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 * 
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 * 
 *  @(#) $Id: startup.c,v 1.1 2009/01/31 05:27:37 suikan Exp $
 */

/*
 *	ͥνȽλ
 */

#include "jsp_kernel.h"
#include "time_event.h"
#include "syslog.h"

/*
 *  ͥư֥ե饰
 */
BOOL	iniflg;

/*
 *  ͥν
 */
void
kernel_start()
{
	/*
	 *  åȰ¸ν
	 */
	cpu_initialize();
	sys_initialize();
	tool_initialize();

	/*
	 *  ƥǽν
	 */
	syslog_initialize();

	/*
	 *  ưåɽ
	 */
	print_banner();

	/*
	 *  ƥ⥸塼ν
	 *
	 *  ।٥ȴ⥸塼¾Υ⥸塼˽
	 *  ɬפ롥
	 */
	tmevt_initialize();
	object_initialize();

	/*
	 *  롼μ¹
	 */ 
	call_inirtn();

	/*
	 *  ͥưγ
	 */
	iniflg = TRUE;
	exit_and_dispatch();
}

/*
 *  ͥνλ
 */
void
kernel_exit()
{
	/*
	 *  ߤػ
	 */
	if (!sense_lock()) {
		if (sense_context()) {
			i_lock_cpu();
		}
		else  {
			t_lock_cpu();
		}
	}
	iniflg = FALSE;

	/*
	 *  λ롼μ¹
	 */
	call_terrtn();

	/*
	 *  atexit νȥǥȥ饯μ¹
	 */
	call_atexit();

	/*
	 *  ƥǽνλ
	 */
	syslog_terminate();

	/*
	 *  åȰ¸νλ
	 */
	cpu_terminate();
	sys_exit();
}
