/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2005,2006 by Embedded and Real-Time Systems Laboratory
 *              Graduate School of Information Science, Nagoya Univ., JAPAN
 * 
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 * 
 *  @(#) $Id: task.h,v 1.1 2009/01/31 05:27:37 suikan Exp $
 */

/*
 *	⥸塼
 */

#ifndef _TASK_H_
#define _TASK_H_

#include "queue.h"
#include "time_event.h"

/*
 *  ͥ٤ɽɽѴޥ
 */
#define INT_PRIORITY(x)		((UINT)((x) - TMIN_TPRI))
#define EXT_TSKPRI(x)		((PRI)(x) + TMIN_TPRI)

/*
 *  ֤ɽ
 *
 *  TCB Υ֤Ǥϡ¹Ծ֡RUNNINGˤȼ¹Բǽ֡READY
 *  ϶̤ʤξ֤Τơ¹ԤǤ֡RUNNABLEˤȸƤ֡
 *  Ԥ֤ϡ(TS_WAITING | TS_SUSPENDED) ɽTS_WAIT_???? 
 *  ϡԤ֤ȼ°֤ɽԤ֡Ԥ֤ޤˤ
 *  ˤΤꤵ롥
 */
#define	TS_DORMANT	0x00u	/* ٻ߾ */
#define	TS_RUNNABLE	0x01u	/* ¹ԤǤ */
#define	TS_WAITING	0x02u	/* Ԥ */
#define	TS_SUSPENDED	0x04u	/* Ԥ */

#define	TS_WAIT_SLEEP	0x08u	/* Ԥ */
#define	TS_WAIT_WOBJ	0x10u	/* Ʊ֥̿ȤФԤ */
#define	TS_WAIT_WOBJCB	0x20u	/* ʬԤ塼ˤĤʤäƤ */

/*
 *  Ƚ̥ޥ
 *
 *  TSTAT_DORMANT ϥٻ߾֤Ǥ뤫ɤTSTAT_RUNNABLE 
 *  ϥ¹ԤǤ֤Ǥ뤫ɤȽ̤롥TSTAT_WAITING 
 *  Ԥ֤Ԥ֤Τ줫Ǥ뤫ɤTSTAT_SUSPENDED 
 *  ϶Ԥ֤Ԥ֤Τ줫Ǥ뤫ɤȽ̤롥
 */
#define TSTAT_DORMANT(tstat)	((tstat) == TS_DORMANT)
#define TSTAT_RUNNABLE(tstat)	(((tstat) & TS_RUNNABLE) != 0)
#define TSTAT_WAITING(tstat)	(((tstat) & TS_WAITING) != 0)
#define TSTAT_SUSPENDED(tstat)	(((tstat) & TS_SUSPENDED) != 0)

/*
 *  Ԥ֥åWINFOˤ
 *
 *  Ԥ֤δ֤ϡTCB Ӥؤ WINFO 򼡤Τ
 *  ꤷʤФʤʤ
 *
 *  (a) TCB Υ֤Ԥ֤ˤ롥κݤˡԤ֤ȼ°
 *  ֡TS_WAIT_????ˤꤹ롥
 *
 *  (b) ॢȤƻ뤹뤿ˡ।٥ȥ֥åϿ롥
 *  Ͽ륿।٥ȥ֥åϡԤ륵ӥؿ
 *  ΥѿȤƳݤؤΥݥ󥿤 WINFO  tmevtb 
 *  롥ॢȤδƻ뤬ɬפʤʱʵԤξˤˤϡ
 *  tmevtb  NULL ˤ롥
 *
 *  Ʊ֥̿ȤФԤ֤ξˤϡɸ WINFO  
 *  wobjcbեɤɲä¤ΡWINFO_WOBJwait.h ˤ
 *  ֤ TS_WAIT_WOBJ ꤹ롥ޤʲ (c)(e) 
 *  Ԥɬפ롥Ʊ֥̿Ȥ˴طʤԤʵ
 *  ԤַвԤˤξˤϡ(c)(e) ɬפʤ
 *
 *  (c) TCB ԤоݤƱ֥̿ȤԤ塼ˤĤʤ
 *  塼ˤĤʤˡtask_queue ȤTCB Ʊ֥̿
 *  Ȥδ֥åζʬWOBJCBˤԤ塼ˤĤʤ
 *  ϡ֤ TS_WAIT_WOBJCB ꤹ롥
 *
 *  (d) ԤоݤƱ֥̿Ȥδ֥åؤΥݥ󥿤
 *  WINFO_WOBJ  wobjcb ˵롥
 *  JSPͥ wobjcb ȤΤϡͥٽԤ塼ˤĤʤ
 *  륿ͥ٤ѹ줿ΤߤǤ뤬ǥХå
 *  Ф䤹褦ˡԤ塼ͥٽǤʤˤ wobjcb 
 *  롥
 *
 *  (e) ԤоݤƱ֥̿Ȥ˰¸Ƶ뤳Ȥɬפ
 *  󤬤ˤϡWINFO_WOBJ ɬפʾΤΥեɤɲ
 *  ¤ΤWINFO_WOBJ Ѥ롥
 *
 *  Ԥ֤ݤˤϡԤͤ WINFO 
 *  wercd ꤹ롥wercd ȤΤԤʹߤǤΤФơ
 *  tmevtb ԤϻȤʤᡤΤ˶Ρunion
 *  ȤäƤ롥
 */
typedef union waiting_information {
	ER	wercd;		/* ԤΥ顼 */
	TMEVTB	*tmevtb;	/* ԤѤΥ।٥ȥ֥å */
} WINFO;

/*
 *  ֥å
 *
 *  ˴ؤͤѤʤROM֤ʬʥ
 *  ֥åˤȡͤѲ뤿RAM֤ʤФʤʤ
 *  ʬʥ֥åTCBˤʬΥTCBб륿
 *  ֥åؤݥ󥿤롥֥åб
 *  TCBؤݥ󥿤ˡRAMδ˾ޤ
 *  ¹ԸΨʤ뤿˺ѤƤʤ¾Υ֥ȤˤĤ
 *  ƤƱͤ˰
 *  ֥åˤϡDEF_TEX 륿㳰롼
 *  ˴ؤޤࡥ
 */
typedef struct task_initialization_block {
	ATR	tskatr;		/* ° */
	VP_INT	exinf;		/* γĥ */
	FP	task;		/* εư */
	UINT	ipriority;	/* εưͥ١ɽ */
	SIZE	stksz;		/* åΰΥʴݤ᤿͡ */
	VP	stk;		/* åΰƬ */

	ATR	texatr;		/* 㳰롼° */
	FP	texrtn;		/* 㳰롼εư */
} TINIB;

/*
 *  TCB ΥեɤΥӥå
 *
 *  TCB Υեɤ֤ϡǽ礭ƶȻפ뤿ᡤ
 *  åȰ¸˥եɤΥӥåѹ뤳ȤƤ롥
 */
#ifndef TBIT_TCB_TSTAT
#define	TBIT_TCB_TSTAT		6	/* tstat եɤΥӥå */
#endif /* TBIT_TCB_TSTAT */

#ifndef TBIT_TCB_PRIORITY
#define	TBIT_TCB_PRIORITY	4	/* priority եɤΥӥå */
#endif /* TBIT_TCB_PRIORITY */

/*
 *  ֥åTCB
 *
 *  JSPǤϡεư׵ᥭ塼󥰿κ͡TMAX_ACTCNTˤȵ
 *  ׵ᥭ塼󥰿κ͡TMAX_WUPCNTˤ 1 ˸ꤵƤ뤿
 *  ᡤ塼󥰤Ƥ뤫ɤοͤɽ뤳ȤǤ롥
 *  ޤԤ׵ͥȿκ͡TMAX_SUSCNTˤ 1 ˸ꤵ
 *  ΤǡԤ׵ͥȿsuscntˤɬפʤ
 */
typedef struct task_control_block {
	QUEUE	task_queue;	/* 塼 */
	const TINIB *tinib;	/* ֥åؤΥݥ */

	unsigned int	tstat : TBIT_TCB_TSTAT;	/* ֡ɽ*/
	unsigned int	priority : TBIT_TCB_PRIORITY;
						/* ߤͥ١ɽ*/
	unsigned int	actcnt : 1;		/* ư׵ᥭ塼 */
	unsigned int	wupcnt : 1;		/* ׵ᥭ塼 */
	unsigned int	enatex : 1;		/* 㳰ľ */

	TEXPTN	texptn;		/* α㳰װ */
	WINFO	*winfo;		/* Ԥ֥åؤΥݥ */
	CTXB	tskctxb;	/* ƥȥ֥å */
} TCB;

/*
 *  ¹Ծ֤Υ
 *
 *  ¹Ծ֤ΥʡץåƥȤäƤ륿ˤ
 *  TCB ؤݥ󥿡¹Ծ֤Υʤ NULL ˤ롥
 *  ӥνǡʥӥƤӽФ
 *  ˤ˴ؤ򻲾Ȥ runtsk Ȥruntsk 񤭴
 *  ΤϡǥѥåʤȽˤΤߤǤ롥
 */
extern TCB	*runtsk;

/*
 *  ǹ̤ͥΥ
 *
 *  ¹ԤǤ륿Ǻǹ̤ͥΥ TCB ؤݥ󥿡
 *  ԤǤ륿ʤ NULL ˤ롥
 *  ǥѥåػ߾֤ʤɡǥѥåαƤ֤ϡruntsk
 *  ȰפƤȤϸ¤ʤ
 */
extern TCB	*schedtsk;

/*
 *  ǥѥå㳰롼ư׵ե饰
 *
 *  ߥϥɥ顿CPU㳰ϥɥνиˡǥѥåޤ
 *  㳰롼εư׵᤹뤳Ȥ򼨤ե饰
 */
extern BOOL	reqflg;

/*
 *  ǥѥåľ
 *
 *  ǥѥåľ֤Ǥʤʤǥѥåػ߾֤Ǥʤ
 *  Ȥ򼨤ե饰
 */
extern BOOL	enadsp;

/*
 *  ǥ塼
 *
 *  ǥ塼ϡ¹ԤǤ֤Υ뤿Υ塼Ǥ롥
 *  ¹Ծ֤ΥƤ뤿ᡤǥʼ¹Բǽ˥塼Ȥ
 *  ̾ΤΤǤϤʤǥ塼Ȥ̾Τ夷Ƥ뤿ᡤ
 *  ̾ΤǸƤ֤Ȥˤ롥
 *
 *  ǥ塼ϡͥ٤ȤΥ塼ǹƤ롥
 *  TCBϡͥ٤Υ塼Ͽ롥
 */
extern QUEUE	ready_queue[TNUM_TPRI];

/*
 *  ǥ塼ΤΥӥåȥޥå
 *
 *  ǥ塼ΥΨ褯Ԥˡͥ٤ȤΥ塼
 *  ˥äƤ뤫ɤ򼨤ӥåȥޥåפѰդƤ롥ӥ
 *  ȥޥåפȤȤǡꥢβ򸺤餹ȤǤ뤬
 *  ӥå̿᤬¤Ƥʤץåǡͥ٤ʳʤ
 *  ˤϡӥåȥޥåΥСإåɤΤˡդ˸Ψ
 *  ǽ⤢롥
 */
extern UINT	ready_primap;

/*
 *  IDκ͡kernel_cfg.c
 */
extern const ID	tmax_tskid;

/*
 *  ֥åΥꥢkernel_cfg.c
 */
extern const TINIB	tinib_table[];

/*
 *  ơ֥kernel_cfg.c
 */
extern const ID	torder_table[];

/*
 *  TCBΥꥢkernel_cfg.c
 */
extern TCB	tcb_table[];

/*
 *  ο
 */
#define TNUM_TSK	((UINT)(tmax_tskid - TMIN_TSKID + 1))

/*
 *  IDTCBФΥޥ
 */
#define INDEX_TSK(tskid)	((UINT)((tskid) - TMIN_TSKID))
#define get_tcb(tskid)		(&(tcb_table[INDEX_TSK(tskid)]))
#define get_tcb_self(tskid)	((tskid) == TSK_SELF ? runtsk : get_tcb(tskid))

/*
 *  TCB饿IDФΥޥ
 */
#define	TSKID(tcb)	((ID)(((tcb) - tcb_table) + TMIN_TSKID))

/*
 *  ⥸塼ν
 */
extern void	task_initialize(void);

/*
 *  ǹ̥ͥΥ
 *
 *  ǥ塼κǹ̤ͥΥ򥵡TCBؤΥݥ
 *  ֤ǥ塼ξˤϡδؿƤӽФƤϤʤʤ
 */
extern TCB	*search_schedtsk(void);

/*
 *  ¹ԤǤ֤ؤΰܹ
 *
 *  tcb ǻꤵ륿ξ֤¹ԤǤ֤Ȥǥ塼
 *  롥¹ԤǤ֤ˤʤäͥ٤ǹ̤ͥΥ
 *  ͥ٤⤤ϡǹ̤ͥΥ򹹿ǥѥ
 *  ľ֤Ǥ TRUE ֤Ǥʤ FALSE ֤
 */
extern BOOL	make_runnable(TCB *tcb);

/*
 *  ¹ԤǤ֤¾ξ֤ؤΰܹ
 *
 *  tcb ǻꤵ륿ǥ塼롥tcb ǻꤷ
 *  ǹ̤ͥΥǤäˤϡǹ̤ͥΥ
 *  ꤷʤǥѥåľ֤Ǥ TRUE ֤Ǥʤ
 *   FALSE ֤ξ֤Ϲʤ
 */
extern BOOL	make_non_runnable(TCB *tcb);

/*
 *  ٻ߾֤ؤΰܹ
 *
 *  tcb ǻꤵ륿ξ֤ٻ߾֤Ȥ롥ޤεư
 *  ˽٤ѿνȡưΤΥƥȤ
 *  롥
 */
extern void	make_dormant(TCB *tcb);

/*
 *  ٻ߾֤¹ԤǤ֤ؤΰܹ
 *
 *  tcb ǻꤵ륿ξ֤ٻ߾֤¹ԤǤ֤Ȥ롥
 *  ԤǤ֤˰ܹԤؤΥǥѥåɬפʾ TRUE
 *  Ǥʤ FALSE ֤
 */
extern BOOL	make_active(TCB *tcb);

/*
 *  ¹Ծ֤Υνλ
 *
 *  exit_task  ext_tsk ޤ̤δؿˤƤΤϡ
 *  create_context  activate_context νλǻѤ
 *  å˲ʤ褦ˤ뤿кΰĤǤ롥ext_tsk Ȥ
 *  ̴ؿˤƤȤǡѿޤơѤ륹åΰ
 *  Ťʤʤ褦ˤǤ롥ޤѥ餬ưŪ˥饤Ÿ
 *  Τ򤱤뤿ˡext_tsk Ȥ̤ΥեƤ롥
 */
extern void	exit_task(void);

/*
 *  ǥ塼Υͥ٤ѹ
 *
 *  tcb ǻꤵǥ塼Υͥ٤ newpriɽ
 *  ѹ롥ޤɬפʾˤϺǹ̤ͥΥ򹹿ǥ
 *  ѥåľ֤Ǥ TRUE ֤Ǥʤ FALSE 
 *  
 */
extern BOOL	change_priority(TCB *tcb, UINT newpri);

/*
 *  ǥ塼βž
 *
 *  ǥ塼Ρpri ǻꤵͥ٤Υ塼ž롥
 *  ޤɬפʾˤϺǹ̤ͥΥѹǥѥå
 *  αƤʤ TRUE ֤Ǥʤ FALSE ֤
 */
extern BOOL	rotate_ready_queue(UINT pri);

/*
 *  㳰롼θƽФ
 *
 *  㳰롼ƤӽФƤӽФˡ¹Ծ֤Υ
 *  α㳰װ򥯥ꥢ㳰ػ߾֤ˤCPUå
 *  롥
 *  㳰롼󤫤ȡޤCPUå֤ᤷδ
 *  α㳰װ 0 ǤʤʤäƤСƤӥ㳰롼
 *  ƤӽФα㳰װ 0 ξˤϡ㳰ľ֤ˤƴ
 *  ꥿󤹤롥
 *  δؿϡ¹Ծ֤Υ㳰ľ֡enatex  
 *  TRUEˤǡα㳰װ 0 Ǥʤtexptn  0 Ǥʤ˾˸Ƥ
 *  ФȤꤷƤ롥δؿϡCPUå֤ǸƤӽФʤ
 *  Фʤʤ
 */
extern void	call_texrtn(void);

/*
 *  㳰롼εư
 *
 *  ¹Ծ֤Υ㳰롼εưƤС
 *  㳰롼ƤӽФCPU㳰롼ƤӽФ
 *  ϡŪCPUå롥
 *  δؿϡǥѥåߥϥɥ顿CPU㳰ϥɥνи
 *  ƤӽФ뤳ȤꤷƤ뤬Ʊν򥿡åȰ
 *  ¸ǵҤƤ褤ξˤϡOMIT_CALLTEX ޥ
 *  Ф褤
 */
extern void	calltex(void);

#endif /* _TASK_H_ */
