/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 * 
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 * 
 *  @(#) $Id: time_event.h,v 1.1 2009/01/31 05:27:37 suikan Exp $
 */

/*
 *	।٥ȴ⥸塼
 */

#ifndef _TIME_EVENT_H_
#define _TIME_EVENT_H_

/*
 *  ٥ȯΥǡ
 *
 *  EVTTIM ϡRELTIM ȤƻǤϰϤ⹭ϰϤɽǤɬ
 *  פ롥ɥץեǤϡRELTIM  16bit ʾǤʤ
 *  ФʤʤᡤEVTTIM  17bit ʾǤ뤳ȤɬפǤ롥
 *  ᡤ16bit ξ礬 UINT ǤϤʤUW Ƥ롥
 */
typedef UW	EVTTIM;

/*
 *  л֡RELTIMˤ˻Ǥ
 */
#define	TMAX_RELTIM	((((EVTTIM) 1) << (sizeof(EVTTIM) * CHAR_BIT - 1)) - 1)

/* 
 *  ।٥ȥ֥åΥǡ
 */
typedef void	(*CBACK)(VP);	/* Хåؿη */

typedef struct time_event_block {
	UINT	index;		/* ।٥ȥҡǤΰ */
	CBACK	callback;	/* Хåؿ */
	VP	arg;		/* ХåؿϤ */
} TMEVTB;

/*
 *  ।٥ȥҡΥΡɤΥǡ
 */
typedef struct time_event_node {
	EVTTIM	time;		/* ٥ȯ */
	TMEVTB	*tmevtb;	/* б륿।٥ȥ֥å */
} TMEVTN;

/*
 *  ।٥ȥҡסkernel_cfg.c
 */
extern TMEVTN	tmevt_heap[];

/*
 *  ƥΥեå
 */
extern SYSTIM	systim_offset;

/*
 *  ߤΥƥñ: ߥá
 *
 *  ƥ൯ư 0 ˽졤ʹߡisig_tim ƤФ٤ñĴ
 *  ä롥set_tim ˤäѹʤ
 */
extern SYSTIM	current_time;

/*
 *  ΥƥåΥƥñ: 1ߥá
 */
extern SYSTIM	next_time;

/*
 *  ƥѻѿñ: 1/TIM_DENOߥá
 *
 *  ΥƥåΥƥβ̷򼨤ʾ̷ next_timeˡ
 *  TIC_DENO  1 λϡ̷Ͼ 0 Ǥ뤿ᡤѿɬפʤ
 */
#if TIC_DENO != 1
extern UINT	next_subtime;
#endif /* TIC_DENO != 1 */

/*
 *  л֤Υ١ñ: 1ߥá
 *
 *  ΥƥåΥƥڤ夲TIC_DENO  1 
 *  ϡnext_time  EVTTIM ѴΤ˰פ롥
 */
#if TIC_DENO == 1
#define	base_time	((EVTTIM) next_time)
#else /* TIC_DENO == 1 */
#define	base_time	((EVTTIM)(next_time + (next_subtime > 0 ? 1 : 0)))
#endif /* TIC_DENO == 1 */

/*
 *  ।٥ȥҡפκǸλΰΥǥå
 *
 *  ।٥ȥҡפϿƤ륿।٥Ȥο˰פ롥
 */
extern UINT	last_index;

/*
 *  ।٥ȴ⥸塼ν
 */
extern void	tmevt_initialize(void);

/*
 *  ।٥Ȥ֤õ
 */
extern UINT	tmevt_up(UINT index, EVTTIM time);
extern UINT	tmevt_down(UINT index, EVTTIM time);

/*
 *  ।٥ȥҡפؤϿȺ
 */
extern void	tmevtb_insert(TMEVTB *tmevtb, EVTTIM time);
extern void	tmevtb_delete(TMEVTB *tmevtb);

/*
 *  ।٥ȥ֥åϿлֻ
 *
 *  time ǻꤷл֤вˡarg Ȥ callback 
 *  ӽФ褦ˡ।٥ȥ֥å tmevtb Ͽ롥
 */
Inline void
tmevtb_enqueue(TMEVTB *tmevtb, RELTIM time, CBACK callback, VP arg)
{
	assert(time <= TMAX_RELTIM);

	tmevtb->callback = callback;
	tmevtb->arg = arg;
	tmevtb_insert(tmevtb, base_time + time);
}

/*
 *  ।٥ȥ֥åϿʥ٥ȯ
 *
 *  time ǻꤷ٥ȯˡarg Ȥ callback 
 *  ӽФ褦ˡ।٥ȥ֥å tmevtb Ͽ롥
 */
Inline void
tmevtb_enqueue_evttim(TMEVTB *tmevtb, EVTTIM time, CBACK callback, VP arg)
{
	tmevtb->callback = callback;
	tmevtb->arg = arg;
	tmevtb_insert(tmevtb, time);
}

/*
 *  ।٥ȥ֥åϿ
 */
Inline void
tmevtb_dequeue(TMEVTB *tmevtb)
{
	tmevtb_delete(tmevtb);
}

#endif /* _TIME_EVENT_H_ */
