/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2003-2004 Takagi Nobuhisa
 * 
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 * 
 *  @(#) $Id: cxx_sample2.cpp,v 1.1 2009/01/31 05:27:37 suikan Exp $
 */

/*
 *  C++ץץ(2)
 *
 *  ΥץץϡůؼԤοפ١ȤơC++γƵǽ
 *  ΥǥԤäƤ롣
 *  5ͤůؼԤΥեݡΰդ˥ǥåɥåȯ
 *  ॢȤ򸡽ФC++㳰ФƤ롣
 *
 *  ư'q'Ϥưߤ뤳ȤǤrestart? [y|n]
 *  'y'ϤкƵư'n'Ϥнλ롣
 *  ޤư'a'ϤХܡȤ롣
 */

#include <t_services.h>
#include <cstdlib>
#include <new>
#include "kernel_id.h"
#include "cxx_sample2.h"

//	ޥƥȥ饹
//	Ū֥ȤΥ󥹥ȥ饯ȥǥȥ饯ưץ
class non_multitask_test
{
	int* x_;
public:
	non_multitask_test()
		: x_(new int(12345))	// ͥư֤Ǥnew黻
	{
	}
	~non_multitask_test()
	{
		if (*x_== 12345)
			syslog(LOG_NOTICE,"non-multitask test succeeded");
		else
			syslog(LOG_NOTICE,"non-multitask test failed");
		delete x_;				// ͥư֤Ǥdelete黻
		x_ = 0;
	}
} test;

class timeout_error
{
};

// 
int rnd()
{
	static unsigned int seed = 1;
	loc_cpu();
	seed = seed * 1566083941UL + 1;
	unl_cpu();
	return (seed >> 16) % 0x7fff;
}

//	ե饹
class fork
{
	ID semid_;
	bool used_;
public:
	explicit fork(int semid)
		: semid_(semid), used_(false)
	{
	}
	~fork()
	{
		if (used_)
			give();
	}
	ID id() const { return semid_; }
	bool is_used() const { return used_; }
	void take()
	{
		if (twai_sem(semid_, 500*5) == E_TMOUT)
			throw timeout_error();
		used_ = true;
	}
	void give()
	{
		used_ = false;
		sig_sem(semid_);
	}
};

fork* p_fork[5];

//	ůؼԥ饹
class philosopher
{
	ID		tskid_;
	fork* left_;
	fork* right_;
public:
	explicit philosopher(int tskid, fork* left, fork* right)
		: tskid_(tskid),
			left_(left), right_(right)
	{
		syslog(LOG_NOTICE,"philosofer #%d", tskid);
	}
	void think()
	{
		syslog(LOG_NOTICE, "#%d thinking...", tskid_);
		dly_tsk(100 * (rnd() % 5 + 1));
	}
	void eat()
	{
		syslog(LOG_NOTICE, "#%d eat up", tskid_);
		dly_tsk(100 * (rnd() % 5 + 1));
	}
	void run()
	{
		for (;;)
		{
			try
			{
				//	տŪ˥ǥåɥåȯ롣
				left_->take();
				syslog(LOG_NOTICE, "#%d take left fork(%d)", tskid_, left_->id());

				dly_tsk(100 * (rnd() % 5 + 1));

				right_->take();
				syslog(LOG_NOTICE, "#%d take right fork(%d)", tskid_, right_->id());

				eat();

				left_->give();
				syslog(LOG_NOTICE, "#%d give left fork(%d)", tskid_, left_->id());
				right_->give();
				syslog(LOG_NOTICE, "#%d give right fork(%d)", tskid_, right_->id());
				think();
			}
			catch (timeout_error&)
			{
				//	ॢȤˤǥåɥå򸡽Фȡե
				syslog(LOG_NOTICE, "#%d !!!! timeout error !!!!", tskid_);
				if (left_->is_used())
				{
					left_->give();
					syslog(LOG_NOTICE, "#%d give left fork(%d)", tskid_, left_->id());
				}
				if (right_->is_used())
				{
					right_->give();
					syslog(LOG_NOTICE, "#%d give right fork(%d)", tskid_, right_->id());
				}
				rot_rdq(TPRI_SELF);
			}
		}
	}
};

void task(VP_INT exinf)
{
	_toppers_cxxrt_reset_specific();	// κƵưǽˤ뤿ν
	ID		tskid = ID(exinf);
	fork* left	= p_fork[(tskid - 1) % 5];
	fork* right = p_fork[(tskid - 1 + 4) % 5];
	philosopher phil(tskid, left, right);
	phil.run();
}

//	std::atexitϿ뽪λؿ
void finish()
{
	syslog(LOG_NOTICE, "finish");
}


//	ᥤ󥿥
void main_task(VP_INT exinf)
{
	serial_ctl_por(TASK_PORTID, (IOCTL_CRLF | IOCTL_FCSND | IOCTL_FCRCV));
	syslog(LOG_NOTICE,"Sample program starts (exinf = %d)", exinf);

	std::atexit(finish);

	try
	{
		for (;;)
		{
			for (ID semid = 1; semid <= 5; semid++)
				p_fork[semid - 1] = new fork(semid);

			for (ID tskid = 1; tskid <= 5; tskid++)
				act_tsk(tskid);

			char c;
			do
			{
				serial_rea_dat(TASK_PORTID, &c, 1);
				if (c == 'a')
					std::abort();
			} while (c != 'q' && c != 'Q');

			for (ID tskid = 1; tskid <= 5; tskid++)
			{
				ter_tsk(tskid);
			}

			for (ID semid = 1; semid <= 5; semid++)
			{
				delete p_fork[semid - 1];
				p_fork[semid - 1] = 0;
			}

			do
			{
				syslog(LOG_NOTICE, "restart? [y|n] ");
				serial_rea_dat(TASK_PORTID, &c, 1);
			} while (c != 'y' && c != 'n');

			if (c == 'n')
				break;
		}

		syslog(LOG_NOTICE, "multitask test succeeded");
	}
	catch (std::bad_alloc&)
	{
		syslog(LOG_NOTICE, "multitask test failed");
	}

	std::exit(0);
}

