/*
** Copyright (C) 2005-2006 Analog Devices Inc., All Rights Reserved.
**
************************************************************************************
**
** This include file contains a list of macro "defines" to enable the programmer
** to use symbolic names for register-access.
**  
**/

/**********************************************************************************
** System MMR Register Map
***********************************************************************************/

#ifndef _CDEF_BF534_H
#define _CDEF_BF534_H

/* Include all Core registers and bit definitions 									*/
#include <defbf534.h>

/* Include core specific register pointer definitions 								*/
#include <cdef_lpblackfin.h>

#ifndef _PTR_TO_VOL_VOID_PTR
#ifndef _USE_LEGACY_CDEF_BEHAVIOUR
#define _PTR_TO_VOL_VOID_PTR (void * volatile *)
#else
#define _PTR_TO_VOL_VOID_PTR (volatile void **)
#endif
#endif


/* Clock and System Control	(0xFFC00000 - 0xFFC000FF)								*/
#define pPLL_CTL 		((volatile unsigned short *)PLL_CTL)
#define pPLL_DIV 		((volatile unsigned short *)PLL_DIV)
#define pVR_CTL 		((volatile unsigned short *)VR_CTL)
#define pPLL_STAT 		((volatile unsigned short *)PLL_STAT)
#define pPLL_LOCKCNT 		((volatile unsigned short *)PLL_LOCKCNT)


/* System Interrupt Controller (0xFFC00100 - 0xFFC001FF)							*/
#define pSWRST 			((volatile unsigned short *)SWRST)
#define pSYSCR 			((volatile unsigned short *)SYSCR)
#define	pSIC_RVECT		(_PTR_TO_VOL_VOID_PTR SIC_RVECT)
#define pSIC_IMASK 		((volatile unsigned long  *)SIC_IMASK)
#define pSIC_IAR0 		((volatile unsigned long  *)SIC_IAR0)
#define pSIC_IAR1 		((volatile unsigned long  *)SIC_IAR1)
#define pSIC_IAR2 		((volatile unsigned long  *)SIC_IAR2)
#define pSIC_IAR3 		((volatile unsigned long  *)SIC_IAR3)
#define pSIC_ISR 		((volatile unsigned long  *)SIC_ISR)
#define pSIC_IWR 		((volatile unsigned long  *)SIC_IWR)


/* Watchdog Timer		(0xFFC00200 - 0xFFC002FF)									*/
#define pWDOG_CTL 		((volatile unsigned short *)WDOG_CTL)
#define pWDOG_CNT 		((volatile unsigned long  *)WDOG_CNT)
#define pWDOG_STAT 		((volatile unsigned long  *)WDOG_STAT)


/* Real Time Clock		(0xFFC00300 - 0xFFC003FF)									*/
#define pRTC_STAT 		((volatile unsigned long  *)RTC_STAT)
#define pRTC_ICTL 		((volatile unsigned short *)RTC_ICTL)
#define pRTC_ISTAT 		((volatile unsigned short *)RTC_ISTAT)
#define pRTC_SWCNT 		((volatile unsigned short *)RTC_SWCNT)
#define pRTC_ALARM 		((volatile unsigned long  *)RTC_ALARM)
#define pRTC_FAST 		((volatile unsigned short *)RTC_FAST)
#define pRTC_PREN 		((volatile unsigned short *)RTC_PREN)


/* UART0 Controller		(0xFFC00400 - 0xFFC004FF)									*/
#define pUART0_THR 		((volatile unsigned short *)UART0_THR)
#define pUART0_RBR 		((volatile unsigned short *)UART0_RBR)
#define pUART0_DLL 		((volatile unsigned short *)UART0_DLL)
#define pUART0_IER 		((volatile unsigned short *)UART0_IER)
#define pUART0_DLH 		((volatile unsigned short *)UART0_DLH)
#define pUART0_IIR 		((volatile unsigned short *)UART0_IIR)
#define pUART0_LCR 		((volatile unsigned short *)UART0_LCR)
#define pUART0_MCR 		((volatile unsigned short *)UART0_MCR)
#define pUART0_LSR 		((volatile unsigned short *)UART0_LSR)
#define pUART0_MSR		((volatile unsigned short *)UART0_LSR)
#define pUART0_SCR 		((volatile unsigned short *)UART0_SCR)
#define pUART0_GCTL 		((volatile unsigned short *)UART0_GCTL)


/* SPI Controller		(0xFFC00500 - 0xFFC005FF)									*/
#define pSPI_CTL 		((volatile unsigned short *)SPI_CTL)
#define pSPI_FLG 		((volatile unsigned short *)SPI_FLG)
#define pSPI_STAT 		((volatile unsigned short *)SPI_STAT)
#define pSPI_TDBR 		((volatile unsigned short *)SPI_TDBR)
#define pSPI_RDBR 		((volatile unsigned short *)SPI_RDBR)
#define pSPI_BAUD 		((volatile unsigned short *)SPI_BAUD)
#define pSPI_SHADOW 		((volatile unsigned short *)SPI_SHADOW)


/* TIMER0-7 Registers		(0xFFC00600 - 0xFFC006FF)								*/
#define pTIMER0_CONFIG 		((volatile unsigned short *)TIMER0_CONFIG)
#define pTIMER0_COUNTER 	((volatile unsigned long  *)TIMER0_COUNTER)
#define pTIMER0_PERIOD 		((volatile unsigned long  *)TIMER0_PERIOD)
#define pTIMER0_WIDTH 		((volatile unsigned long  *)TIMER0_WIDTH)

#define pTIMER1_CONFIG 		((volatile unsigned short *)TIMER1_CONFIG)
#define pTIMER1_COUNTER 	((volatile unsigned long  *)TIMER1_COUNTER)
#define pTIMER1_PERIOD 		((volatile unsigned long  *)TIMER1_PERIOD)
#define pTIMER1_WIDTH 		((volatile unsigned long  *)TIMER1_WIDTH)

#define pTIMER2_CONFIG 		((volatile unsigned short *)TIMER2_CONFIG)
#define pTIMER2_COUNTER 	((volatile unsigned long  *)TIMER2_COUNTER)
#define pTIMER2_PERIOD 		((volatile unsigned long  *)TIMER2_PERIOD)
#define pTIMER2_WIDTH 		((volatile unsigned long  *)TIMER2_WIDTH)

#define pTIMER3_CONFIG 		((volatile unsigned short *)TIMER3_CONFIG)
#define pTIMER3_COUNTER 	((volatile unsigned long  *)TIMER3_COUNTER)
#define pTIMER3_PERIOD 		((volatile unsigned long  *)TIMER3_PERIOD)
#define pTIMER3_WIDTH 		((volatile unsigned long  *)TIMER3_WIDTH)

#define pTIMER4_CONFIG 		((volatile unsigned short *)TIMER4_CONFIG)
#define pTIMER4_COUNTER 	((volatile unsigned long  *)TIMER4_COUNTER)
#define pTIMER4_PERIOD 		((volatile unsigned long  *)TIMER4_PERIOD)
#define pTIMER4_WIDTH 		((volatile unsigned long  *)TIMER4_WIDTH)

#define pTIMER5_CONFIG 		((volatile unsigned short *)TIMER5_CONFIG)
#define pTIMER5_COUNTER 	((volatile unsigned long  *)TIMER5_COUNTER)
#define pTIMER5_PERIOD 		((volatile unsigned long  *)TIMER5_PERIOD)
#define pTIMER5_WIDTH 		((volatile unsigned long  *)TIMER5_WIDTH)

#define pTIMER6_CONFIG 		((volatile unsigned short *)TIMER6_CONFIG)
#define pTIMER6_COUNTER 	((volatile unsigned long  *)TIMER6_COUNTER)
#define pTIMER6_PERIOD 		((volatile unsigned long  *)TIMER6_PERIOD)
#define pTIMER6_WIDTH 		((volatile unsigned long  *)TIMER6_WIDTH)

#define pTIMER7_CONFIG 		((volatile unsigned short *)TIMER7_CONFIG)
#define pTIMER7_COUNTER 	((volatile unsigned long  *)TIMER7_COUNTER)
#define pTIMER7_PERIOD 		((volatile unsigned long  *)TIMER7_PERIOD)
#define pTIMER7_WIDTH 		((volatile unsigned long  *)TIMER7_WIDTH)

#define pTIMER_ENABLE 		((volatile unsigned short *)TIMER_ENABLE)
#define pTIMER_DISABLE 		((volatile unsigned short *)TIMER_DISABLE)
#define pTIMER_STATUS		((volatile unsigned long  *)TIMER_STATUS)


/* General Purpose I/O Port F (0xFFC00700 - 0xFFC007FF)								*/
#define pPORTFIO	 	((volatile unsigned short *)PORTFIO)
#define pPORTFIO_CLEAR	 	((volatile unsigned short *)PORTFIO_CLEAR)
#define pPORTFIO_SET	 	((volatile unsigned short *)PORTFIO_SET)
#define pPORTFIO_TOGGLE 	((volatile unsigned short *)PORTFIO_TOGGLE)
#define pPORTFIO_MASKA 		((volatile unsigned short *)PORTFIO_MASKA)
#define pPORTFIO_MASKA_CLEAR 	((volatile unsigned short *)PORTFIO_MASKA_CLEAR)
#define pPORTFIO_MASKA_SET 	((volatile unsigned short *)PORTFIO_MASKA_SET)
#define pPORTFIO_MASKA_TOGGLE 	((volatile unsigned short *)PORTFIO_MASKA_TOGGLE)
#define pPORTFIO_MASKB	 	((volatile unsigned short *)PORTFIO_MASKB)
#define pPORTFIO_MASKB_CLEAR 	((volatile unsigned short *)PORTFIO_MASKB_CLEAR)
#define pPORTFIO_MASKB_SET 	((volatile unsigned short *)PORTFIO_MASKB_SET)
#define pPORTFIO_MASKB_TOGGLE 	((volatile unsigned short *)PORTFIO_MASKB_TOGGLE)
#define pPORTFIO_DIR 		((volatile unsigned short *)PORTFIO_DIR)
#define pPORTFIO_POLAR 		((volatile unsigned short *)PORTFIO_POLAR)
#define pPORTFIO_EDGE 		((volatile unsigned short *)PORTFIO_EDGE)
#define pPORTFIO_BOTH 		((volatile unsigned short *)PORTFIO_BOTH)
#define pPORTFIO_INEN 		((volatile unsigned short *)PORTFIO_INEN)


/* SPORT0 Controller		(0xFFC00800 - 0xFFC008FF)								*/
#define pSPORT0_TCR1 		((volatile unsigned short *)SPORT0_TCR1)
#define pSPORT0_TCR2 		((volatile unsigned short *)SPORT0_TCR2)
#define pSPORT0_TCLKDIV 	((volatile unsigned short *)SPORT0_TCLKDIV)
#define pSPORT0_TFSDIV 		((volatile unsigned short *)SPORT0_TFSDIV)
#define pSPORT0_TX 		((volatile unsigned long  *)SPORT0_TX)
#define pSPORT0_RX 		((volatile unsigned long  *)SPORT0_RX)
#define pSPORT0_TX32 		((volatile unsigned long  *)SPORT0_TX)
#define pSPORT0_RX32 		((volatile unsigned long  *)SPORT0_RX)
#define pSPORT0_TX16 		((volatile unsigned short *)SPORT0_TX)
#define pSPORT0_RX16 		((volatile unsigned short *)SPORT0_RX)
#define pSPORT0_RCR1 		((volatile unsigned short *)SPORT0_RCR1)
#define pSPORT0_RCR2 		((volatile unsigned short *)SPORT0_RCR2)
#define pSPORT0_RCLKDIV 	((volatile unsigned short *)SPORT0_RCLKDIV)
#define pSPORT0_RFSDIV 		((volatile unsigned short *)SPORT0_RFSDIV)
#define pSPORT0_STAT 		((volatile unsigned short *)SPORT0_STAT)
#define pSPORT0_CHNL 		((volatile unsigned short *)SPORT0_CHNL)
#define pSPORT0_MCMC1 		((volatile unsigned short *)SPORT0_MCMC1)
#define pSPORT0_MCMC2 		((volatile unsigned short *)SPORT0_MCMC2)
#define pSPORT0_MTCS0 		((volatile unsigned long  *)SPORT0_MTCS0)
#define pSPORT0_MTCS1 		((volatile unsigned long  *)SPORT0_MTCS1)
#define pSPORT0_MTCS2 		((volatile unsigned long  *)SPORT0_MTCS2)
#define pSPORT0_MTCS3 		((volatile unsigned long  *)SPORT0_MTCS3)
#define pSPORT0_MRCS0 		((volatile unsigned long  *)SPORT0_MRCS0)
#define pSPORT0_MRCS1 		((volatile unsigned long  *)SPORT0_MRCS1)
#define pSPORT0_MRCS2 		((volatile unsigned long  *)SPORT0_MRCS2)
#define pSPORT0_MRCS3 		((volatile unsigned long  *)SPORT0_MRCS3)


/* SPORT1 Controller		(0xFFC00900 - 0xFFC009FF)								*/
#define pSPORT1_TCR1 		((volatile unsigned short *)SPORT1_TCR1)
#define pSPORT1_TCR2 		((volatile unsigned short *)SPORT1_TCR2)
#define pSPORT1_TCLKDIV 	((volatile unsigned short *)SPORT1_TCLKDIV)
#define pSPORT1_TFSDIV 		((volatile unsigned short *)SPORT1_TFSDIV)
#define pSPORT1_TX 		((volatile unsigned long  *)SPORT1_TX)
#define pSPORT1_RX 		((volatile unsigned long  *)SPORT1_RX)
#define pSPORT1_TX32 		((volatile unsigned long  *)SPORT1_TX)
#define pSPORT1_RX32 		((volatile unsigned long  *)SPORT1_RX)
#define pSPORT1_TX16 		((volatile unsigned short *)SPORT1_TX)
#define pSPORT1_RX16 		((volatile unsigned short *)SPORT1_RX)
#define pSPORT1_RCR1 		((volatile unsigned short *)SPORT1_RCR1)
#define pSPORT1_RCR2 		((volatile unsigned short *)SPORT1_RCR2)
#define pSPORT1_RCLKDIV 	((volatile unsigned short *)SPORT1_RCLKDIV)
#define pSPORT1_RFSDIV 		((volatile unsigned short *)SPORT1_RFSDIV)
#define pSPORT1_STAT 		((volatile unsigned short *)SPORT1_STAT)
#define pSPORT1_CHNL 		((volatile unsigned short *)SPORT1_CHNL)
#define pSPORT1_MCMC1 		((volatile unsigned short *)SPORT1_MCMC1)
#define pSPORT1_MCMC2 		((volatile unsigned short *)SPORT1_MCMC2)
#define pSPORT1_MTCS0 		((volatile unsigned long  *)SPORT1_MTCS0)
#define pSPORT1_MTCS1 		((volatile unsigned long  *)SPORT1_MTCS1)
#define pSPORT1_MTCS2 		((volatile unsigned long  *)SPORT1_MTCS2)
#define pSPORT1_MTCS3 		((volatile unsigned long  *)SPORT1_MTCS3)
#define pSPORT1_MRCS0 		((volatile unsigned long  *)SPORT1_MRCS0)
#define pSPORT1_MRCS1 		((volatile unsigned long  *)SPORT1_MRCS1)
#define pSPORT1_MRCS2 		((volatile unsigned long  *)SPORT1_MRCS2)
#define pSPORT1_MRCS3 		((volatile unsigned long  *)SPORT1_MRCS3)


/* External Bus Interface Unit (0xFFC00A00 - 0xFFC00AFF)							*/
#define pEBIU_AMGCTL 		((volatile unsigned short *)EBIU_AMGCTL)
#define pEBIU_AMBCTL0 		((volatile unsigned long  *)EBIU_AMBCTL0)
#define pEBIU_AMBCTL1 		((volatile unsigned long  *)EBIU_AMBCTL1)
#define pEBIU_SDGCTL 		((volatile unsigned long  *)EBIU_SDGCTL)
#define pEBIU_SDBCTL 		((volatile unsigned short *)EBIU_SDBCTL)
#define pEBIU_SDRRC 		((volatile unsigned short *)EBIU_SDRRC)
#define pEBIU_SDSTAT 		((volatile unsigned short *)EBIU_SDSTAT)


/* DMA Traffic Control Registers													*/
#define	pDMA_TC_PER		((volatile unsigned short *)DMA_TC_PER)
#define	pDMA_TC_CNT		((volatile unsigned short *)DMA_TC_CNT)

/* Alternate deprecated register names (below) provided for backwards code compatibility */
#define	pDMA_TCPER		((volatile unsigned short *)DMA_TCPER)
#define	pDMA_TCCNT		((volatile unsigned short *)DMA_TCCNT)

/* DMA Controller																	*/
#define pDMA0_CONFIG 		((volatile unsigned short *)DMA0_CONFIG)
#define pDMA0_NEXT_DESC_PTR 	(_PTR_TO_VOL_VOID_PTR DMA0_NEXT_DESC_PTR)
#define pDMA0_START_ADDR 	(_PTR_TO_VOL_VOID_PTR DMA0_START_ADDR)
#define pDMA0_X_COUNT 		((volatile unsigned short *)DMA0_X_COUNT)
#define pDMA0_Y_COUNT 		((volatile unsigned short *)DMA0_Y_COUNT)
#define pDMA0_X_MODIFY 		((volatile signed   short *)DMA0_X_MODIFY)
#define pDMA0_Y_MODIFY 		((volatile signed   short *)DMA0_Y_MODIFY)
#define pDMA0_CURR_DESC_PTR 	(_PTR_TO_VOL_VOID_PTR DMA0_CURR_DESC_PTR)
#define pDMA0_CURR_ADDR 	(_PTR_TO_VOL_VOID_PTR DMA0_CURR_ADDR)
#define pDMA0_CURR_X_COUNT 	((volatile unsigned short *)DMA0_CURR_X_COUNT)
#define pDMA0_CURR_Y_COUNT 	((volatile unsigned short *)DMA0_CURR_Y_COUNT)
#define pDMA0_IRQ_STATUS 	((volatile unsigned short *)DMA0_IRQ_STATUS)
#define pDMA0_PERIPHERAL_MAP 	((volatile unsigned short *)DMA0_PERIPHERAL_MAP)

#define pDMA1_CONFIG 		((volatile unsigned short *)DMA1_CONFIG)
#define pDMA1_NEXT_DESC_PTR 	(_PTR_TO_VOL_VOID_PTR DMA1_NEXT_DESC_PTR)
#define pDMA1_START_ADDR 	(_PTR_TO_VOL_VOID_PTR DMA1_START_ADDR)
#define pDMA1_X_COUNT 		((volatile unsigned short *)DMA1_X_COUNT)
#define pDMA1_Y_COUNT 		((volatile unsigned short *)DMA1_Y_COUNT)
#define pDMA1_X_MODIFY 		((volatile signed   short *)DMA1_X_MODIFY)
#define pDMA1_Y_MODIFY 		((volatile signed   short *)DMA1_Y_MODIFY)
#define pDMA1_CURR_DESC_PTR 	(_PTR_TO_VOL_VOID_PTR DMA1_CURR_DESC_PTR)
#define pDMA1_CURR_ADDR 	(_PTR_TO_VOL_VOID_PTR DMA1_CURR_ADDR)
#define pDMA1_CURR_X_COUNT 	((volatile unsigned short *)DMA1_CURR_X_COUNT)
#define pDMA1_CURR_Y_COUNT 	((volatile unsigned short *)DMA1_CURR_Y_COUNT)
#define pDMA1_IRQ_STATUS 	((volatile unsigned short *)DMA1_IRQ_STATUS)
#define pDMA1_PERIPHERAL_MAP 	((volatile unsigned short *)DMA1_PERIPHERAL_MAP)

#define pDMA2_CONFIG 		((volatile unsigned short *)DMA2_CONFIG)
#define pDMA2_NEXT_DESC_PTR 	(_PTR_TO_VOL_VOID_PTR DMA2_NEXT_DESC_PTR)
#define pDMA2_START_ADDR 	(_PTR_TO_VOL_VOID_PTR DMA2_START_ADDR)
#define pDMA2_X_COUNT 		((volatile unsigned short *)DMA2_X_COUNT)
#define pDMA2_Y_COUNT 		((volatile unsigned short *)DMA2_Y_COUNT)
#define pDMA2_X_MODIFY 		((volatile signed   short *)DMA2_X_MODIFY)
#define pDMA2_Y_MODIFY 		((volatile signed   short *)DMA2_Y_MODIFY)
#define pDMA2_CURR_DESC_PTR 	(_PTR_TO_VOL_VOID_PTR DMA2_CURR_DESC_PTR)
#define pDMA2_CURR_ADDR 	(_PTR_TO_VOL_VOID_PTR DMA2_CURR_ADDR)
#define pDMA2_CURR_X_COUNT 	((volatile unsigned short *)DMA2_CURR_X_COUNT)
#define pDMA2_CURR_Y_COUNT 	((volatile unsigned short *)DMA2_CURR_Y_COUNT)
#define pDMA2_IRQ_STATUS 	((volatile unsigned short *)DMA2_IRQ_STATUS)
#define pDMA2_PERIPHERAL_MAP 	((volatile unsigned short *)DMA2_PERIPHERAL_MAP)

#define pDMA3_CONFIG 		((volatile unsigned short *)DMA3_CONFIG)
#define pDMA3_NEXT_DESC_PTR 	(_PTR_TO_VOL_VOID_PTR DMA3_NEXT_DESC_PTR)
#define pDMA3_START_ADDR 	(_PTR_TO_VOL_VOID_PTR DMA3_START_ADDR)
#define pDMA3_X_COUNT 		((volatile unsigned short *)DMA3_X_COUNT)
#define pDMA3_Y_COUNT 		((volatile unsigned short *)DMA3_Y_COUNT)
#define pDMA3_X_MODIFY 		((volatile signed   short *)DMA3_X_MODIFY)
#define pDMA3_Y_MODIFY 		((volatile signed   short *)DMA3_Y_MODIFY)
#define pDMA3_CURR_DESC_PTR 	(_PTR_TO_VOL_VOID_PTR DMA3_CURR_DESC_PTR)
#define pDMA3_CURR_ADDR 	(_PTR_TO_VOL_VOID_PTR DMA3_CURR_ADDR)
#define pDMA3_CURR_X_COUNT 	((volatile unsigned short *)DMA3_CURR_X_COUNT)
#define pDMA3_CURR_Y_COUNT 	((volatile unsigned short *)DMA3_CURR_Y_COUNT)
#define pDMA3_IRQ_STATUS 	((volatile unsigned short *)DMA3_IRQ_STATUS)
#define pDMA3_PERIPHERAL_MAP 	((volatile unsigned short *)DMA3_PERIPHERAL_MAP)

#define pDMA4_CONFIG 		((volatile unsigned short *)DMA4_CONFIG)
#define pDMA4_NEXT_DESC_PTR 	(_PTR_TO_VOL_VOID_PTR DMA4_NEXT_DESC_PTR)
#define pDMA4_START_ADDR 	(_PTR_TO_VOL_VOID_PTR DMA4_START_ADDR)
#define pDMA4_X_COUNT 		((volatile unsigned short *)DMA4_X_COUNT)
#define pDMA4_Y_COUNT 		((volatile unsigned short *)DMA4_Y_COUNT)
#define pDMA4_X_MODIFY 		((volatile signed   short *)DMA4_X_MODIFY)
#define pDMA4_Y_MODIFY 		((volatile signed   short *)DMA4_Y_MODIFY)
#define pDMA4_CURR_DESC_PTR 	(_PTR_TO_VOL_VOID_PTR DMA4_CURR_DESC_PTR)
#define pDMA4_CURR_ADDR 	(_PTR_TO_VOL_VOID_PTR DMA4_CURR_ADDR)
#define pDMA4_CURR_X_COUNT 	((volatile unsigned short *)DMA4_CURR_X_COUNT)
#define pDMA4_CURR_Y_COUNT 	((volatile unsigned short *)DMA4_CURR_Y_COUNT)
#define pDMA4_IRQ_STATUS 	((volatile unsigned short *)DMA4_IRQ_STATUS)
#define pDMA4_PERIPHERAL_MAP 	((volatile unsigned short *)DMA4_PERIPHERAL_MAP)

#define pDMA5_CONFIG 		((volatile unsigned short *)DMA5_CONFIG)
#define pDMA5_NEXT_DESC_PTR 	(_PTR_TO_VOL_VOID_PTR DMA5_NEXT_DESC_PTR)
#define pDMA5_START_ADDR 	(_PTR_TO_VOL_VOID_PTR DMA5_START_ADDR)
#define pDMA5_X_COUNT 		((volatile unsigned short *)DMA5_X_COUNT)
#define pDMA5_Y_COUNT 		((volatile unsigned short *)DMA5_Y_COUNT)
#define pDMA5_X_MODIFY 		((volatile signed   short *)DMA5_X_MODIFY)
#define pDMA5_Y_MODIFY 		((volatile signed   short *)DMA5_Y_MODIFY)
#define pDMA5_CURR_DESC_PTR 	(_PTR_TO_VOL_VOID_PTR DMA5_CURR_DESC_PTR)
#define pDMA5_CURR_ADDR 	(_PTR_TO_VOL_VOID_PTR DMA5_CURR_ADDR)
#define pDMA5_CURR_X_COUNT 	((volatile unsigned short *)DMA5_CURR_X_COUNT)
#define pDMA5_CURR_Y_COUNT 	((volatile unsigned short *)DMA5_CURR_Y_COUNT)
#define pDMA5_IRQ_STATUS 	((volatile unsigned short *)DMA5_IRQ_STATUS)
#define pDMA5_PERIPHERAL_MAP 	((volatile unsigned short *)DMA5_PERIPHERAL_MAP)

#define pDMA6_CONFIG 		((volatile unsigned short *)DMA6_CONFIG)
#define pDMA6_NEXT_DESC_PTR 	(_PTR_TO_VOL_VOID_PTR DMA6_NEXT_DESC_PTR)
#define pDMA6_START_ADDR 	(_PTR_TO_VOL_VOID_PTR DMA6_START_ADDR)
#define pDMA6_X_COUNT 		((volatile unsigned short *)DMA6_X_COUNT)
#define pDMA6_Y_COUNT 		((volatile unsigned short *)DMA6_Y_COUNT)
#define pDMA6_X_MODIFY 		((volatile signed   short *)DMA6_X_MODIFY)
#define pDMA6_Y_MODIFY 		((volatile signed   short *)DMA6_Y_MODIFY)
#define pDMA6_CURR_DESC_PTR 	(_PTR_TO_VOL_VOID_PTR DMA6_CURR_DESC_PTR)
#define pDMA6_CURR_ADDR 	(_PTR_TO_VOL_VOID_PTR DMA6_CURR_ADDR)
#define pDMA6_CURR_X_COUNT 	((volatile unsigned short *)DMA6_CURR_X_COUNT)
#define pDMA6_CURR_Y_COUNT 	((volatile unsigned short *)DMA6_CURR_Y_COUNT)
#define pDMA6_IRQ_STATUS 	((volatile unsigned short *)DMA6_IRQ_STATUS)
#define pDMA6_PERIPHERAL_MAP 	((volatile unsigned short *)DMA6_PERIPHERAL_MAP)

#define pDMA7_CONFIG 		((volatile unsigned short *)DMA7_CONFIG)
#define pDMA7_NEXT_DESC_PTR 	(_PTR_TO_VOL_VOID_PTR DMA7_NEXT_DESC_PTR)
#define pDMA7_START_ADDR 	(_PTR_TO_VOL_VOID_PTR DMA7_START_ADDR)
#define pDMA7_X_COUNT 		((volatile unsigned short *)DMA7_X_COUNT)
#define pDMA7_Y_COUNT 		((volatile unsigned short *)DMA7_Y_COUNT)
#define pDMA7_X_MODIFY 		((volatile signed   short *)DMA7_X_MODIFY)
#define pDMA7_Y_MODIFY 		((volatile signed   short *)DMA7_Y_MODIFY)
#define pDMA7_CURR_DESC_PTR 	(_PTR_TO_VOL_VOID_PTR DMA7_CURR_DESC_PTR)
#define pDMA7_CURR_ADDR 	(_PTR_TO_VOL_VOID_PTR DMA7_CURR_ADDR)
#define pDMA7_CURR_X_COUNT 	((volatile unsigned short *)DMA7_CURR_X_COUNT)
#define pDMA7_CURR_Y_COUNT 	((volatile unsigned short *)DMA7_CURR_Y_COUNT)
#define pDMA7_IRQ_STATUS 	((volatile unsigned short *)DMA7_IRQ_STATUS)
#define pDMA7_PERIPHERAL_MAP 	((volatile unsigned short *)DMA7_PERIPHERAL_MAP)

#define pDMA8_CONFIG 		((volatile unsigned short *)DMA8_CONFIG)
#define pDMA8_NEXT_DESC_PTR 	(_PTR_TO_VOL_VOID_PTR DMA8_NEXT_DESC_PTR)
#define pDMA8_START_ADDR 	(_PTR_TO_VOL_VOID_PTR DMA8_START_ADDR)
#define pDMA8_X_COUNT 		((volatile unsigned short *)DMA8_X_COUNT)
#define pDMA8_Y_COUNT 		((volatile unsigned short *)DMA8_Y_COUNT)
#define pDMA8_X_MODIFY 		((volatile signed   short *)DMA8_X_MODIFY)
#define pDMA8_Y_MODIFY 		((volatile signed   short *)DMA8_Y_MODIFY)
#define pDMA8_CURR_DESC_PTR 	(_PTR_TO_VOL_VOID_PTR DMA8_CURR_DESC_PTR)
#define pDMA8_CURR_ADDR 	(_PTR_TO_VOL_VOID_PTR DMA8_CURR_ADDR)
#define pDMA8_CURR_X_COUNT 	((volatile unsigned short *)DMA8_CURR_X_COUNT)
#define pDMA8_CURR_Y_COUNT 	((volatile unsigned short *)DMA8_CURR_Y_COUNT)
#define pDMA8_IRQ_STATUS 	((volatile unsigned short *)DMA8_IRQ_STATUS)
#define pDMA8_PERIPHERAL_MAP 	((volatile unsigned short *)DMA8_PERIPHERAL_MAP)

#define pDMA9_CONFIG 		((volatile unsigned short *)DMA9_CONFIG)
#define pDMA9_NEXT_DESC_PTR 	(_PTR_TO_VOL_VOID_PTR DMA9_NEXT_DESC_PTR)
#define pDMA9_START_ADDR 	(_PTR_TO_VOL_VOID_PTR DMA9_START_ADDR)
#define pDMA9_X_COUNT 		((volatile unsigned short *)DMA9_X_COUNT)
#define pDMA9_Y_COUNT 		((volatile unsigned short *)DMA9_Y_COUNT)
#define pDMA9_X_MODIFY 		((volatile signed   short *)DMA9_X_MODIFY)
#define pDMA9_Y_MODIFY 		((volatile signed   short *)DMA9_Y_MODIFY)
#define pDMA9_CURR_DESC_PTR 	(_PTR_TO_VOL_VOID_PTR DMA9_CURR_DESC_PTR)
#define pDMA9_CURR_ADDR 	(_PTR_TO_VOL_VOID_PTR DMA9_CURR_ADDR)
#define pDMA9_CURR_X_COUNT 	((volatile unsigned short *)DMA9_CURR_X_COUNT)
#define pDMA9_CURR_Y_COUNT 	((volatile unsigned short *)DMA9_CURR_Y_COUNT)
#define pDMA9_IRQ_STATUS 	((volatile unsigned short *)DMA9_IRQ_STATUS)
#define pDMA9_PERIPHERAL_MAP 	((volatile unsigned short *)DMA9_PERIPHERAL_MAP)

#define pDMA10_CONFIG 		((volatile unsigned short *)DMA10_CONFIG)
#define pDMA10_NEXT_DESC_PTR 	(_PTR_TO_VOL_VOID_PTR DMA10_NEXT_DESC_PTR)
#define pDMA10_START_ADDR 	(_PTR_TO_VOL_VOID_PTR DMA10_START_ADDR)
#define pDMA10_X_COUNT 		((volatile unsigned short *)DMA10_X_COUNT)
#define pDMA10_Y_COUNT 		((volatile unsigned short *)DMA10_Y_COUNT)
#define pDMA10_X_MODIFY 	((volatile signed   short *)DMA10_X_MODIFY)
#define pDMA10_Y_MODIFY 	((volatile signed   short *)DMA10_Y_MODIFY)
#define pDMA10_CURR_DESC_PTR 	(_PTR_TO_VOL_VOID_PTR DMA10_CURR_DESC_PTR)
#define pDMA10_CURR_ADDR 	(_PTR_TO_VOL_VOID_PTR DMA10_CURR_ADDR)
#define pDMA10_CURR_X_COUNT 	((volatile unsigned short *)DMA10_CURR_X_COUNT)
#define pDMA10_CURR_Y_COUNT 	((volatile unsigned short *)DMA10_CURR_Y_COUNT)
#define pDMA10_IRQ_STATUS 	((volatile unsigned short *)DMA10_IRQ_STATUS)
#define pDMA10_PERIPHERAL_MAP 	((volatile unsigned short *)DMA10_PERIPHERAL_MAP)

#define pDMA11_CONFIG 		((volatile unsigned short *)DMA11_CONFIG)
#define pDMA11_NEXT_DESC_PTR 	(_PTR_TO_VOL_VOID_PTR DMA11_NEXT_DESC_PTR)
#define pDMA11_START_ADDR 	(_PTR_TO_VOL_VOID_PTR DMA11_START_ADDR)
#define pDMA11_X_COUNT 		((volatile unsigned short *)DMA11_X_COUNT)
#define pDMA11_Y_COUNT 		((volatile unsigned short *)DMA11_Y_COUNT)
#define pDMA11_X_MODIFY 	((volatile signed   short *)DMA11_X_MODIFY)
#define pDMA11_Y_MODIFY 	((volatile signed   short *)DMA11_Y_MODIFY)
#define pDMA11_CURR_DESC_PTR 	(_PTR_TO_VOL_VOID_PTR DMA11_CURR_DESC_PTR)
#define pDMA11_CURR_ADDR 	(_PTR_TO_VOL_VOID_PTR DMA11_CURR_ADDR)
#define pDMA11_CURR_X_COUNT 	((volatile unsigned short *)DMA11_CURR_X_COUNT)
#define pDMA11_CURR_Y_COUNT 	((volatile unsigned short *)DMA11_CURR_Y_COUNT)
#define pDMA11_IRQ_STATUS 	((volatile unsigned short *)DMA11_IRQ_STATUS)
#define pDMA11_PERIPHERAL_MAP 	((volatile unsigned short *)DMA11_PERIPHERAL_MAP)

#define pMDMA_D0_CONFIG 	((volatile unsigned short *)MDMA_D0_CONFIG)
#define pMDMA_D0_NEXT_DESC_PTR 	(_PTR_TO_VOL_VOID_PTR MDMA_D0_NEXT_DESC_PTR)
#define pMDMA_D0_START_ADDR 	(_PTR_TO_VOL_VOID_PTR MDMA_D0_START_ADDR)
#define pMDMA_D0_X_COUNT 	((volatile unsigned short *)MDMA_D0_X_COUNT)
#define pMDMA_D0_Y_COUNT 	((volatile unsigned short *)MDMA_D0_Y_COUNT)
#define pMDMA_D0_X_MODIFY 	((volatile signed   short *)MDMA_D0_X_MODIFY)
#define pMDMA_D0_Y_MODIFY 	((volatile signed   short *)MDMA_D0_Y_MODIFY)
#define pMDMA_D0_CURR_DESC_PTR 	(_PTR_TO_VOL_VOID_PTR MDMA_D0_CURR_DESC_PTR)
#define pMDMA_D0_CURR_ADDR 	(_PTR_TO_VOL_VOID_PTR MDMA_D0_CURR_ADDR)
#define pMDMA_D0_CURR_X_COUNT 	((volatile unsigned short *)MDMA_D0_CURR_X_COUNT)
#define pMDMA_D0_CURR_Y_COUNT 	((volatile unsigned short *)MDMA_D0_CURR_Y_COUNT)
#define pMDMA_D0_IRQ_STATUS 	((volatile unsigned short *)MDMA_D0_IRQ_STATUS)
#define pMDMA_D0_PERIPHERAL_MAP ((volatile unsigned short *)MDMA_D0_PERIPHERAL_MAP)

#define pMDMA_S0_CONFIG 	((volatile unsigned short *)MDMA_S0_CONFIG)
#define pMDMA_S0_NEXT_DESC_PTR 	(_PTR_TO_VOL_VOID_PTR MDMA_S0_NEXT_DESC_PTR)
#define pMDMA_S0_START_ADDR 	(_PTR_TO_VOL_VOID_PTR MDMA_S0_START_ADDR)
#define pMDMA_S0_X_COUNT 	((volatile unsigned short *)MDMA_S0_X_COUNT)
#define pMDMA_S0_Y_COUNT 	((volatile unsigned short *)MDMA_S0_Y_COUNT)
#define pMDMA_S0_X_MODIFY 	((volatile signed   short *)MDMA_S0_X_MODIFY)
#define pMDMA_S0_Y_MODIFY 	((volatile signed   short *)MDMA_S0_Y_MODIFY)
#define pMDMA_S0_CURR_DESC_PTR 	(_PTR_TO_VOL_VOID_PTR MDMA_S0_CURR_DESC_PTR)
#define pMDMA_S0_CURR_ADDR 	(_PTR_TO_VOL_VOID_PTR MDMA_S0_CURR_ADDR)
#define pMDMA_S0_CURR_X_COUNT 	((volatile unsigned short *)MDMA_S0_CURR_X_COUNT)
#define pMDMA_S0_CURR_Y_COUNT 	((volatile unsigned short *)MDMA_S0_CURR_Y_COUNT)
#define pMDMA_S0_IRQ_STATUS 	((volatile unsigned short *)MDMA_S0_IRQ_STATUS)
#define pMDMA_S0_PERIPHERAL_MAP	((volatile unsigned short *)MDMA_S0_PERIPHERAL_MAP)

#define pMDMA_D1_CONFIG 	((volatile unsigned short *)MDMA_D1_CONFIG)
#define pMDMA_D1_NEXT_DESC_PTR 	(_PTR_TO_VOL_VOID_PTR MDMA_D1_NEXT_DESC_PTR)
#define pMDMA_D1_START_ADDR 	(_PTR_TO_VOL_VOID_PTR MDMA_D1_START_ADDR)
#define pMDMA_D1_X_COUNT 	((volatile unsigned short *)MDMA_D1_X_COUNT)
#define pMDMA_D1_Y_COUNT 	((volatile unsigned short *)MDMA_D1_Y_COUNT)
#define pMDMA_D1_X_MODIFY 	((volatile signed   short *)MDMA_D1_X_MODIFY)
#define pMDMA_D1_Y_MODIFY 	((volatile signed   short *)MDMA_D1_Y_MODIFY)
#define pMDMA_D1_CURR_DESC_PTR 	(_PTR_TO_VOL_VOID_PTR MDMA_D1_CURR_DESC_PTR)
#define pMDMA_D1_CURR_ADDR 	(_PTR_TO_VOL_VOID_PTR MDMA_D1_CURR_ADDR)
#define pMDMA_D1_CURR_X_COUNT 	((volatile unsigned short *)MDMA_D1_CURR_X_COUNT)
#define pMDMA_D1_CURR_Y_COUNT 	((volatile unsigned short *)MDMA_D1_CURR_Y_COUNT)
#define pMDMA_D1_IRQ_STATUS 	((volatile unsigned short *)MDMA_D1_IRQ_STATUS)
#define pMDMA_D1_PERIPHERAL_MAP ((volatile unsigned short *)MDMA_D1_PERIPHERAL_MAP)

#define pMDMA_S1_CONFIG 	((volatile unsigned short *)MDMA_S1_CONFIG)
#define pMDMA_S1_NEXT_DESC_PTR 	(_PTR_TO_VOL_VOID_PTR MDMA_S1_NEXT_DESC_PTR)
#define pMDMA_S1_START_ADDR 	(_PTR_TO_VOL_VOID_PTR MDMA_S1_START_ADDR)
#define pMDMA_S1_X_COUNT 	((volatile unsigned short *)MDMA_S1_X_COUNT)
#define pMDMA_S1_Y_COUNT 	((volatile unsigned short *)MDMA_S1_Y_COUNT)
#define pMDMA_S1_X_MODIFY 	((volatile signed   short *)MDMA_S1_X_MODIFY)
#define pMDMA_S1_Y_MODIFY 	((volatile signed   short *)MDMA_S1_Y_MODIFY)
#define pMDMA_S1_CURR_DESC_PTR 	(_PTR_TO_VOL_VOID_PTR MDMA_S1_CURR_DESC_PTR)
#define pMDMA_S1_CURR_ADDR 	(_PTR_TO_VOL_VOID_PTR MDMA_S1_CURR_ADDR)
#define pMDMA_S1_CURR_X_COUNT 	((volatile unsigned short *)MDMA_S1_CURR_X_COUNT)
#define pMDMA_S1_CURR_Y_COUNT 	((volatile unsigned short *)MDMA_S1_CURR_Y_COUNT)
#define pMDMA_S1_IRQ_STATUS 	((volatile unsigned short *)MDMA_S1_IRQ_STATUS)
#define pMDMA_S1_PERIPHERAL_MAP ((volatile unsigned short *)MDMA_S1_PERIPHERAL_MAP)


/* Parallel Peripheral Interface (0xFFC01000 - 0xFFC010FF)							*/
#define pPPI_CONTROL 		((volatile unsigned short *)PPI_CONTROL)
#define pPPI_STATUS 		((volatile unsigned short *)PPI_STATUS)
#define pPPI_DELAY 		((volatile unsigned short *)PPI_DELAY)
#define pPPI_COUNT 		((volatile unsigned short *)PPI_COUNT)
#define pPPI_FRAME 		((volatile unsigned short *)PPI_FRAME)


/* Two-Wire Interface		(0xFFC01400 - 0xFFC014FF)								*/
#define pTWI_CLKDIV		((volatile unsigned short *)TWI_CLKDIV)
#define pTWI_CONTROL		((volatile unsigned short *)TWI_CONTROL)
#define pTWI_SLAVE_CTL		((volatile unsigned short *)TWI_SLAVE_CTL)
#define pTWI_SLAVE_STAT		((volatile unsigned short *)TWI_SLAVE_STAT)
#define pTWI_SLAVE_ADDR		((volatile unsigned short *)TWI_SLAVE_ADDR)
#define pTWI_MASTER_CTL		((volatile unsigned short *)TWI_MASTER_CTL)
#define pTWI_MASTER_STAT	((volatile unsigned short *)TWI_MASTER_STAT)
#define pTWI_MASTER_ADDR	((volatile unsigned short *)TWI_MASTER_ADDR)
#define pTWI_INT_STAT		((volatile unsigned short *)TWI_INT_STAT)
#define pTWI_INT_MASK		((volatile unsigned short *)TWI_INT_MASK)
#define pTWI_FIFO_CTL		((volatile unsigned short *)TWI_FIFO_CTL)
#define pTWI_FIFO_STAT		((volatile unsigned short *)TWI_FIFO_STAT)
#define pTWI_XMT_DATA8		((volatile unsigned short *)TWI_XMT_DATA8)
#define pTWI_XMT_DATA16		((volatile unsigned short *)TWI_XMT_DATA16)
#define pTWI_RCV_DATA8		((volatile unsigned short *)TWI_RCV_DATA8)
#define pTWI_RCV_DATA16		((volatile unsigned short *)TWI_RCV_DATA16)


/* General Purpose I/O Port G (0xFFC01500 - 0xFFC015FF)								*/
#define pPORTGIO	 	((volatile unsigned short *)PORTGIO)
#define pPORTGIO_CLEAR	 	((volatile unsigned short *)PORTGIO_CLEAR)
#define pPORTGIO_SET	 	((volatile unsigned short *)PORTGIO_SET)
#define pPORTGIO_TOGGLE 	((volatile unsigned short *)PORTGIO_TOGGLE)
#define pPORTGIO_MASKA		((volatile unsigned short *)PORTGIO_MASKA)
#define pPORTGIO_MASKA_CLEAR	((volatile unsigned short *)PORTGIO_MASKA_CLEAR)
#define pPORTGIO_MASKA_SET	((volatile unsigned short *)PORTGIO_MASKA_SET)
#define pPORTGIO_MASKA_TOGGLE	((volatile unsigned short *)PORTGIO_MASKA_TOGGLE)
#define pPORTGIO_MASKB		((volatile unsigned short *)PORTGIO_MASKB)
#define pPORTGIO_MASKB_CLEAR	((volatile unsigned short *)PORTGIO_MASKB_CLEAR)
#define pPORTGIO_MASKB_SET	((volatile unsigned short *)PORTGIO_MASKB_SET)
#define pPORTGIO_MASKB_TOGGLE	((volatile unsigned short *)PORTGIO_MASKB_TOGGLE)
#define pPORTGIO_DIR 		((volatile unsigned short *)PORTGIO_DIR)
#define pPORTGIO_POLAR 		((volatile unsigned short *)PORTGIO_POLAR)
#define pPORTGIO_EDGE 		((volatile unsigned short *)PORTGIO_EDGE)
#define pPORTGIO_BOTH 		((volatile unsigned short *)PORTGIO_BOTH)
#define pPORTGIO_INEN 		((volatile unsigned short *)PORTGIO_INEN)


/* General Purpose I/O Port H (0xFFC01700 - 0xFFC017FF)								*/
#define pPORTHIO	 	((volatile unsigned short *)PORTHIO)
#define pPORTHIO_CLEAR	 	((volatile unsigned short *)PORTHIO_CLEAR)
#define pPORTHIO_SET	 	((volatile unsigned short *)PORTHIO_SET)
#define pPORTHIO_TOGGLE 	((volatile unsigned short *)PORTHIO_TOGGLE)
#define pPORTHIO_MASKA		((volatile unsigned short *)PORTHIO_MASKA)
#define pPORTHIO_MASKA_CLEAR	((volatile unsigned short *)PORTHIO_MASKA_CLEAR)
#define pPORTHIO_MASKA_SET	((volatile unsigned short *)PORTHIO_MASKA_SET)
#define pPORTHIO_MASKA_TOGGLE	((volatile unsigned short *)PORTHIO_MASKA_TOGGLE)
#define pPORTHIO_MASKB		((volatile unsigned short *)PORTHIO_MASKB)
#define pPORTHIO_MASKB_CLEAR	((volatile unsigned short *)PORTHIO_MASKB_CLEAR)
#define pPORTHIO_MASKB_SET	((volatile unsigned short *)PORTHIO_MASKB_SET)
#define pPORTHIO_MASKB_TOGGLE	((volatile unsigned short *)PORTHIO_MASKB_TOGGLE)
#define pPORTHIO_DIR 		((volatile unsigned short *)PORTHIO_DIR)
#define pPORTHIO_POLAR 		((volatile unsigned short *)PORTHIO_POLAR)
#define pPORTHIO_EDGE 		((volatile unsigned short *)PORTHIO_EDGE)
#define pPORTHIO_BOTH 		((volatile unsigned short *)PORTHIO_BOTH)
#define pPORTHIO_INEN 		((volatile unsigned short *)PORTHIO_INEN)


/* UART1 Controller		(0xFFC02000 - 0xFFC020FF)								*/
#define pUART1_THR 		((volatile unsigned short *)UART1_THR)
#define pUART1_RBR 		((volatile unsigned short *)UART1_RBR)
#define pUART1_DLL 		((volatile unsigned short *)UART1_DLL)
#define pUART1_IER 		((volatile unsigned short *)UART1_IER)
#define pUART1_DLH 		((volatile unsigned short *)UART1_DLH)
#define pUART1_IIR 		((volatile unsigned short *)UART1_IIR)
#define pUART1_LCR 		((volatile unsigned short *)UART1_LCR)
#define pUART1_MCR 		((volatile unsigned short *)UART1_MCR)
#define pUART1_LSR 		((volatile unsigned short *)UART1_LSR)
#define pUART1_MSR		((volatile unsigned short *)UART1_LSR)
#define pUART1_SCR 		((volatile unsigned short *)UART1_SCR)
#define pUART1_GCTL 		((volatile unsigned short *)UART1_GCTL)


/* CAN Controller		(0xFFC02A00 - 0xFFC02FFF)								*/
/* For Mailboxes 0-15 */
#define pCAN_MC1		((volatile unsigned short *)CAN_MC1)
#define pCAN_MD1		((volatile unsigned short *)CAN_MD1)
#define pCAN_TRS1		((volatile unsigned short *)CAN_TRS1)
#define pCAN_TRR1		((volatile unsigned short *)CAN_TRR1)
#define pCAN_TA1		((volatile unsigned short *)CAN_TA1)
#define pCAN_AA1		((volatile unsigned short *)CAN_AA1)
#define pCAN_RMP1		((volatile unsigned short *)CAN_RMP1)
#define pCAN_RML1		((volatile unsigned short *)CAN_RML1)
#define pCAN_MBTIF1		((volatile unsigned short *)CAN_MBTIF1)
#define pCAN_MBRIF1		((volatile unsigned short *)CAN_MBRIF1)
#define pCAN_MBIM1		((volatile unsigned short *)CAN_MBIM1)
#define pCAN_RFH1		((volatile unsigned short *)CAN_RFH1)
#define pCAN_OPSS1		((volatile unsigned short *)CAN_OPSS1)

/* For Mailboxes 16-31 */
#define pCAN_MC2		((volatile unsigned short *)CAN_MC2)
#define pCAN_MD2		((volatile unsigned short *)CAN_MD2)
#define pCAN_TRS2		((volatile unsigned short *)CAN_TRS2)
#define pCAN_TRR2		((volatile unsigned short *)CAN_TRR2)
#define pCAN_TA2		((volatile unsigned short *)CAN_TA2)
#define pCAN_AA2		((volatile unsigned short *)CAN_AA2)
#define pCAN_RMP2		((volatile unsigned short *)CAN_RMP2)
#define pCAN_RML2		((volatile unsigned short *)CAN_RML2)
#define pCAN_MBTIF2		((volatile unsigned short *)CAN_MBTIF2)
#define pCAN_MBRIF2		((volatile unsigned short *)CAN_MBRIF2)
#define pCAN_MBIM2		((volatile unsigned short *)CAN_MBIM2)
#define pCAN_RFH2		((volatile unsigned short *)CAN_RFH2)
#define pCAN_OPSS2		((volatile unsigned short *)CAN_OPSS2)

#define pCAN_CLOCK		((volatile unsigned short *)CAN_CLOCK)
#define pCAN_TIMING		((volatile unsigned short *)CAN_TIMING)
#define pCAN_DEBUG		((volatile unsigned short *)CAN_DEBUG)
#define pCAN_STATUS		((volatile unsigned short *)CAN_STATUS)
#define pCAN_CEC		((volatile unsigned short *)CAN_CEC)
#define pCAN_GIS		((volatile unsigned short *)CAN_GIS)
#define pCAN_GIM		((volatile unsigned short *)CAN_GIM)
#define pCAN_GIF		((volatile unsigned short *)CAN_GIF)
#define pCAN_CONTROL		((volatile unsigned short *)CAN_CONTROL)
#define pCAN_INTR		((volatile unsigned short *)CAN_INTR)
#define pCAN_MBTD		((volatile unsigned short *)CAN_MBTD)
#define pCAN_EWR		((volatile unsigned short *)CAN_EWR)
#define pCAN_ESR		((volatile unsigned short *)CAN_ESR)
#define pCAN_UCREG		((volatile unsigned short *)CAN_UCREG)
#define pCAN_UCCNT		((volatile unsigned short *)CAN_UCCNT)
#define pCAN_UCRC		((volatile unsigned short *)CAN_UCRC)
#define pCAN_UCCNF		((volatile unsigned short *)CAN_UCCNF)

/* Mailbox Acceptance Masks */
#define pCAN_AM00L		((volatile unsigned short *)CAN_AM00L)
#define pCAN_AM00H		((volatile unsigned short *)CAN_AM00H)
#define pCAN_AM01L		((volatile unsigned short *)CAN_AM01L)
#define pCAN_AM01H		((volatile unsigned short *)CAN_AM01H)
#define pCAN_AM02L		((volatile unsigned short *)CAN_AM02L)
#define pCAN_AM02H		((volatile unsigned short *)CAN_AM02H)
#define pCAN_AM03L		((volatile unsigned short *)CAN_AM03L)
#define pCAN_AM03H		((volatile unsigned short *)CAN_AM03H)
#define pCAN_AM04L		((volatile unsigned short *)CAN_AM04L)
#define pCAN_AM04H		((volatile unsigned short *)CAN_AM04H)
#define pCAN_AM05L		((volatile unsigned short *)CAN_AM05L)
#define pCAN_AM05H		((volatile unsigned short *)CAN_AM05H)
#define pCAN_AM06L		((volatile unsigned short *)CAN_AM06L)
#define pCAN_AM06H		((volatile unsigned short *)CAN_AM06H)
#define pCAN_AM07L		((volatile unsigned short *)CAN_AM07L)
#define pCAN_AM07H		((volatile unsigned short *)CAN_AM07H)
#define pCAN_AM08L		((volatile unsigned short *)CAN_AM08L)
#define pCAN_AM08H		((volatile unsigned short *)CAN_AM08H)
#define pCAN_AM09L		((volatile unsigned short *)CAN_AM09L)
#define pCAN_AM09H		((volatile unsigned short *)CAN_AM09H)
#define pCAN_AM10L		((volatile unsigned short *)CAN_AM10L)
#define pCAN_AM10H		((volatile unsigned short *)CAN_AM10H)
#define pCAN_AM11L		((volatile unsigned short *)CAN_AM11L)
#define pCAN_AM11H		((volatile unsigned short *)CAN_AM11H)
#define pCAN_AM12L		((volatile unsigned short *)CAN_AM12L)
#define pCAN_AM12H		((volatile unsigned short *)CAN_AM12H)
#define pCAN_AM13L		((volatile unsigned short *)CAN_AM13L)
#define pCAN_AM13H		((volatile unsigned short *)CAN_AM13H)
#define pCAN_AM14L		((volatile unsigned short *)CAN_AM14L)
#define pCAN_AM14H		((volatile unsigned short *)CAN_AM14H)
#define pCAN_AM15L		((volatile unsigned short *)CAN_AM15L)
#define pCAN_AM15H		((volatile unsigned short *)CAN_AM15H)

#define pCAN_AM16L		((volatile unsigned short *)CAN_AM16L)
#define pCAN_AM16H		((volatile unsigned short *)CAN_AM16H)
#define pCAN_AM17L		((volatile unsigned short *)CAN_AM17L)
#define pCAN_AM17H		((volatile unsigned short *)CAN_AM17H)
#define pCAN_AM18L		((volatile unsigned short *)CAN_AM18L)
#define pCAN_AM18H		((volatile unsigned short *)CAN_AM18H)
#define pCAN_AM19L		((volatile unsigned short *)CAN_AM19L)
#define pCAN_AM19H		((volatile unsigned short *)CAN_AM19H)
#define pCAN_AM20L		((volatile unsigned short *)CAN_AM20L)
#define pCAN_AM20H		((volatile unsigned short *)CAN_AM20H)
#define pCAN_AM21L		((volatile unsigned short *)CAN_AM21L)
#define pCAN_AM21H		((volatile unsigned short *)CAN_AM21H)
#define pCAN_AM22L		((volatile unsigned short *)CAN_AM22L)
#define pCAN_AM22H		((volatile unsigned short *)CAN_AM22H)
#define pCAN_AM23L		((volatile unsigned short *)CAN_AM23L)
#define pCAN_AM23H		((volatile unsigned short *)CAN_AM23H)
#define pCAN_AM24L		((volatile unsigned short *)CAN_AM24L)
#define pCAN_AM24H		((volatile unsigned short *)CAN_AM24H)
#define pCAN_AM25L		((volatile unsigned short *)CAN_AM25L)
#define pCAN_AM25H		((volatile unsigned short *)CAN_AM25H)
#define pCAN_AM26L		((volatile unsigned short *)CAN_AM26L)
#define pCAN_AM26H		((volatile unsigned short *)CAN_AM26H)
#define pCAN_AM27L		((volatile unsigned short *)CAN_AM27L)
#define pCAN_AM27H		((volatile unsigned short *)CAN_AM27H)
#define pCAN_AM28L		((volatile unsigned short *)CAN_AM28L)
#define pCAN_AM28H		((volatile unsigned short *)CAN_AM28H)
#define pCAN_AM29L		((volatile unsigned short *)CAN_AM29L)
#define pCAN_AM29H		((volatile unsigned short *)CAN_AM29H)
#define pCAN_AM30L		((volatile unsigned short *)CAN_AM30L)
#define pCAN_AM30H		((volatile unsigned short *)CAN_AM30H)
#define pCAN_AM31L		((volatile unsigned short *)CAN_AM31L)
#define pCAN_AM31H		((volatile unsigned short *)CAN_AM31H)

/* CAN Acceptance Mask Area Macros	*/
#define pCAN_AM_L(x)		((volatile unsigned short *)CAN_AM_L(x))
#define pCAN_AM_H(x)		((volatile unsigned short *)CAN_AM_H(x))

/* Mailbox Registers */
#define pCAN_MB00_ID1		((volatile unsigned short *)CAN_MB00_ID1)
#define pCAN_MB00_ID0		((volatile unsigned short *)CAN_MB00_ID0)
#define pCAN_MB00_TIMESTAMP	((volatile unsigned short *)CAN_MB00_TIMESTAMP)
#define pCAN_MB00_LENGTH	((volatile unsigned short *)CAN_MB00_LENGTH)
#define pCAN_MB00_DATA3		((volatile unsigned short *)CAN_MB00_DATA3)
#define pCAN_MB00_DATA2		((volatile unsigned short *)CAN_MB00_DATA2)
#define pCAN_MB00_DATA1		((volatile unsigned short *)CAN_MB00_DATA1)
#define pCAN_MB00_DATA0		((volatile unsigned short *)CAN_MB00_DATA0)

#define pCAN_MB01_ID1		((volatile unsigned short *)CAN_MB01_ID1)
#define pCAN_MB01_ID0		((volatile unsigned short *)CAN_MB01_ID0)
#define pCAN_MB01_TIMESTAMP	((volatile unsigned short *)CAN_MB01_TIMESTAMP)
#define pCAN_MB01_LENGTH	((volatile unsigned short *)CAN_MB01_LENGTH)
#define pCAN_MB01_DATA3		((volatile unsigned short *)CAN_MB01_DATA3)
#define pCAN_MB01_DATA2		((volatile unsigned short *)CAN_MB01_DATA2)
#define pCAN_MB01_DATA1		((volatile unsigned short *)CAN_MB01_DATA1)
#define pCAN_MB01_DATA0		((volatile unsigned short *)CAN_MB01_DATA0)

#define pCAN_MB02_ID1		((volatile unsigned short *)CAN_MB02_ID1)
#define pCAN_MB02_ID0		((volatile unsigned short *)CAN_MB02_ID0)
#define pCAN_MB02_TIMESTAMP	((volatile unsigned short *)CAN_MB02_TIMESTAMP)
#define pCAN_MB02_LENGTH	((volatile unsigned short *)CAN_MB02_LENGTH)
#define pCAN_MB02_DATA3		((volatile unsigned short *)CAN_MB02_DATA3)
#define pCAN_MB02_DATA2		((volatile unsigned short *)CAN_MB02_DATA2)
#define pCAN_MB02_DATA1		((volatile unsigned short *)CAN_MB02_DATA1)
#define pCAN_MB02_DATA0		((volatile unsigned short *)CAN_MB02_DATA0)

#define pCAN_MB03_ID1		((volatile unsigned short *)CAN_MB03_ID1)
#define pCAN_MB03_ID0		((volatile unsigned short *)CAN_MB03_ID0)
#define pCAN_MB03_TIMESTAMP	((volatile unsigned short *)CAN_MB03_TIMESTAMP)
#define pCAN_MB03_LENGTH	((volatile unsigned short *)CAN_MB03_LENGTH)
#define pCAN_MB03_DATA3		((volatile unsigned short *)CAN_MB03_DATA3)
#define pCAN_MB03_DATA2		((volatile unsigned short *)CAN_MB03_DATA2)
#define pCAN_MB03_DATA1		((volatile unsigned short *)CAN_MB03_DATA1)
#define pCAN_MB03_DATA0		((volatile unsigned short *)CAN_MB03_DATA0)

#define pCAN_MB04_ID1		((volatile unsigned short *)CAN_MB04_ID1)
#define pCAN_MB04_ID0		((volatile unsigned short *)CAN_MB04_ID0)
#define pCAN_MB04_TIMESTAMP	((volatile unsigned short *)CAN_MB04_TIMESTAMP)
#define pCAN_MB04_LENGTH	((volatile unsigned short *)CAN_MB04_LENGTH)
#define pCAN_MB04_DATA3		((volatile unsigned short *)CAN_MB04_DATA3)
#define pCAN_MB04_DATA2		((volatile unsigned short *)CAN_MB04_DATA2)
#define pCAN_MB04_DATA1		((volatile unsigned short *)CAN_MB04_DATA1)
#define pCAN_MB04_DATA0		((volatile unsigned short *)CAN_MB04_DATA0)

#define pCAN_MB05_ID1		((volatile unsigned short *)CAN_MB05_ID1)
#define pCAN_MB05_ID0		((volatile unsigned short *)CAN_MB05_ID0)
#define pCAN_MB05_TIMESTAMP	((volatile unsigned short *)CAN_MB05_TIMESTAMP)
#define pCAN_MB05_LENGTH	((volatile unsigned short *)CAN_MB05_LENGTH)
#define pCAN_MB05_DATA3		((volatile unsigned short *)CAN_MB05_DATA3)
#define pCAN_MB05_DATA2		((volatile unsigned short *)CAN_MB05_DATA2)
#define pCAN_MB05_DATA1		((volatile unsigned short *)CAN_MB05_DATA1)
#define pCAN_MB05_DATA0		((volatile unsigned short *)CAN_MB05_DATA0)

#define pCAN_MB06_ID1		((volatile unsigned short *)CAN_MB06_ID1)
#define pCAN_MB06_ID0		((volatile unsigned short *)CAN_MB06_ID0)
#define pCAN_MB06_TIMESTAMP	((volatile unsigned short *)CAN_MB06_TIMESTAMP)
#define pCAN_MB06_LENGTH	((volatile unsigned short *)CAN_MB06_LENGTH)
#define pCAN_MB06_DATA3		((volatile unsigned short *)CAN_MB06_DATA3)
#define pCAN_MB06_DATA2		((volatile unsigned short *)CAN_MB06_DATA2)
#define pCAN_MB06_DATA1		((volatile unsigned short *)CAN_MB06_DATA1)
#define pCAN_MB06_DATA0		((volatile unsigned short *)CAN_MB06_DATA0)

#define pCAN_MB07_ID1		((volatile unsigned short *)CAN_MB07_ID1)
#define pCAN_MB07_ID0		((volatile unsigned short *)CAN_MB07_ID0)
#define pCAN_MB07_TIMESTAMP	((volatile unsigned short *)CAN_MB07_TIMESTAMP)
#define pCAN_MB07_LENGTH	((volatile unsigned short *)CAN_MB07_LENGTH)
#define pCAN_MB07_DATA3		((volatile unsigned short *)CAN_MB07_DATA3) 
#define pCAN_MB07_DATA2		((volatile unsigned short *)CAN_MB07_DATA2)
#define pCAN_MB07_DATA1		((volatile unsigned short *)CAN_MB07_DATA1)
#define pCAN_MB07_DATA0		((volatile unsigned short *)CAN_MB07_DATA0)

#define pCAN_MB08_ID1		((volatile unsigned short *)CAN_MB08_ID1)		
#define pCAN_MB08_ID0		((volatile unsigned short *)CAN_MB08_ID0)		
#define pCAN_MB08_TIMESTAMP	((volatile unsigned short *)CAN_MB08_TIMESTAMP)	
#define pCAN_MB08_LENGTH	((volatile unsigned short *)CAN_MB08_LENGTH)	
#define pCAN_MB08_DATA3		((volatile unsigned short *)CAN_MB08_DATA3)	
#define pCAN_MB08_DATA2		((volatile unsigned short *)CAN_MB08_DATA2)	
#define pCAN_MB08_DATA1		((volatile unsigned short *)CAN_MB08_DATA1)	
#define pCAN_MB08_DATA0		((volatile unsigned short *)CAN_MB08_DATA0)	

#define pCAN_MB09_ID1		((volatile unsigned short *)CAN_MB09_ID1)	
#define pCAN_MB09_ID0		((volatile unsigned short *)CAN_MB09_ID0)	
#define pCAN_MB09_TIMESTAMP	((volatile unsigned short *)CAN_MB09_TIMESTAMP)	
#define pCAN_MB09_LENGTH	((volatile unsigned short *)CAN_MB09_LENGTH)	
#define pCAN_MB09_DATA3		((volatile unsigned short *)CAN_MB09_DATA3)	
#define pCAN_MB09_DATA2		((volatile unsigned short *)CAN_MB09_DATA2)	
#define pCAN_MB09_DATA1		((volatile unsigned short *)CAN_MB09_DATA1)	
#define pCAN_MB09_DATA0		((volatile unsigned short *)CAN_MB09_DATA0)	

#define pCAN_MB10_ID1		((volatile unsigned short *)CAN_MB10_ID1)	
#define pCAN_MB10_ID0		((volatile unsigned short *)CAN_MB10_ID0)	
#define pCAN_MB10_TIMESTAMP	((volatile unsigned short *)CAN_MB10_TIMESTAMP)	
#define pCAN_MB10_LENGTH	((volatile unsigned short *)CAN_MB10_LENGTH)	
#define pCAN_MB10_DATA3		((volatile unsigned short *)CAN_MB10_DATA3)	
#define pCAN_MB10_DATA2		((volatile unsigned short *)CAN_MB10_DATA2)	
#define pCAN_MB10_DATA1		((volatile unsigned short *)CAN_MB10_DATA1)	
#define pCAN_MB10_DATA0		((volatile unsigned short *)CAN_MB10_DATA0)	

#define pCAN_MB11_ID1		((volatile unsigned short *)CAN_MB11_ID1)	
#define pCAN_MB11_ID0		((volatile unsigned short *)CAN_MB11_ID0)	
#define pCAN_MB11_TIMESTAMP	((volatile unsigned short *)CAN_MB11_TIMESTAMP)	
#define pCAN_MB11_LENGTH	((volatile unsigned short *)CAN_MB11_LENGTH)	
#define pCAN_MB11_DATA3		((volatile unsigned short *)CAN_MB11_DATA3)	
#define pCAN_MB11_DATA2		((volatile unsigned short *)CAN_MB11_DATA2)	
#define pCAN_MB11_DATA1		((volatile unsigned short *)CAN_MB11_DATA1)	
#define pCAN_MB11_DATA0		((volatile unsigned short *)CAN_MB11_DATA0)	

#define pCAN_MB12_ID1		((volatile unsigned short *)CAN_MB12_ID1)
#define pCAN_MB12_ID0		((volatile unsigned short *)CAN_MB12_ID0)
#define pCAN_MB12_TIMESTAMP	((volatile unsigned short *)CAN_MB12_TIMESTAMP)
#define pCAN_MB12_LENGTH	((volatile unsigned short *)CAN_MB12_LENGTH)
#define pCAN_MB12_DATA3		((volatile unsigned short *)CAN_MB12_DATA3)
#define pCAN_MB12_DATA2		((volatile unsigned short *)CAN_MB12_DATA2)
#define pCAN_MB12_DATA1		((volatile unsigned short *)CAN_MB12_DATA1)
#define pCAN_MB12_DATA0		((volatile unsigned short *)CAN_MB12_DATA0)

#define pCAN_MB13_ID1		((volatile unsigned short *)CAN_MB13_ID1)
#define pCAN_MB13_ID0		((volatile unsigned short *)CAN_MB13_ID0)
#define pCAN_MB13_TIMESTAMP	((volatile unsigned short *)CAN_MB13_TIMESTAMP)
#define pCAN_MB13_LENGTH	((volatile unsigned short *)CAN_MB13_LENGTH)
#define pCAN_MB13_DATA3		((volatile unsigned short *)CAN_MB13_DATA3)
#define pCAN_MB13_DATA2		((volatile unsigned short *)CAN_MB13_DATA2)
#define pCAN_MB13_DATA1		((volatile unsigned short *)CAN_MB13_DATA1)
#define pCAN_MB13_DATA0		((volatile unsigned short *)CAN_MB13_DATA0)

#define pCAN_MB14_ID1		((volatile unsigned short *)CAN_MB14_ID1)
#define pCAN_MB14_ID0		((volatile unsigned short *)CAN_MB14_ID0)
#define pCAN_MB14_TIMESTAMP	((volatile unsigned short *)CAN_MB14_TIMESTAMP)
#define pCAN_MB14_LENGTH	((volatile unsigned short *)CAN_MB14_LENGTH)
#define pCAN_MB14_DATA3		((volatile unsigned short *)CAN_MB14_DATA3)
#define pCAN_MB14_DATA2		((volatile unsigned short *)CAN_MB14_DATA2)
#define pCAN_MB14_DATA1		((volatile unsigned short *)CAN_MB14_DATA1)
#define pCAN_MB14_DATA0		((volatile unsigned short *)CAN_MB14_DATA0)

#define pCAN_MB15_ID1		((volatile unsigned short *)CAN_MB15_ID1)
#define pCAN_MB15_ID0		((volatile unsigned short *)CAN_MB15_ID0)
#define pCAN_MB15_TIMESTAMP	((volatile unsigned short *)CAN_MB15_TIMESTAMP)
#define pCAN_MB15_LENGTH	((volatile unsigned short *)CAN_MB15_LENGTH)
#define pCAN_MB15_DATA3		((volatile unsigned short *)CAN_MB15_DATA3)
#define pCAN_MB15_DATA2		((volatile unsigned short *)CAN_MB15_DATA2)
#define pCAN_MB15_DATA1		((volatile unsigned short *)CAN_MB15_DATA1)
#define pCAN_MB15_DATA0		((volatile unsigned short *)CAN_MB15_DATA0)

#define pCAN_MB16_ID1		((volatile unsigned short *)CAN_MB16_ID1)
#define pCAN_MB16_ID0		((volatile unsigned short *)CAN_MB16_ID0)
#define pCAN_MB16_TIMESTAMP	((volatile unsigned short *)CAN_MB16_TIMESTAMP)
#define pCAN_MB16_LENGTH	((volatile unsigned short *)CAN_MB16_LENGTH)
#define pCAN_MB16_DATA3		((volatile unsigned short *)CAN_MB16_DATA3)
#define pCAN_MB16_DATA2		((volatile unsigned short *)CAN_MB16_DATA2)
#define pCAN_MB16_DATA1		((volatile unsigned short *)CAN_MB16_DATA1)
#define pCAN_MB16_DATA0		((volatile unsigned short *)CAN_MB16_DATA0)

#define pCAN_MB17_ID1		((volatile unsigned short *)CAN_MB17_ID1)
#define pCAN_MB17_ID0		((volatile unsigned short *)CAN_MB17_ID0)
#define pCAN_MB17_TIMESTAMP	((volatile unsigned short *)CAN_MB17_TIMESTAMP)
#define pCAN_MB17_LENGTH	((volatile unsigned short *)CAN_MB17_LENGTH)
#define pCAN_MB17_DATA3		((volatile unsigned short *)CAN_MB17_DATA3)
#define pCAN_MB17_DATA2		((volatile unsigned short *)CAN_MB17_DATA2)
#define pCAN_MB17_DATA1		((volatile unsigned short *)CAN_MB17_DATA1)
#define pCAN_MB17_DATA0		((volatile unsigned short *)CAN_MB17_DATA0)

#define pCAN_MB18_ID1		((volatile unsigned short *)CAN_MB18_ID1)
#define pCAN_MB18_ID0		((volatile unsigned short *)CAN_MB18_ID0)
#define pCAN_MB18_TIMESTAMP	((volatile unsigned short *)CAN_MB18_TIMESTAMP)
#define pCAN_MB18_LENGTH	((volatile unsigned short *)CAN_MB18_LENGTH)
#define pCAN_MB18_DATA3		((volatile unsigned short *)CAN_MB18_DATA3)
#define pCAN_MB18_DATA2		((volatile unsigned short *)CAN_MB18_DATA2)
#define pCAN_MB18_DATA1		((volatile unsigned short *)CAN_MB18_DATA1)
#define pCAN_MB18_DATA0		((volatile unsigned short *)CAN_MB18_DATA0)

#define pCAN_MB19_ID1		((volatile unsigned short *)CAN_MB19_ID1)
#define pCAN_MB19_ID0		((volatile unsigned short *)CAN_MB19_ID0)
#define pCAN_MB19_TIMESTAMP	((volatile unsigned short *)CAN_MB19_TIMESTAMP)
#define pCAN_MB19_LENGTH	((volatile unsigned short *)CAN_MB19_LENGTH)
#define pCAN_MB19_DATA3		((volatile unsigned short *)CAN_MB19_DATA3)
#define pCAN_MB19_DATA2		((volatile unsigned short *)CAN_MB19_DATA2)
#define pCAN_MB19_DATA1		((volatile unsigned short *)CAN_MB19_DATA1)
#define pCAN_MB19_DATA0		((volatile unsigned short *)CAN_MB19_DATA0)

#define pCAN_MB20_ID1		((volatile unsigned short *)CAN_MB20_ID1)
#define pCAN_MB20_ID0		((volatile unsigned short *)CAN_MB20_ID0)
#define pCAN_MB20_TIMESTAMP	((volatile unsigned short *)CAN_MB20_TIMESTAMP)
#define pCAN_MB20_LENGTH	((volatile unsigned short *)CAN_MB20_LENGTH)
#define pCAN_MB20_DATA3		((volatile unsigned short *)CAN_MB20_DATA3)
#define pCAN_MB20_DATA2		((volatile unsigned short *)CAN_MB20_DATA2)
#define pCAN_MB20_DATA1		((volatile unsigned short *)CAN_MB20_DATA1)
#define pCAN_MB20_DATA0		((volatile unsigned short *)CAN_MB20_DATA0)

#define pCAN_MB21_ID1		((volatile unsigned short *)CAN_MB21_ID1)
#define pCAN_MB21_ID0		((volatile unsigned short *)CAN_MB21_ID0)
#define pCAN_MB21_TIMESTAMP	((volatile unsigned short *)CAN_MB21_TIMESTAMP)
#define pCAN_MB21_LENGTH	((volatile unsigned short *)CAN_MB21_LENGTH)
#define pCAN_MB21_DATA3		((volatile unsigned short *)CAN_MB21_DATA3)
#define pCAN_MB21_DATA2		((volatile unsigned short *)CAN_MB21_DATA2)
#define pCAN_MB21_DATA1		((volatile unsigned short *)CAN_MB21_DATA1)
#define pCAN_MB21_DATA0		((volatile unsigned short *)CAN_MB21_DATA0)

#define pCAN_MB22_ID1		((volatile unsigned short *)CAN_MB22_ID1)
#define pCAN_MB22_ID0		((volatile unsigned short *)CAN_MB22_ID0)
#define pCAN_MB22_TIMESTAMP	((volatile unsigned short *)CAN_MB22_TIMESTAMP)
#define pCAN_MB22_LENGTH	((volatile unsigned short *)CAN_MB22_LENGTH)
#define pCAN_MB22_DATA3		((volatile unsigned short *)CAN_MB22_DATA3)
#define pCAN_MB22_DATA2		((volatile unsigned short *)CAN_MB22_DATA2)
#define pCAN_MB22_DATA1		((volatile unsigned short *)CAN_MB22_DATA1)
#define pCAN_MB22_DATA0		((volatile unsigned short *)CAN_MB22_DATA0)

#define pCAN_MB23_ID1		((volatile unsigned short *)CAN_MB23_ID1)
#define pCAN_MB23_ID0		((volatile unsigned short *)CAN_MB23_ID0)
#define pCAN_MB23_TIMESTAMP	((volatile unsigned short *)CAN_MB23_TIMESTAMP)
#define pCAN_MB23_LENGTH	((volatile unsigned short *)CAN_MB23_LENGTH)
#define pCAN_MB23_DATA3		((volatile unsigned short *)CAN_MB23_DATA3)
#define pCAN_MB23_DATA2		((volatile unsigned short *)CAN_MB23_DATA2)
#define pCAN_MB23_DATA1		((volatile unsigned short *)CAN_MB23_DATA1)
#define pCAN_MB23_DATA0		((volatile unsigned short *)CAN_MB23_DATA0)

#define pCAN_MB24_ID1		((volatile unsigned short *)CAN_MB24_ID1)
#define pCAN_MB24_ID0		((volatile unsigned short *)CAN_MB24_ID0)
#define pCAN_MB24_TIMESTAMP	((volatile unsigned short *)CAN_MB24_TIMESTAMP)
#define pCAN_MB24_LENGTH	((volatile unsigned short *)CAN_MB24_LENGTH)
#define pCAN_MB24_DATA3		((volatile unsigned short *)CAN_MB24_DATA3)
#define pCAN_MB24_DATA2		((volatile unsigned short *)CAN_MB24_DATA2)
#define pCAN_MB24_DATA1		((volatile unsigned short *)CAN_MB24_DATA1)
#define pCAN_MB24_DATA0		((volatile unsigned short *)CAN_MB24_DATA0)

#define pCAN_MB25_ID1		((volatile unsigned short *)CAN_MB25_ID1)
#define pCAN_MB25_ID0		((volatile unsigned short *)CAN_MB25_ID0)
#define pCAN_MB25_TIMESTAMP	((volatile unsigned short *)CAN_MB25_TIMESTAMP)
#define pCAN_MB25_LENGTH	((volatile unsigned short *)CAN_MB25_LENGTH)
#define pCAN_MB25_DATA3		((volatile unsigned short *)CAN_MB25_DATA3)
#define pCAN_MB25_DATA2		((volatile unsigned short *)CAN_MB25_DATA2)
#define pCAN_MB25_DATA1		((volatile unsigned short *)CAN_MB25_DATA1)
#define pCAN_MB25_DATA0		((volatile unsigned short *)CAN_MB25_DATA0)

#define pCAN_MB26_ID1		((volatile unsigned short *)CAN_MB26_ID1)
#define pCAN_MB26_ID0		((volatile unsigned short *)CAN_MB26_ID0)
#define pCAN_MB26_TIMESTAMP	((volatile unsigned short *)CAN_MB26_TIMESTAMP)
#define pCAN_MB26_LENGTH	((volatile unsigned short *)CAN_MB26_LENGTH)
#define pCAN_MB26_DATA3		((volatile unsigned short *)CAN_MB26_DATA3)
#define pCAN_MB26_DATA2		((volatile unsigned short *)CAN_MB26_DATA2)
#define pCAN_MB26_DATA1		((volatile unsigned short *)CAN_MB26_DATA1)
#define pCAN_MB26_DATA0		((volatile unsigned short *)CAN_MB26_DATA0)

#define pCAN_MB27_ID1		((volatile unsigned short *)CAN_MB27_ID1)
#define pCAN_MB27_ID0		((volatile unsigned short *)CAN_MB27_ID0)
#define pCAN_MB27_TIMESTAMP	((volatile unsigned short *)CAN_MB27_TIMESTAMP)
#define pCAN_MB27_LENGTH	((volatile unsigned short *)CAN_MB27_LENGTH)
#define pCAN_MB27_DATA3		((volatile unsigned short *)CAN_MB27_DATA3)
#define pCAN_MB27_DATA2		((volatile unsigned short *)CAN_MB27_DATA2)
#define pCAN_MB27_DATA1		((volatile unsigned short *)CAN_MB27_DATA1)
#define pCAN_MB27_DATA0		((volatile unsigned short *)CAN_MB27_DATA0)

#define pCAN_MB28_ID1		((volatile unsigned short *)CAN_MB28_ID1)
#define pCAN_MB28_ID0		((volatile unsigned short *)CAN_MB28_ID0)
#define pCAN_MB28_TIMESTAMP	((volatile unsigned short *)CAN_MB28_TIMESTAMP)
#define pCAN_MB28_LENGTH	((volatile unsigned short *)CAN_MB28_LENGTH)
#define pCAN_MB28_DATA3		((volatile unsigned short *)CAN_MB28_DATA3)
#define pCAN_MB28_DATA2		((volatile unsigned short *)CAN_MB28_DATA2)
#define pCAN_MB28_DATA1		((volatile unsigned short *)CAN_MB28_DATA1)
#define pCAN_MB28_DATA0		((volatile unsigned short *)CAN_MB28_DATA0)

#define pCAN_MB29_ID1		((volatile unsigned short *)CAN_MB29_ID1)
#define pCAN_MB29_ID0		((volatile unsigned short *)CAN_MB29_ID0)
#define pCAN_MB29_TIMESTAMP	((volatile unsigned short *)CAN_MB29_TIMESTAMP)
#define pCAN_MB29_LENGTH	((volatile unsigned short *)CAN_MB29_LENGTH)
#define pCAN_MB29_DATA3		((volatile unsigned short *)CAN_MB29_DATA3)
#define pCAN_MB29_DATA2		((volatile unsigned short *)CAN_MB29_DATA2)
#define pCAN_MB29_DATA1		((volatile unsigned short *)CAN_MB29_DATA1)
#define pCAN_MB29_DATA0		((volatile unsigned short *)CAN_MB29_DATA0)

#define pCAN_MB30_ID1		((volatile unsigned short *)CAN_MB30_ID1)
#define pCAN_MB30_ID0		((volatile unsigned short *)CAN_MB30_ID0)
#define pCAN_MB30_TIMESTAMP	((volatile unsigned short *)CAN_MB30_TIMESTAMP)
#define pCAN_MB30_LENGTH	((volatile unsigned short *)CAN_MB30_LENGTH)
#define pCAN_MB30_DATA3		((volatile unsigned short *)CAN_MB30_DATA3)
#define pCAN_MB30_DATA2		((volatile unsigned short *)CAN_MB30_DATA2)
#define pCAN_MB30_DATA1		((volatile unsigned short *)CAN_MB30_DATA1)
#define pCAN_MB30_DATA0		((volatile unsigned short *)CAN_MB30_DATA0)

#define pCAN_MB31_ID1		((volatile unsigned short *)CAN_MB31_ID1)
#define pCAN_MB31_ID0		((volatile unsigned short *)CAN_MB31_ID0)
#define pCAN_MB31_TIMESTAMP	((volatile unsigned short *)CAN_MB31_TIMESTAMP)
#define pCAN_MB31_LENGTH	((volatile unsigned short *)CAN_MB31_LENGTH)
#define pCAN_MB31_DATA3		((volatile unsigned short *)CAN_MB31_DATA3)
#define pCAN_MB31_DATA2		((volatile unsigned short *)CAN_MB31_DATA2)
#define pCAN_MB31_DATA1		((volatile unsigned short *)CAN_MB31_DATA1)
#define pCAN_MB31_DATA0		((volatile unsigned short *)CAN_MB31_DATA0)

/* CAN Mailbox Area Macros		*/
#define pCAN_MB_ID1(x)		((volatile unsigned short *)CAN_MB_ID1(x))
#define pCAN_MB_ID0(x)		((volatile unsigned short *)CAN_MB_ID0(x))
#define pCAN_MB_TIMESTAMP(x)	((volatile unsigned short *)CAN_MB_TIMESTAMP(x))
#define pCAN_MB_LENGTH(x)	((volatile unsigned short *)CAN_MB_LENGTH(x))
#define pCAN_MB_DATA3(x)	((volatile unsigned short *)CAN_MB_DATA3(x))
#define pCAN_MB_DATA2(x)	((volatile unsigned short *)CAN_MB_DATA2(x))
#define pCAN_MB_DATA1(x)	((volatile unsigned short *)CAN_MB_DATA1(x))
#define pCAN_MB_DATA0(x)	((volatile unsigned short *)CAN_MB_DATA0(x))


/* Pin Control Registers	(0xFFC03200 - 0xFFC032FF)								*/
#define pPORTF_FER		((volatile unsigned short *)PORTF_FER)
#define pPORTG_FER		((volatile unsigned short *)PORTG_FER)
#define pPORTH_FER		((volatile unsigned short *)PORTH_FER)
#define pPORT_MUX		((volatile unsigned short *)PORT_MUX)


/* Handshake MDMA Registers	(0xFFC03300 - 0xFFC033FF)								*/
#define pHMDMA0_CONTROL		((volatile unsigned short *)HMDMA0_CONTROL)
#define pHMDMA0_ECINIT		((volatile unsigned short *)HMDMA0_ECINIT)
#define pHMDMA0_BCINIT		((volatile unsigned short *)HMDMA0_BCINIT)
#define pHMDMA0_ECURGENT	((volatile unsigned short *)HMDMA0_ECURGENT)
#define pHMDMA0_ECOVERFLOW	((volatile unsigned short *)HMDMA0_ECOVERFLOW)
#define pHMDMA0_ECOUNT		((volatile unsigned short *)HMDMA0_ECOUNT)
#define pHMDMA0_BCOUNT		((volatile unsigned short *)HMDMA0_BCOUNT)

#define pHMDMA1_CONTROL		((volatile unsigned short *)HMDMA1_CONTROL)
#define pHMDMA1_ECINIT		((volatile unsigned short *)HMDMA1_ECINIT)
#define pHMDMA1_BCINIT		((volatile unsigned short *)HMDMA1_BCINIT)
#define pHMDMA1_ECURGENT	((volatile unsigned short *)HMDMA1_ECURGENT)
#define pHMDMA1_ECOVERFLOW	((volatile unsigned short *)HMDMA1_ECOVERFLOW)
#define pHMDMA1_ECOUNT		((volatile unsigned short *)HMDMA1_ECOUNT)
#define pHMDMA1_BCOUNT		((volatile unsigned short *)HMDMA1_BCOUNT)

#endif /* _CDEF_BF534_H */
