/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 * 
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 * 
 *  @(#) $Id: directorymap.h,v 1.2 2009/06/12 13:30:29 suikan Exp $
 */

// $Header: /cvsroot/toppersjsp4bf/jsp/cfg/base/directorymap.h,v 1.2 2009/06/12 13:30:29 suikan Exp $

#ifndef DIRECTORYMAP_H
#define DIRECTORYMAP_H

#ifdef _MSC_VER
    #pragma warning(disable:4786)
#endif

#include "base/message.h"
#include "base/garbage.h"
#include "base/singleton.h"

  //MSVC6.0 <cstdio> ĂstdɓĂȂ̂
#include <stdio.h>

#include <string>
#include <map>
#include <iostream>
#include <cstring>

class Directory : public std::map<std::string, Directory *>
{
private:
    /*
     * DirectoryNX : ݌v
     *
     *   Eeqm[hԂ̊֌W
     *       : e q𒼐ڂăN𒣂
     *      j : q e̓Ɨ˗ (eIɊȂ)
     *
     *   ENULLZ[t
     *      ꕔ̊֐ this != NULL 肵ȂŎ (ւ̗֐)
     *        - addChild
     *        - findChild, openChild (findNode()
     *        - erase(void)
     *        - getFirstChild, getLastChild, getNext, getPrev
     */

public:
    enum tagtype
    {
        UNKNOWN,
        POINTER,
        INTEGER,
        LITERAL,
        CONSTLITERAL,
        OBJECT
    };

    enum tagflag
    {
        NOTHING  = 0,
        DESTRUCT = 1,
        UNSIGNED = 2
    };

    enum tagmode
    {
        PTRPREFIX = 1
    };

protected:
    static int defaultflag;

    enum tagtype type;
    int flag;

    Directory * parent;
    std::map<std::string, Directory *>::iterator myself;

    union
    {
        void * pointer;
        long value;
        const char * const_literal;
        std::string * literal;
        class Garbage * instance;
    } content;

    Directory(const Directory &);
    void initialize(void);
    void clearContent(void);

    Directory * findNode(bool, const std::string &);
    Directory * findNode(bool automatic_creation, const char * key, va_list vl);

public:
    SINGLETON_CONSTRUCTOR(Directory) { initialize(); }

    Directory(void);
    Directory(int);
    Directory(long);
    Directory(const std::string &);
    Directory(void *);
    explicit Directory(const char *);
    explicit Directory(Garbage *);
    ~Directory(void);

    Directory & operator =(void *);
    Directory & operator =(long);
    Directory & operator =(const char *);
    Directory & operator =(const std::string &);
    Directory & operator =(Garbage *);

    bool operator == (enum tagtype cmptype)
    {   return type == cmptype;   };

    Directory * operator ()(const std::string & src)
    {   return findChild(src);  };
    Directory * operator ()(const char * src)
    {   return findChild(src);  };

    Directory & operator [](const std::string & src)
    {   return *openChild(src); };
    Directory & operator [](const char * src)
    {   return *openChild(std::string(src));    };

    enum tagtype getType(void) const { return type; };
    Directory *  getParent(void) const { return parent; };
    Directory *  getParent(int) const;
    Directory *  getNext(void) const;
    Directory *  getPrev(void) const;
    Directory *  getFirstChild(void) const;
    Directory *  getLastChild(void) const;
    Directory *  findChild(const std::string &);
    Directory *  findChild(const char *);
    Directory *  findChild(const char *, const char * , ... );
    Directory *  findDescandant(const std::string &, unsigned int = 0xffffffff) const;
    Directory *  openChild(const std::string &);
    Directory *  openChild(const char *);
    Directory *  openChild(const char *, const char *, ... );

    void * operator new(size_t);
    void * operator new(size_t, std::nothrow_t);
    void * operator * (void) const;

    operator const long (void) const;
    operator const unsigned long (void) const;
    operator const int (void) const;
    operator const unsigned int (void) const;
    operator const char (void) const;
    operator const unsigned char (void) const;
    operator const char * (void);
    operator const std::string & (void) const;
    operator const Garbage * (void) const;
    operator const void * (void) const;

    void * toPointer(const void * default_value = 0) const;
    long toInteger(const long default_value = 0) const;
    std::string toString(const std::string & default_value = "") const;

    bool operator == (int) const;
    bool operator == (const std::string &) const;
    bool operator == (const char *) const;

    template<class T>
    bool operator != (T src) const
    {   return !(this->operator ==(src));   };


    Directory * addChild(const std::string &, Directory * = 0);
    Directory * addChild(const char *, Directory * = 0);
    Directory * addChild(const std::string &, Directory &);
    Directory * addChild(const char *, Directory &);
    Directory * addChild(Directory &);
    Directory * addChild(Directory * = 0);

    void erase(void);
    iterator erase(iterator);
    void disconnect(void);
    void copyTo(Directory *, int = 0x7fffffff);
    void dropValue(void);
    std::map<std::string, Directory *>::size_type size(std::map<std::string, Directory *>::size_type = 0) const;

    const std::string getKey(void) const;
    bool changeKey(const std::string &);
    bool changeKey(const char *);

    void Load(std::istream *);
    void Store(std::ostream *);

    void drawTree(std::ostream * = &std::cerr, int = 0, std::string * = 0);
    void drawTree_byXML(std::ostream * = &std::cerr, int = 0);

    std::string format(const char *, int mode = 0);
    std::string format(const std::string &, int mode = 0);
};


//------

inline void Directory::initialize(void)
{
    parent = 0;
    type = UNKNOWN;
    flag = defaultflag;
    content.pointer = 0;
    defaultflag &= ~DESTRUCT;
}

inline Directory::Directory(void)
{   initialize();    }

inline Directory::Directory(long val)
{
    initialize();
    *this = val;
}

inline Directory::Directory(int val)
{
    initialize();
    *this = (long)val;
}

inline Directory::Directory(void * val)
{
    initialize();
    *this = val;
}

inline Directory::Directory(const std::string & val)
{
    initialize();
    *this = val;
}

inline Directory::Directory(const char * val)
{
    initialize();
    *this = val;
}

inline Directory::Directory(Garbage * val)
{
    initialize();
    *this = val;
}

inline Directory * Directory::addChild(const char * key, Directory * node)
{   return addChild(std::string(key), node);    }

inline Directory * Directory::addChild(const std::string & key, Directory & node)
{   return addChild(key, &node);    }

inline Directory * Directory::addChild(const char * key, Directory & node)
{   return addChild(std::string(key), &node);   }

inline Directory * Directory::addChild(Directory & node)
{   return addChild(&node); }

    //addChildŒǉvf́Aꊇ폜邩AĂ͂Ȃ
inline Directory * Directory::addChild(Directory * node)
{
    char buffer[32];
    sprintf(buffer,"%03d", (int)size());
    return addChild(buffer, node);
}

inline bool Directory::changeKey(const char * key)
{   return changeKey(std::string(key)); }

inline const std::string Directory::getKey(void) const
{
    if(parent == 0)
        return std::string("/");
    return (*myself).first;
}

inline Directory::operator const unsigned long (void) const
{   return static_cast<const unsigned long>(this->operator const long());  }

inline Directory::operator const int (void) const
{   return static_cast<const int>(this->operator const long());  }

inline Directory::operator const unsigned int (void) const
{   return static_cast<const unsigned int>(this->operator const long());  }

inline Directory::operator const char (void) const
{   return static_cast<const char>(this->operator const long());  }

inline Directory::operator const unsigned char (void) const
{   return static_cast<const unsigned char>(this->operator const long());  }

inline Directory::operator const char * (void)
{
    if(type == CONSTLITERAL)
        return content.const_literal;
    if(type == LITERAL)
        return content.literal->c_str();
    ExceptionMessage("Bad cast exception raised","sLXgO").throwException();
    return 0;
}

inline Directory::operator const std::string &(void) const
{
    if(type == LITERAL)
        return *content.literal;
    ExceptionMessage("Bad cast exception raised","sLXgO").throwException();
    return *(std::string *)0;
}

inline Directory::operator const Garbage * (void) const
{
    if(type == OBJECT)
        return content.instance;
    ExceptionMessage("Bad cast exception raised","sLXgO").throwException();
    return 0;
}

inline Directory::operator const void * (void) const
{   return **this;  }

inline Directory * Directory::findChild(const std::string & path)
{   return findNode(false, path);  }

inline Directory * Directory::openChild(const std::string & path)
{   return findNode(true, path);  }

inline Directory * Directory::getParent(int level) const
{
    const Directory * node = this;
    while(level-- > 0 && node != 0)
        node = node->parent;
    return const_cast<Directory *>(node);
}

inline Directory * Directory::getFirstChild(void) const
{
    if(this == 0 || size()== 0)
        return 0;
    return (*begin()).second;
}

inline Directory * Directory::getLastChild(void) const
{
    if(this == 0 || size()== 0)
        return 0;
    return (*rbegin()).second;
}

inline bool Directory::operator == (int src) const
{   return type == INTEGER && content.value == src; }

inline bool Directory::operator == (const std::string & src) const
{   return (type == LITERAL && src.compare(*content.literal) == 0) || (type == CONSTLITERAL && src.compare(content.const_literal) == 0);    }

inline bool Directory::operator == (const char * src) const
{   return (type == LITERAL && content.literal->compare(src) == 0) || (type == CONSTLITERAL && strcmp(content.const_literal, src)== 0); }

inline std::string Directory::format(const char * src, int mode)
{   return format(std::string(src), mode);  }

inline void Directory::dropValue(void)
{   clearContent();   }

#endif

