/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 * 
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 * 
 *  @(#) $Id: fc_windows.cpp,v 1.1 2009/01/31 05:27:37 suikan Exp $
 */

#if (defined(FILECONTAINER_WINDOWS) || defined(TESTSUITE)) && defined(_MSC_VER)

#pragma warning(disable:4786)

#include "base/filecontainer.h"
#include <windows.h>
#include <imagehlp.h>
#include <string>

using namespace std;

namespace {

    class FileContainerWindowsImpl : public FileContainer
    {
    protected:
        HANDLE          process;
        LOADED_IMAGE    image;
        DWORD           base;

        inline bool isLoaded(void) const
        {   return base != 0;   }

    public:
        FileContainerWindowsImpl(void) throw();
        virtual ~FileContainerWindowsImpl(void) throw();

            /* C^tF[X */
        virtual void        attachModule(const string & filename) throw(Exception);
        virtual void        loadContents(void * dest, address_t address, size_t size) throw(Exception);
        virtual address_t   getSymbolAddress(const string & symbol) throw(Exception);
        virtual std::string getArchitecture(void) throw();

        TESTSUITE_PROTOTYPE(main)
    };

    FileContainerWindowsImpl instance_of_FileContaienrWindowsImpl;

        /* RXgN^ */
    FileContainerWindowsImpl::FileContainerWindowsImpl(void) throw()
        : process(NULL), image(), base(0)
    {}

        /* fXgN^ */
    FileContainerWindowsImpl::~FileContainerWindowsImpl(void) throw()
    {
        if(isLoaded()) {
            ::UnMapAndLoad(&image);
            ::SymUnloadModule(process, base);
            process = NULL;
            base    = 0;
        }
    }

        /* ΏۃW[̊t */
    void FileContainerWindowsImpl::attachModule(const std::string & _filename) throw(Exception)
    {
        string filename(_filename);

        process = ::GetCurrentProcess();
        if(::SymInitialize( process , NULL, FALSE) == FALSE)
            ExceptionMessage("[Internal Error] ImageHelper API initialization failure","[G[] Ɏs܂ (ImageHlp)").throwException();

        base = ::SymLoadModule(process, NULL, (PSTR)filename.c_str(), NULL, 0, 0);

        image.SizeOfImage = sizeof(LOADED_IMAGE);
        if(::MapAndLoad((PSTR)filename.c_str(), NULL, &image, FALSE, TRUE) == FALSE)
            ExceptionMessage("[Internel error] Module loading failure [%]","[G[] W[̓ǂݍ݂Ɏs܂ [%]") << filename << throwException;
    }

        /* e̎擾 */
    void FileContainerWindowsImpl::loadContents(void * dest, address_t address, size_t size) throw(Exception)
    {
        PIMAGE_SECTION_HEADER header;
        unsigned int i;

        address -= base;
        for(i=0;i<image.NumberOfSections;i++) {
            header = image.Sections+i;
            if(address >= header->VirtualAddress && address < header->VirtualAddress + header->SizeOfRawData) {
                address -= header->VirtualAddress - header->PointerToRawData;
                ::CopyMemory(dest,image.MappedAddress + address,size);
                break;
            }
        }

        if(i == image.NumberOfSections)
            ExceptionMessage("[Internel error] Memory read with unmapped address","[G[] }bvĂȂAhXgă[hs܂").throwException();
    }

        /* V{AhX̉ */
    FileContainer::address_t FileContainerWindowsImpl::getSymbolAddress(const string & _symbol) throw(Exception)
    {
        FileContainer::address_t result = 0;
        string symbol(_symbol);
        IMAGEHLP_SYMBOL sym;

        if(process == NULL || base == 0)
            ExceptionMessage("Not initialized","Ă܂").throwException();

        sym.SizeOfStruct = sizeof(sym);
        sym.MaxNameLength = 0;

        if(::SymGetSymFromName(process, (PSTR)symbol.c_str(), &sym) == TRUE)
            result = static_cast<FileContainer::address_t>(sym.Address);
     
        if(result == 0)
            ExceptionMessage("Unknown symbol [%]","sȃV{ [%]") << symbol << throwException;

        return static_cast<FileContainer::address_t>(sym.Address);
    }

    string FileContainerWindowsImpl::getArchitecture(void) throw()
    {   return "Windows (Win32)";   }

}

//---------------------------------------------

#ifdef TESTSUITE
#include "base/coverage_undefs.h"

#pragma warning(disable:4311) //'reinterpret_cast' : |C^ 'const int *__w64 '  'FileContainer::address_t' ֐؂l߂܂B

extern "C" const int FileContainerWindowsImplTestVariable = 0x01234567;
extern "C" const int _FileContainerWindowsImplTestVariableWithUnderbar = 0x89abcdef;

TESTSUITE(main, FileContainerWindowsImpl)
{
    PREDECESSOR("TFileContainer");

    SingletonBase::ContextChain chain;
    chain.saveContext<RuntimeObjectTable>();
    chain.renewInstance();

    BEGIN_CASE("attachModule","attachModule") {
        BEGIN_CASE("1","sĂvOJ邩") {
            FileContainerWindowsImpl fcwi;
            bool result = true;
            try { fcwi.attachModule(TestSuite::getProgName()); } catch(...) { result = false; }
            
            TEST_CASE("1", "O͋NȂ", result);
        } END_CASE;

        BEGIN_CASE("2","݂Ȃt@CŗO") {
            FileContainerWindowsImpl fcwi;
            bool result = false;
            try { fcwi.attachModule("..."); } catch(...) { result = true; }
            
            TEST_CASE("1", "ON", result);
        } END_CASE;
    } END_CASE;

    BEGIN_CASE("getSymbolAddress","getSymbolAddress") {
        FileContainerWindowsImpl fcwi;

        BEGIN_CASE("1","ĂȂԂŌ") {
            bool result = false;
            try { fcwi.getSymbolAddress("FileContainerWindowsImplTestVariable"); } catch(...) { result = true; }
            TEST_CASE("1","O", result);
        } END_CASE;

        fcwi.attachModule(TestSuite::getProgName());

        BEGIN_CASE("2","݂V{") {
            FileContainer::address_t addr = 0;
            bool result = true;

            try { addr = fcwi.getSymbolAddress("FileContainerWindowsImplTestVariable"); } catch(...) { result = false; }

            TEST_CASE("1","O͋NȂ", result);
            TEST_CASE("2","AhX", addr == reinterpret_cast<FileContainer::address_t>(&FileContainerWindowsImplTestVariable));
        } END_CASE;

        BEGIN_CASE("3","]v_ɕtȂ") {
            FileContainer::address_t addr = 0;
            bool result = false;

            try { addr = fcwi.getSymbolAddress("FileContainerWindowsImplTestVariableWithUnderbar"); } catch(...) { result = true; }

            TEST_CASE("1","ON", result);
            TEST_CASE("2","AhX0̂܂", addr == 0);
        } END_CASE;

        BEGIN_CASE("4","݂ȂV{") {
            FileContainer::address_t addr = 0;
            bool result = false;

            try { addr = fcwi.getSymbolAddress("____unknown____"); } catch(...) { result = true; }

            TEST_CASE("1","O", result);
        } END_CASE;
    } END_CASE;

    BEGIN_CASE("loadContents","loadContents") {
        FileContainerWindowsImpl fcwi;
        fcwi.attachModule(TestSuite::getProgName());

        BEGIN_CASE("1","݂ϐǂݏo") {
            FileContainer::address_t addr;
            int i;

            addr = fcwi.getSymbolAddress("FileContainerWindowsImplTestVariable");
            bool result = true;
            try { fcwi.loadContents(&i, addr, sizeof(i)); } catch(...) { result = false; }

            TEST_CASE("1","O͋NȂ", result);
            TEST_CASE("2","ǂݏoꂽe͐", i == FileContainerWindowsImplTestVariable);
        } END_CASE;

        BEGIN_CASE("2","݂Ȃϐǂݏo") {
            FileContainer::address_t addr;
            int i;

            addr = ~0;
            bool result = false;
            try { fcwi.loadContents(&i, addr, sizeof(i)); } catch(Exception &) { result = true; }

            TEST_CASE("1","ON", result);
        } END_CASE;

    } END_CASE;

    chain.restoreContext();
}

#endif /* TESTSUITE */

#endif /* FILECONTAINER_WINDOWS || TESTSUITE */

