/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 *
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *
 *  TOPPERS/JSP for Blackfin
 *
 *  Copyright (C) 2004,2006,2006 by Takemasa Nakamura
 *  Copyright (C) 2004 by Ujinosuke
 *
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 *
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 *
 *
 */


/*
 *	^[QbgVXeɈˑ`iADSP-BF533pj
 *
 *  ̃CN[ht@ĆCkernel.h  sil.h ŃCN[hD
 *  ̃t@C璼ڃCN[h邱Ƃ͂ȂD̃t@CC
 *  N[hOɁCt_stddef.h  itron.h CN[ĥŁC
 *  ɈˑĂ悢D
 */

#ifndef _CHIP_DEFS_H_
#define _CHIP_DEFS_H_


/*
 * VXe MMR̒`
 */
#define __PLL_CTL			0xFFC00000
#define __PLL_DIV			0xFFC00004

#define __SWRST				0xFFC00100
#define __SYSCR				0xFFC00104
#define __SIC_IMASK			0xFFC0010C
#define __SIC_IAR0			0xFFC00110
#define __SIC_IAR1			0xFFC00114
#define __SIC_IAR2			0xFFC00118
#define __SIC_ISR			0xFFC00120
#define __SIC_IWR			0xFFC00124

#define __TIMER2_CONFIG     0xFFC00620
#define __TIMER2_COUNTER    0xFFC00624
#define __TIMER2_PERIOD     0xFFC00628
#define __TIMER2_WIDTH      0xFFC0062C

#define __TIMER_ENABLE		0xFFC00640
#define __TIMER_DISABLE		0xFFC00644
#define __TIMER_STATUS		0xFFC00648

#define __EBIU_SDBCTL		0xFFC00A14

#define __pPLL_CTL 		((volatile unsigned short *)__PLL_CTL)
#define __pPLL_DIV 		((volatile unsigned short *)__PLL_DIV)

#define __pSWRST 			((volatile unsigned short *)__SWRST)
#define __pSYSCR 			((volatile unsigned short *)__SYSCR)
#define __pSIC_IMASK 		((volatile unsigned long *)__SIC_IMASK)
#define __pSIC_IAR0 		((volatile unsigned long *)__SIC_IAR0)
#define __pSIC_IAR1 		((volatile unsigned long *)__SIC_IAR1)
#define __pSIC_IAR2 		((volatile unsigned long *)__SIC_IAR2)
#define __pSIC_ISR 		((volatile unsigned long *)__SIC_ISR)
#define __pSIC_IWR 		((volatile unsigned long *)__SIC_IWR)

#define __pTIMER2_CONFIG 	((volatile unsigned short *)__TIMER2_CONFIG)
#define __pTIMER2_COUNTER ((volatile unsigned long *)__TIMER2_COUNTER)
#define __pTIMER2_PERIOD 	((volatile unsigned long *)__TIMER2_PERIOD)
#define __pTIMER2_WIDTH 	((volatile unsigned long *)__TIMER2_WIDTH)

#define __pTIMER_ENABLE 	((volatile unsigned short *)__TIMER_ENABLE)
#define __pTIMER_DISABLE 	((volatile unsigned short *)__TIMER_DISABLE)
#define __pTIMER_STATUS 	((volatile unsigned short *)__TIMER_STATUS)

#define __pEBIU_SDGCTL 	((volatile unsigned long *)__EBIU_SDGCTL)
#define __pEBIU_SDBCTL 	((volatile unsigned short *)__EBIU_SDBCTL)
#define __pEBIU_SDRRC 	((volatile unsigned short *)__EBIU_SDRRC)
#define __pEBIU_SDSTAT 	((volatile unsigned short *)__EBIU_SDSTAT)


/*
 *  ^CeBbN̒`
 */
#define	TIC_NUME	1u	/* ^CeBbN̎̕q */
#define	TIC_DENO	1u	/* ^CeBbN̎̕ */

/*
 *  j󐫓ǂݏoWX^̔ʎ
 *  ^ꂽAhX iop j󐫓ǂݏoWX^
 *  ꍇɂ͐^ԂB
 */
#ifndef DESTRUCTIVE_READ
#define DESTRUCTIVE_READ( iop ) (iop<(VP)0xF0000000)
#endif

#ifndef _MACRO_ONLY

/*
 *  VXe̒~
 */

Inline void
kernel_abort()
{
}

#endif /* _MACRO_ONLY */
#endif /* _CHIP_DEFS_H_ */
