/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 * 
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 * 
 *  @(#) $Id: cpu_config.h,v 1.1 2009/01/31 05:27:37 suikan Exp $
 */

/*
 *	vZbTˑW[iM68040pj
 *
 *  ̃CN[ht@ĆCt_config.h ݂̂CN[hD
 *  ̃t@C璼ڃCN[hĂ͂ȂȂD
 */

#ifndef _CPU_CONFIG_H_
#define _CPU_CONFIG_H_

/*
 *  J[l̓ʖ̃l[
 */
#include <cpu_rename.h>

/*
 *  vZbT̓ꖽ߂̃CC֐`
 */
#ifndef _MACRO_ONLY
#include <cpu_insn.h>
#endif /* _MACRO_ONLY */

/*
 *  chg_ipm/get_ipm T|[g邩ǂ̒`
 */
#define	SUPPORT_CHG_IPM

/*
 *  TCB ̃tB[h̃rbg̒`
 *
 *  cpu_context.h ɓGKgCQƂ̈ˑ̊֌WŁC
 *  cpu_context.h ɂ͓ȂD
 */
#define	TBIT_TCB_TSTAT		8	/* tstat tB[h̃rbg */
#define	TBIT_TCB_PRIORITY	8	/* priority tB[h̃rbg */

#ifndef _MACRO_ONLY
/*
 *  ^XNReLXgubN̒`
 */
typedef struct task_context_block {
	VP	msp;		/* X^bN|C^ */
	FP	pc;		/* vOJE^ */
} CTXB;

/*
 *  ݃}XN색Cu
 *
 *  ݃}XNiintmaskj́CIPMiInterrupt Priority Maskj8rbg
 *  ɃVtĝłD
 */

/*
 *  ݂̊݃}XN̓Ǐo
 */
Inline UH
current_intmask()
{
	return(current_sr() & 0x0700);
}

/*
 *  ݃}XN̐ݒ
 */
Inline void
set_intmask(UH intmask)
{
	set_sr((current_sr() & ~0x0700) | intmask);
}

/*
 *  VXeԎQ
 */

Inline BOOL
sense_context()
{
	return((current_sr() & 0x1000) == 0);
}

Inline BOOL
sense_lock()
{
	return(current_intmask() == 0x0700);
}

#define t_sense_lock	sense_lock
#define i_sense_lock	sense_lock

/*
 *  CPUbNƂ̉i^XNReLXgpj
 *
 *  task_intmask ́Cchg_ipm T|[g邽߂̕ϐDchg_ipm T|[
 *  gȂꍇɂ́Ctask_intmask  0 ɂȂĂƍl΂悢D
 */

#ifdef SUPPORT_CHG_IPM
extern UH	task_intmask;	/* ^XNReLXgł̊݃}XN */
#endif /* SUPPORT_CHG_IPM */

Inline void
t_lock_cpu()
{
	disint();
}

Inline void
t_unlock_cpu()
{
#ifdef SUPPORT_CHG_IPM
	/*
	 *  t_unlock_cpu Ăяô CPUbNԂ݂̂ł邽
	 *  ߁C̓r task_intmask 邱Ƃ͂ȂD
	 */
	set_intmask(task_intmask);
#else /* SUPPORT_CHG_IPM */
	enaint();
#endif /* SUPPORT_CHG_IPM */
}

/*
 *  CPUbNƂ̉i^XNReLXgpj
 */

extern UH	int_intmask;	/* ^XNReLXgł̊݃}XN */

Inline void
i_lock_cpu()
{
	UH	intmask;

	/*
	 *  ꎞϐ intmask gĂ̂́Ccurrent_intmask() 
	 *  񂾒Ɋ݂CNꂽ݃nh
	 *  int_intmask ύX\邽߂łD
	 */
	intmask = current_intmask();
	disint();
	int_intmask = intmask;
}

Inline void
i_unlock_cpu()
{
	set_intmask(int_intmask);
}

/*
 *  ^XNfBXpb`
 */

/*
 *  ōD揇ʃ^XNւ̃fBXpb`icpu_support.Sj
 *
 *  dispatch ́C^XNReLXgĂяoꂽT[rXR[
 *  ŁCCPUbNԂŌĂяoȂ΂ȂȂD
 */
extern void	dispatch(void);

/*
 *  ݂̃ReLXĝĂăfBXpb`icpu_support.Sj
 *
 *  exit_and_dispatch ́CCPUbNԂŌĂяoȂ΂ȂȂD
 */
extern void	exit_and_dispatch(void);

/*
 *  ݃nh^CPUOnh̐ݒ
 */

/*
 *  OxN^e[u̍\̒`
 */
typedef struct exc_vector_entry {
	FP	exchdr;			/* Onh̋NԒn */
} EXCVE;

/*
 *  ݃nh̐ݒ
 *
 *  xNgԍ inhno ̊݃nh̋NԒn inthdr ɐݒ肷D
 */
Inline void
define_inh(INHNO inhno, FP inthdr)
{
	EXCVE	*excvt;

#ifdef EXCVT_KERNEL
	/*
	 *  EXCVT_KERNEL `Ă鎞́C̒ VBR  
	 *  EXCVT_KERNEL ɐݒ肷̂ŁCEXCVT_KERNEL gD
	 */
	excvt = (EXCVE *) EXCVT_KERNEL;
#else /* EXCVT_KERNEL */
	excvt = (EXCVE *) current_vbr();
#endif /* EXCVT_KERNEL */
	excvt[inhno].exchdr = inthdr;
}

/*
 *  CPUOnh̐ݒ
 *
 *  xNgԍ excno CPUOnh̋NԒn exchdr ɐݒ肷D
 */
Inline void
define_exc(EXCNO excno, FP exchdr)
{
	define_inh(excno, exchdr);
}

/*
 *  ݃nh^CPUOnh̏o
 */

/*
 *  ݃nh̏o̐}N
 *
 *  reqflg `FbNOɊ݂֎~ȂƁCreqflg `FbN
 *  ɋNꂽ݃nhŃfBXpb`vꂽꍇɁCfB
 *  Xpb`ȂD
 */

#define	INTHDR_ENTRY(inthdr)		\
extern void inthdr##_entry(void);	\
asm(".text				\n" \
#inthdr "_entry:			\n" \
"	movem.l %d0-%d1/%a0-%a1, -(%sp)	\n" /* XNb`WX^ۑ */ \
"	jsr " #inthdr "			\n" /* ݃nhĂяo */ \
"	movem.l (%sp)+, %d0-%d1/%a0-%a1	\n" /* XNb`WX^𕜋A */ \
"	btst.b #4, (%sp)		\n" /* ߂悪݃[hȂ */ \
"	jbeq 1f				\n" /*           Ƀ^[ */ \
"	or.w #0x0700, %sr		\n" /* ݋֎~ */ \
"	tst.l _kernel_reqflg		\n" /* reqflg  TRUE ł */ \
"	jbne _kernel_ret_int		\n" /*              ret_int  */ \
"1:	rte				\n")

#define	INT_ENTRY(inthdr)	inthdr##_entry

/*
 *  CPUOnh̏o̐}N
 *
 *  CPUOnh́C^XNReLXgŎsD̂߁CCPU
 *  OnhĂяoOɊ݃[hɈڍsC^[Ă
 *  ̃[hɖ߂D̃[hɖ߂߂ɁC݃[hɈڍsO
 *   SR ݃X^bNɕۑDCPUO^XNReLXg
 *  Creqflg  TRUE ɂȂɁCret_exc ֕򂷂D
 *  reqflg `FbNOɊ݂֎~ȂƁCreqflg `FbN
 *  ɋNꂽ݃nhŃfBXpb`vꂽꍇɁCfB
 *  Xpb`ȂD
 */

#define	EXCHDR_ENTRY(exchdr)		\
extern void exchdr##_entry(VP sp);	\
asm(".text				\n" \
#exchdr "_entry:			\n" \
"	movem.l %d0-%d1/%a0-%a1, -(%sp)	\n" /* XNb`WX^ۑ */ \
"	lea.l 16(%sp), %a0		\n" /* Ot[̐擪 A0  */ \
"	move.w %sr, %d0			\n" /* SR  D0  */ \
"	and.w #~0x1000, %sr		\n" /* ݃[h */ \
"	move.l %d0, -(%sp)		\n" /*  SR X^bNɕۑ */ \
"	move.l %a0, -(%sp)		\n" /* A0 Ƃēn */ \
"	jsr " #exchdr "			\n" /* CPUOnhĂяo */ \
"	addq.l #4, %sp			\n" \
"	move.l (%sp)+, %d0		\n" \
"	and.w #0x1000, %d0		\n" /* ݃[hȂ */ \
"	jbeq 1f				\n" /*       Ƀ^[ */ \
"	or.w #0x1700, %sr		\n" /* }X^[hE݋֎~ */ \
"	tst.l _kernel_reqflg		\n" /* reqflg  TRUE ł */ \
"	jbne _kernel_ret_exc		\n" /*              ret_exc  */ \
"1:	movem.l (%sp)+, %d0-%d1/%a0-%a1	\n" /* XNb`WX^𕜋A */ \
"	rte				\n")

#define	EXC_ENTRY(exchdr)	exchdr##_entry

/*
 *  CPUO̔̃VXeԂ̎Q
 */

/*
 *  CPUO̔̃ReLXg̎Q
 */
Inline BOOL
exc_sense_context(VP p_excinf)
{
	return((*((UH *) p_excinf) & 0x1000) == 0);
}

/*
 *  CPUO̔CPUbNԂ̎Q
 */
Inline BOOL
exc_sense_lock(VP p_excinf)
{
	return((*((UH *) p_excinf) & 0x0700) == 0x0700);
}

/*
 *  vZbTˑ̏
 */
extern void	cpu_initialize(void);

/*
 *  vZbTˑ̏I
 */
extern void	cpu_terminate(void);

#endif /* _MACRO_ONLY */
#endif /* _CPU_CONFIG_H_ */
