/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2004 by Embedded and Real-Time Systems Laboratory
 *              Graduate School of Information Science, Nagoya Univ., JAPAN
 * 
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 * 
 *  @(#) $Id: kernel.h,v 1.1 2009/01/31 05:27:37 suikan Exp $
 */

/*
 *	ITRON4.0dlWCN[ht@C
 *
 *  ̃t@Cł́CX^_[hvt@CŕKvȂ̂ƁCJSPJ[
 *  lƎ̊g@\ŕKvȂ̂`ĂDf[^^̒`́C
 *  X^_[hvt@C𖞂傤ǂ̒ɂ͂ĂȂD
 *
 *  AZũ\[Xt@CVXeRtBM[Vt@
 *  C炱̃t@CCN[h鎞́C_MACRO_ONLY `
 *  ƂŁC}N`ȊŐLqƂłD
 *
 *  ̃CN[ht@ĆCWCN[ht@Cit_services.h 
 *   jsp_kernel.hjŃCN[hD܂C ITRONdlOS 
 *  \tgEFA|[eBOꍇȂǂɂ́C̃t@C𒼐ڃC
 *  N[hĂ悢D̗OāC̃t@C璼ڃCN[
 *  h邱Ƃ͂ȂD
 *
 *  ̒ŃCN[hĂt@CāC̃CN[ht@
 *  CɈˑĂȂD
 */

#ifndef _KERNEL_H_
#define _KERNEL_H_

#ifdef __cplusplus
extern "C" {
#endif

/*
 *  J[lEAvP[V ʃCN[ht@C
 */
#include <t_stddef.h>

/*
 *  ITRONdlʋK̃f[^^E萔E}N
 */
#include <itron.h>

/*
 *  VXevZbTɈˑ`
 */
#include <sys_defs.h>
#include <cpu_defs.h>

/*
 *  VXeOT[rX̂߂̒`
 */
#include <t_syslog.h>

/*
 *  ⏕}N
 */
#define	TROUND_VP(sz)	(((sz) + sizeof(VP) - 1) & ~(sizeof(VP) - 1))
#define	TCOUNT_VP(sz)	(((sz) + sizeof(VP) - 1) / sizeof(VP))

/*
 *  f[^^̒`
 */
#ifndef _MACRO_ONLY

typedef	UINT		TEXPTN;		/* ^XNOṽrbgp^[ */
typedef	UINT		FLGPTN;		/* CxgtÕrbgp^[ */

typedef	struct t_msg {			/* [{bNX̃bZ[Wwb_ */
	struct t_msg	*next;
} T_MSG;

typedef	struct t_msg_pri {		/* DxtbZ[Wwb_ */
	T_MSG		msgque;		/* bZ[Wwb_ */
	PRI		msgpri;		/* bZ[WDx */
} T_MSG_PRI;

#endif /* _MACRO_ONLY */

/*
 *  T[rXR[̐錾
 */
#ifndef _MACRO_ONLY

/*
 *  ^XNǗ@\
 */
extern ER	act_tsk(ID tskid) throw();
extern ER	iact_tsk(ID tskid) throw();
extern ER_UINT	can_act(ID tskid) throw();
extern void	ext_tsk(void) throw();
extern ER	ter_tsk(ID tskid) throw();
extern ER	chg_pri(ID tskid, PRI tskpri) throw();
extern ER	get_pri(ID tskid, PRI *p_tskpri) throw();

/*
 *  ^XNt@\
 */
extern ER	slp_tsk(void) throw();
extern ER	tslp_tsk(TMO tmout) throw();
extern ER	wup_tsk(ID tskid) throw();
extern ER	iwup_tsk(ID tskid) throw();
extern ER_UINT	can_wup(ID tskid) throw();
extern ER	rel_wai(ID tskid) throw();
extern ER	irel_wai(ID tskid) throw();
extern ER	sus_tsk(ID tskid) throw();
extern ER	rsm_tsk(ID tskid) throw();
extern ER	frsm_tsk(ID tskid) throw();
extern ER	dly_tsk(RELTIM dlytim) throw();

/*
 *  ^XNO@\
 */
extern ER	ras_tex(ID tskid, TEXPTN rasptn) throw();
extern ER	iras_tex(ID tskid, TEXPTN rasptn) throw();
extern ER	dis_tex(void) throw();
extern ER	ena_tex(void) throw();
extern BOOL	sns_tex(void) throw();

/*
 *  EʐM@\
 */
extern ER	sig_sem(ID semid) throw();
extern ER	isig_sem(ID semid) throw();
extern ER	wai_sem(ID semid) throw();
extern ER	pol_sem(ID semid) throw();
extern ER	twai_sem(ID semid, TMO tmout) throw();

extern ER	set_flg(ID flgid, FLGPTN setptn) throw();
extern ER	iset_flg(ID flgid, FLGPTN setptn) throw();
extern ER	clr_flg(ID flgid, FLGPTN clrptn) throw();
extern ER	wai_flg(ID flgid, FLGPTN waiptn,
			MODE wfmode, FLGPTN *p_flgptn) throw();
extern ER	pol_flg(ID flgid, FLGPTN waiptn,
			MODE wfmode, FLGPTN *p_flgptn) throw();
extern ER	twai_flg(ID flgid, FLGPTN waiptn,
			MODE wfmode, FLGPTN *p_flgptn, TMO tmout) throw();

extern ER	snd_dtq(ID dtqid, VP_INT data) throw();
extern ER	psnd_dtq(ID dtqid, VP_INT data) throw();
extern ER	ipsnd_dtq(ID dtqid, VP_INT data) throw();
extern ER	tsnd_dtq(ID dtqid, VP_INT data, TMO tmout) throw();
extern ER	fsnd_dtq(ID dtqid, VP_INT data) throw();
extern ER	ifsnd_dtq(ID dtqid, VP_INT data) throw();
extern ER	rcv_dtq(ID dtqid, VP_INT *p_data) throw();
extern ER	prcv_dtq(ID dtqid, VP_INT *p_data) throw();
extern ER	trcv_dtq(ID dtqid, VP_INT *p_data, TMO tmout) throw();

extern ER	snd_mbx(ID mbxid, T_MSG *pk_msg) throw();
extern ER	rcv_mbx(ID mbxid, T_MSG **ppk_msg) throw();
extern ER	prcv_mbx(ID mbxid, T_MSG **ppk_msg) throw();
extern ER	trcv_mbx(ID mbxid, T_MSG **ppk_msg, TMO tmout) throw();

/*
 *  v[Ǘ@\
 */
extern ER	get_mpf(ID mpfid, VP *p_blk) throw();
extern ER	pget_mpf(ID mpfid, VP *p_blk) throw();
extern ER	tget_mpf(ID mpfid, VP *p_blk, TMO tmout) throw();
extern ER	rel_mpf(ID mpfid, VP blk) throw();

/*
 *  ԊǗ@\
 */
extern ER	set_tim(const SYSTIM *p_systim) throw();
extern ER	get_tim(SYSTIM *p_systim) throw();
extern ER	isig_tim(void) throw();

extern ER	sta_cyc(ID cycid) throw();
extern ER	stp_cyc(ID cycid) throw();

/*
 *  VXeԊǗ@\
 */
extern ER	rot_rdq(PRI tskpri) throw();
extern ER	irot_rdq(PRI tskpri) throw();
extern ER	get_tid(ID *p_tskid) throw();
extern ER	iget_tid(ID *p_tskid) throw();
extern ER	loc_cpu(void) throw();
extern ER	iloc_cpu(void) throw();
extern ER	unl_cpu(void) throw();
extern ER	iunl_cpu(void) throw();
extern ER	dis_dsp(void) throw();
extern ER	ena_dsp(void) throw();
extern BOOL	sns_ctx(void) throw();
extern BOOL	sns_loc(void) throw();
extern BOOL	sns_dsp(void) throw();
extern BOOL	sns_dpn(void) throw();

/*
 *  ƎT[rXR[
 */
extern BOOL	vxsns_ctx(VP p_excinf) throw();
extern BOOL	vxsns_loc(VP p_excinf) throw();
extern BOOL	vxsns_dsp(VP p_excinf) throw();
extern BOOL	vxsns_dpn(VP p_excinf) throw();
extern BOOL	vxsns_tex(VP p_excinf) throw();
extern BOOL	vsns_ini(void) throw();

#endif /* _MACRO_ONLY */

/*
 *  IuWFNg̒`
 */
#define TA_HLNG		0x00u		/* pC^tF[X */
#define TA_ASM		0x01u		/* AZupC^tF[X */

#define TA_TFIFO	0x00u		/* ^XN̑҂sFIFO */
#define TA_TPRI		0x01u		/* ^XN̑҂sDx */

#define TA_MFIFO	0x00u		/* bZ[WL[FIFO */
#define TA_MPRI		0x02u		/* bZ[WL[Dx */

#define TA_ACT		0x02u		/* ^XNNꂽԂŐ */

#define TA_WSGL		0x00u		/* CxgtȎ҂^XN1 */
#define TA_CLR		0x04u		/* CxgtÕNAw */

#define	TA_STA		0x02u		/* nh𓮍ԂŐ */

/*
 *  T[rXR[̓샂[h̒`
 */
#define	TWF_ANDW	0x00u		/* CxgtOAND҂ */
#define	TWF_ORW		0x01u		/* CxgtOOR҂ */

/*
 *  ̑̒萔̒`
 */
#define	TSK_SELF	0		/* ^XNw */
#define	TSK_NONE	0		/* Y^XNȂ */
#define	TPRI_SELF	0		/* ^XÑx[XDx̎w */
#define	TPRI_INI	0		/* ^XN̋NDx̎w */

/*
 *  \萔ƃ}N
 */

/*
 *  Dx͈̔
 */
#define	TMIN_TPRI	1		/* ^XNDx̍ŏl */
#define	TMAX_TPRI	16		/* ^XNDx̍ől */
#define	TMIN_MPRI	1		/* bZ[WDx̍ŏl */
#define	TMAX_MPRI	16		/* bZ[WDx̍ől */

/*
 *  o[W
 */
#define	TKERNEL_MAKER	0x0118u		/* J[l̃[J[R[h */
#define	TKERNEL_PRID	0x0001u		/* J[l̎ʔԍ */
#define	TKERNEL_SPVER	0x5402u		/* ITRONdl̃o[Wԍ */
#define	TKERNEL_PRVER	0x1043u		/* J[l̃o[Wԍ */

/*
 *  L[CO^lXg񐔂̍ől
 */
#define	TMAX_ACTCNT	1		/* NvL[CO̍ől */
#define	TMAX_WUPCNT	1		/* NvL[CO̍ől */
#define	TMAX_SUSCNT	1		/* ҂vlXg̍ől */

/*
 *  rbgp^[̃rbg
 */
#define	TBIT_TEXPTN	(sizeof(TEXPTN) * CHAR_BIT)
					/* ^XNOṽrbg */
#define	TBIT_FLGPTN	(sizeof(FLGPTN) * CHAR_BIT)
					/* CxgtÕrbg */

#ifdef __cplusplus
}
#endif

#endif /* _KERNEL_H_ */
