/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 * 
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 * 
 *  @(#) $Id: exception.c,v 1.1 2009/01/31 05:27:37 suikan Exp $
 */

/*
 *	CPUOǗ@\
 */

#include "jsp_kernel.h"
#include "task.h"
#include "exception.h"

/*
 *  CPUOnhԍ̐ikernel_cfg.cj
 */
extern const UINT	tnum_excno;

/*
 *  CPUOnhubÑGAikernel_cfg.cj
 */
extern const EXCINIB	excinib_table[];

/* 
 *  CPUOnhǗ@\̏
 */
#ifdef __excini

void
exception_initialize()
{
	UINT		i;
	const EXCINIB	*excinib;

	for (excinib = excinib_table, i = 0; i < tnum_excno; excinib++, i++) {
		define_exc(excinib->excno, excinib->exchdr);
	}
}

#endif /* __excini */

/*
 *  CPUO̔ReLXg̎Q
 */
#ifdef __vxsns_ctx

SYSCALL BOOL
vxsns_ctx(VP p_excinf)
{
	BOOL	state;

	LOG_VXSNS_CTX_ENTER(p_excinf);
	state = exc_sense_context(p_excinf) ? TRUE : FALSE;
	LOG_VXSNS_CTX_LEAVE(state);
	return(state);
}

#endif /* __vxsns_ctx */

/*
 *  CPUO̔CPUbNԂ̎Q
 */
#ifdef __vxsns_loc

SYSCALL BOOL
vxsns_loc(VP p_excinf)
{
	BOOL	state;

	LOG_VXSNS_LOC_ENTER(p_excinf);
	state = exc_sense_lock(p_excinf) ? TRUE : FALSE;
	LOG_VXSNS_LOC_LEAVE(state);
	return(state);
}

#endif /* __vxsns_loc */

/*
 *  CPUO̔̃fBXpb`֎~Ԃ̎Q
 *
 *  sns_dsp Ɠ̏eƂȂD
 */
#ifdef __vxsns_dsp

SYSCALL BOOL
vxsns_dsp(VP p_excinf)
{
	BOOL	state;

	LOG_VXSNS_DSP_ENTER(p_excinf);
	state = !(enadsp) ? TRUE : FALSE;
	LOG_VXSNS_DSP_LEAVE(state);
	return(state);
}

#endif /* __vxsns_dsp */

/*
 *  CPUO̔̃fBXpb`ۗԂ̎Q
 */
#ifdef __vxsns_dpn

SYSCALL BOOL
vxsns_dpn(VP p_excinf)
{
	BOOL	state;

	LOG_VXSNS_DPN_ENTER(p_excinf);
	state = (exc_sense_context(p_excinf) || exc_sense_lock(p_excinf)
					|| !(enadsp)) ? TRUE : FALSE;
	LOG_VXSNS_DPN_LEAVE(state);
	return(state);
}

#endif /* __vxsns_dpn */

/*
 *  CPUO̔̃^XNO֎~Ԃ̎Q
 *
 *  sns_tex Ɠ̏eƂȂD
 */
#ifdef __vxsns_tex

SYSCALL BOOL
vxsns_tex(VP p_excinf)
{
	BOOL	state;

	LOG_VXSNS_TEX_ENTER(p_excinf);
	state = (runtsk != NULL && runtsk->enatex) ? FALSE : TRUE;
	LOG_VXSNS_TEX_LEAVE(state);
	return(state);
}

#endif /* __vxsns_tex */
