/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 * 
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 * 
 *  @(#) $Id: queue.h,v 1.1 2009/01/31 05:27:37 suikan Exp $
 */

/*
 *	L[색Cu
 *
 *  ̃L[색Cuł́CL[wb_܂ރO\̃_u
 *  NL[D̓Iɂ́CL[wb_̎Gg̓L[
 *  擪̃GgCOGg̓L[̖̃GgƂD܂CL
 *  [̐擪̃Gg̑OGgƁCL[̖̃Gg̎G
 *  ǵCL[wb_ƂD̃L[́CGgCOGg
 *  gwL[wb_ł킷D
 */

#ifndef	_QUEUE_H_
#define	_QUEUE_H_

/*
 *  L[̃f[^\̒`
 */
typedef struct queue {
	struct queue *next;		/* Ggւ̃|C^ */
	struct queue *prev;		/* OGgւ̃|C^ */
} QUEUE;

/*
 *  L[̏
 *
 *  queue ɂ̓L[wb_w肷D
 */
Inline void
queue_initialize(QUEUE *queue)
{
	queue->prev = queue->next = queue;
}

/*
 *  L[̑OGgւ̑}
 *
 *  queue ̑O entry }Dqueue ɃL[wb_w肵ꍇ
 *  ɂ́CL[̖ entry }邱ƂɂȂD
 */
Inline void
queue_insert_prev(QUEUE *queue, QUEUE *entry)
{
	entry->prev = queue->prev;
	entry->next = queue;
	queue->prev->next = entry;
	queue->prev = entry;
}

/*
 *  Gg̍폜
 *
 *  entry L[폜D
 */
Inline void
queue_delete(QUEUE *entry)
{
	entry->prev->next = entry->next;
	entry->next->prev = entry->prev;
}

/*
 *  L[̎Gg̎o
 *
 *  queue ̎GgL[폜C폜GgԂDqueue
 *  ɃL[wb_w肵ꍇɂ́CL[̐擪̃Ggo
 *  ƂɂȂDqueue ɋ̃L[w肵ČĂяoĂ͂ȂȂD
 */
Inline QUEUE *
queue_delete_next(QUEUE *queue)
{
	QUEUE	*entry;

	assert(queue->next != queue);
	entry = queue->next;
	queue->next = entry->next;
	entry->next->prev = queue;
	return(entry);
}

/*
 *  L[󂩂ǂ̃`FbN
 *
 *  queue ɂ̓L[wb_w肷D
 */
Inline BOOL
queue_empty(QUEUE *queue)
{
	if (queue->next == queue) {
		assert(queue->prev == queue);
		return(TRUE);
	}
	return(FALSE);
}

#endif /* _QUEUE_H_ */
