/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2005,2006 by Embedded and Real-Time Systems Laboratory
 *              Graduate School of Information Science, Nagoya Univ., JAPAN
 * 
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 * 
 *  @(#) $Id: task.c,v 1.1 2009/01/31 05:27:37 suikan Exp $
 */

/*
 *	^XNǗW[
 */

#include "jsp_kernel.h"
#include "task.h"
#include <cpu_context.h>

#ifdef __tskini

/*
 *  sԂ̃^XN
 */
TCB	*runtsk;

/*
 *  ōD揇ʂ̃^XN
 */
TCB	*schedtsk;

/*
 *  ^XNfBXpb`^^XNO[`NvtO
 */
BOOL	reqflg;

/*
 *  ^XNfBXpb`
 */
BOOL	enadsp;

/*
 *  fBL[
 */
QUEUE	ready_queue[TNUM_TPRI];

/*
 *  fBL[T[`̂߂̃rbg}bv
 *
 *  rbg}bv UINT Œ`Ă邪Crbg}bvT[`֐ŗD
 *  x16iKȉł邱Ƃ肵ĂD
 */
UINT	ready_primap;

/*
 *  ^XNǗW[̏
 */
void
task_initialize()
{
	UINT	i, j;
	TCB	*tcb;

	runtsk = schedtsk = NULL;
	reqflg = FALSE;
	enadsp = TRUE;

	for (i = 0; i < TNUM_TPRI; i++) {
		queue_initialize(&(ready_queue[i]));
	}
	ready_primap = 0;

	for (i = 0; i < TNUM_TSK; i++) {
		j = INDEX_TSK(torder_table[i]);
		tcb = &(tcb_table[j]);
		tcb->tinib = &(tinib_table[j]);
		tcb->actcnt = FALSE;
		make_dormant(tcb);
		if ((tcb->tinib->tskatr & TA_ACT) != 0) {
			make_active(tcb);
		}
	}
}

#endif /* __tskini */

/*
 *  rbg}bvT[`֐
 *
 *  bitmap  1 ̃rbg̓CłʁiEĵ̂T[`C̃r
 *  bgԍԂDrbgԍ́Cŉʃrbg 0 ƂDbitmap  0
 *  w肵Ă͂ȂȂD̊֐ł́CDx16iKȉł邱Ƃ
 *  肵Cbitmap ̉16rbĝ݂T[`D
 *  rbgT[`߂vZbTł́CrbgT[`߂g悤
 *  ǂ낤D̂悤ȏꍇɂ́Ccpu_insn.h 
 *  rbgT[`߂g bitmap_search `CCPU_BITMAP_SEARCH 
 *  }N`΂悢D܂CrbgT[`߂̃T[`tȂ
 *  ̗RŗDxƃrbgƂ̑ΉύXꍇɂ́CPRIMAP_BIT 
 *  }N`΂悢D
 *  ܂CWCu ffs ȂĈ悤ɒ`ĕWC
 *  ugǂ\D
 *	#define	bitmap_search(bitmap) (ffs(bitmap) - 1)
 */
#ifndef PRIMAP_BIT
#define	PRIMAP_BIT(pri)		(1u << (pri))
#endif /* PRIMAP_BIT */

#ifndef CPU_BITMAP_SEARCH

Inline UINT
bitmap_search(UINT bitmap)
{
	static const unsigned char search_table[] = { 0, 1, 0, 2, 0, 1, 0,
						3, 0, 1, 0, 2, 0, 1, 0 };
	UINT	n = 0;

	assert((bitmap & 0xffff) != 0);
	if ((bitmap & 0x00ff) == 0) {
		bitmap >>= 8;
		n += 8;
	}
	if ((bitmap & 0x0f) == 0) {
		bitmap >>= 4;
		n += 4;
	}
	return(n + search_table[(bitmap & 0x0f) - 1]);
}

#endif /* CPU_BITMAP_SEARCH */

/*
 *  ōD揇ʃ^XÑT[`
 */
#ifdef __tsksched

TCB *
search_schedtsk()
{
	UINT	schedpri;

	schedpri = bitmap_search(ready_primap);
	return((TCB *)(ready_queue[schedpri].next));
}

#endif /* __tsksched */

/*
 *  słԂւ̈ڍs
 *
 *  ōD揇ʂ̃^XNXV̂́Csł^XNȂꍇ
 *  ƁCtcb ̗DxōD揇ʂ̃^XN̗DxꍇłD
 */
#ifdef __tskrun

BOOL
make_runnable(TCB *tcb)
{
	UINT	pri = tcb->priority;

	tcb->tstat = TS_RUNNABLE;
	LOG_TSKSTAT(tcb);
	queue_insert_prev(&(ready_queue[pri]), &(tcb->task_queue));
	ready_primap |= PRIMAP_BIT(pri);

	if (schedtsk == (TCB *) NULL || pri < schedtsk->priority) {
		schedtsk = tcb;
		return(enadsp);
	}
	return(FALSE);
}

#endif /* __tskrun */

/*
 *  słԂ瑼̏Ԃւ̈ڍs
 *
 *  ōD揇ʂ̃^XNXV̂́Ctcb ōD揇ʂ̃^XNł
 *  ꍇłDtcb ƓDx̃^XNɂꍇ́Ctcb ̎
 *  ^XNōD揇ʂɂȂDłȂꍇ́CfBL[T[`
 *  KvD
 */
#ifdef __tsknrun

BOOL
make_non_runnable(TCB *tcb)
{
	UINT	pri = tcb->priority;
	QUEUE	*queue = &(ready_queue[pri]);

	queue_delete(&(tcb->task_queue));
	if (queue_empty(queue)) {
		ready_primap &= ~PRIMAP_BIT(pri);
		if (schedtsk == tcb) {
			schedtsk = (ready_primap == 0) ? (TCB * ) NULL
						: search_schedtsk();
			return(enadsp);
		}
	}
	else {
		if (schedtsk == tcb) {
			schedtsk = (TCB *)(queue->next);
			return(enadsp);
		}
	}
	return(FALSE);
}

#endif /* __tsknrun */

/*
 *  x~Ԃւ̈ڍs
 */
#ifdef __tskdmt

void
make_dormant(TCB *tcb)
{
	tcb->priority = tcb->tinib->ipriority;
	tcb->tstat = TS_DORMANT;
	tcb->wupcnt = FALSE;
	tcb->enatex = FALSE;
	tcb->texptn = 0;
	create_context(tcb);
	LOG_TSKSTAT(tcb);
}

#endif /* __tskdmt */

/*
 *  x~ԂsłԂւ̈ڍs
 */
#ifdef __tskact

BOOL
make_active(TCB *tcb)
{
	activate_context(tcb);
	return(make_runnable(tcb));
}

#endif /* __tskact */

/*
 *  sԂ̃^XN̏I
 */
#ifdef __tskext

void
exit_task()
{
	make_non_runnable(runtsk);
	make_dormant(runtsk);
	if (runtsk->actcnt) {
		runtsk->actcnt = FALSE;
		make_active(runtsk);
	}
	exit_and_dispatch();
}

#endif /* __tskext */

/*
 *  fBL[̃^XN̗Dx̕ύX
 *
 *  ōD揇ʂ̃^XNXV̂́C(1) tcb ōD揇ʂ̃^XN
 *  łāC̗DxꍇC(2) tcb ōD揇ʂ̃^XN
 *  ͂ȂCύX̗DxōD揇ʂ̃^XN̗Dxꍇ
 *  łD(1) ̏ꍇɂ́CfBL[T[`KvD
 */
#ifdef __tskpri

BOOL
change_priority(TCB *tcb, UINT newpri)
{
	UINT	oldpri = tcb->priority;

	tcb->priority = newpri;
	queue_delete(&(tcb->task_queue));
	if (queue_empty(&(ready_queue[oldpri]))) {
		ready_primap &= ~PRIMAP_BIT(oldpri);
	}
	queue_insert_prev(&(ready_queue[newpri]), &(tcb->task_queue));
	ready_primap |= PRIMAP_BIT(newpri);

	if (schedtsk == tcb) {
		if (newpri >= oldpri) {
			schedtsk = search_schedtsk();
			return(schedtsk != tcb && enadsp);
		}
	}
	else {
		if (newpri < schedtsk->priority) {
			schedtsk = tcb;
			return(enadsp);
		}
	}
	return(FALSE);
}

#endif /* __tskpri */

/*
 *  fBL[̉]
 *
 *  ōD揇ʂ̃^XNXV̂́CōD揇ʂ̃^XN^XNL
 *  [̖ɈړꍇłD
 */
#ifdef __tskrot

BOOL
rotate_ready_queue(UINT pri)
{
	QUEUE	*queue = &(ready_queue[pri]);
	QUEUE	*entry;

	if (!(queue_empty(queue)) && queue->next->next != queue) {
		entry = queue_delete_next(queue);
		queue_insert_prev(queue, entry);
		if (schedtsk == (TCB *) entry) {
			schedtsk = (TCB *)(queue->next);
			return(enadsp);
		}
	}
	return(FALSE);
}

#endif /* __tskrot */

/*
 *  ܂Œ`^XNO[`̌^
 */
typedef void	(*TEXRTN)(TEXPTN texptn, VP_INT exinf);

/*
 *  ^XNO[`̌ďo
 */
#ifdef __tsktex

void
call_texrtn()
{
	TEXPTN	texptn;

	do {
		texptn = runtsk->texptn;
		runtsk->enatex = FALSE;
		runtsk->texptn = 0;
		t_unlock_cpu();
		LOG_TEX_ENTER(texptn);
		(*((TEXRTN)(runtsk->tinib->texrtn)))(texptn,
						runtsk->tinib->exinf);
		LOG_TEX_LEAVE(texptn);
		if (!t_sense_lock()) {
			t_lock_cpu();
		}
	} while (runtsk->texptn != 0);
	runtsk->enatex = TRUE;
}

/*
 *  ^XNO[`̋N
 */
#ifndef OMIT_CALLTEX

void
calltex()
{
	if (runtsk->enatex && runtsk->texptn != 0) {
		call_texrtn();
	}
}

#endif /* OMIT_CALLTEX */
#endif /* __tsktex */
