/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 * 
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 * 
 */

/*
 *   ADSP-BF533 UARTp ȈSIOhCo
 *
 *   ̃t@ĆATOPPERS/JSP 1.4.2 pdic/simple_sio/st16c2550.c
 *   l[A̎ʎqύX̂łB
 */
#include <s_services.h>
#include "uart.h"

/*
 * 8250, 16450, 16550eWX^̃AhXEItZbgBUART_RHR_ƂB
 * VXeƂɈقȂ̂UART_BOUNDARYɂăWX^̔zuEw肷B
 * Ƃ΂ׂẴWX^8rbgEŔzuĂȂAUART_BOUNDARY1,
 * 16bitEȂ2, 32rbgEȂ4w肷B
 * UART_BOUNDARYsys_config.hŒ`B
 */


#define UART_RBR   (0x00 * UART_BOUNDARY)   /*  Mobt@WX^  */
#define UART_THR   (0x00 * UART_BOUNDARY)   /*  Mf[^Ez[hEWX^ */
#define UART_DLL   (0x00 * UART_BOUNDARY)   /*  WX^ʃoCg       */
#define UART_IER   (0x01 * UART_BOUNDARY)   /*  ݃Cl[uWX^       */
#define UART_DLM   (0x01 * UART_BOUNDARY)   /*  WX^ʃoCg       */
#define UART_IIR   (0x02 * UART_BOUNDARY)   /*  ݎʃWX^  */
#define UART_FCR   (0x02 * UART_BOUNDARY)   /*  FIFO䃌WX^  */
#define UART_LCR   (0x03 * UART_BOUNDARY)   /*  C䃌WX^ */
#define UART_MCR   (0x04 * UART_BOUNDARY)   /*  f䃌WX^ */
#define UART_LSR   (0x05 * UART_BOUNDARY)   /*  CEXe[^XEWX^ */
#define UART_MSR   (0x06 * UART_BOUNDARY)   /*  fEXe[^XEWX^ */
#define UART_SCR   (0x07 * UART_BOUNDARY)   /*  XNb`EpbhEWX^ */
#define UART_GCTL  (0x09 * UART_BOUNDARY)	  /*  Blackfin̂݁BO[o䃌WX^ */

/*
 * WX^̃rbg}XNB@\ǉȂAȂĂ悢B
 */

#define ISR_TX            0x02       /* M荞ݔ */
#define IER_TX            0x02       /* M荞݋ */
#define ISR_RX            0x01       /* M荞ݔ */
#define IER_RX            0x01       /* M荞݋ */

#define LCR_DL_MODE       0x80       /* Divisor Enable */
#define LCR_NP_8_1        0x03       /* 8bit,1stop,Noparity,No break */
#define FCR_FIFO_DISABLE  0x00

#define LSR_RX_DATA_READY 0x01
#define LSR_TX_EMPTY      0x20

#define MCR_INT_ENABLE    0x08

#define GCTL_UCEN		  0x01		/* Blackfin̂ */


/*
 * TNUM_SIOP_UART, UART0_ADDRESS, UART0_DIVISOR sys_config.hŒ`B
 *	TNUM_SIOP_UART : PDICǗUARŤ
 *  ȉAPDICǗŏUART̏
 *  	UART0_ADDRESS : 		THR̃AhX
 *  	UART0_DIVISOR : 		DLM, DLL̏l(16bit\L)
 *      UART0_14550_FIFO : 		14550݊FIFOƂɃ}N錾
 *		UART0_BLACKFIN_UCEN : 	BlackfinpB}N錾ƏR[hUART_GCTLUCEN1ɂB
 *	ڈȍ~UARTȂȉ̂悤ɑB
 *  	UART1_ADDRESS : 		THR̃AhX
 *  	UART1_DIVISOR : 		DLM, DLL̏l(16bit\L)
 *      UART1_14550_FIFO : 		14550݊FIFOƂɃ}N錾
 *		UART1_BLACKFIN_UCEN : 	BlackfinpB}N錾ƏR[hUART_GCTLUCEN1ɂB
 *	...
 */


/******************************************************************************************
 * VAI/O|[gubN
 */
#if TNUM_SIOP_UART == 0 
#error "If you don't use UART, please remove this file from your make file" 
#endif

#if TNUM_SIOP_UART > 3
#error "Only TNUM_SIOP_UART < 4 is supported" 
#endif /* TNUM_SIOP_UART >= 2 */    

/* fBoCUvZ}N */
#define DLM(divisor) (divisor/256)
#define DLL(divisor) (divisor%256)

SIOPINIB siopinib_table[TNUM_SIOP_UART] = {
/*-----------------------------------------------------------------
 *			PDICǗŏUART̏p[^ 
 */
    {UART0_ADDRESS,  DLM(UART0_DIVISOR), DLL(UART0_DIVISOR), 
#ifdef UART0_BLACKFIN_UCEN
		1	/* }NUART0_BLACKFIN_UCEN`ĂAGCTLUCEN1ɂăNbN𓮂 */
#else
		0
#endif
	}

/*-----------------------------------------------------------------
 *			PDICǗ2ԖڂUART̏p[^ 
 */

#if TNUM_SIOP_UART > 1
    ,{UART1_ADDRESS,    DLM(UART1_DIVISOR), DLL(UART1_DIVISOR),	
#ifdef UART1_BLACKFIN_UCEN
		1	/* }NUART1_BLACKFIN_UCEN`ĂAGCTLUCEN1ɂăNbN𓮂 */
#else
		0
#endif


	}
#endif /* if TNUM_SIOP_UART > 1*/

/*-----------------------------------------------------------------
 *			PDICǗ3ԖڂUART̏p[^ 
 */
#if TNUM_SIOP_UART > 2
    ,{UART2_ADDRESS,    DLM(UART2_DIVISOR), DLL(UART2_DIVISOR),
#ifdef UART2_BLACKFIN_UCEN
		1	/* }NUART2_BLACKFIN_UCEN`ĂAGCTLUCEN1ɂăNbN𓮂 */
#else
		0
#endif


	}
#endif /* if TNUM_SIOP_UART > 2*/

};

/*
 * VAI/O|[gubN܂ŁB
 ******************************************************************************************/



/*
 *  VAI/O|[gubN̎o
 */
#define INDEX_SIOPINIB(siopid)  ((UINT)((siopid) - 1))
#define get_siopinib(siopid)  (&(siopinib_table[INDEX_SIOPINIB(siopid)]))


/*
 *  VAI/O|[gǗubÑGA
 */
SIOPCB  siopcb_table[TNUM_SIOP_UART];

/*
 *  VAI/O|[gIDǗubNo߂̃}N
 */
#define INDEX_SIOP(siopid)  ((UINT)((siopid) - 1))
#define get_siopcb(siopid)  (&(siopcb_table[INDEX_SIOP(siopid)]))

Inline void
uart_write(UW addr, UW offset, UB val)
{
#ifdef UART_IOP_ACCESS
    sil_wrb_iop((VP)(addr + offset),val);
#else
    sil_wrb_mem((VP)(addr + offset),val);	
#endif
}

Inline UB
uart_read(UW addr, UW offset)
{
#ifdef UART_IOP_ACCESS
    return(sil_reb_iop((VP)(addr + offset)));
#else
    return(sil_reb_mem((VP)(addr + offset)));
#endif
}


/*
 * M?
 */ 
Inline BOOL
uart_getready(SIOPCB *siopcb)
{
    UH status;

    status = uart_read(siopcb->siopinib->reg_base, UART_LSR);
    
    return((status & LSR_RX_DATA_READY));
}

/*
 * 𑗐Mł邩?
 */
Inline BOOL
uart_putready(SIOPCB *siopcb)
{
    UH status;

    status = uart_read(siopcb->siopinib->reg_base, UART_LSR);
    
    return (status & LSR_TX_EMPTY);
}

/*
 *  M̎o
 */
Inline UB
uart_getchar(SIOPCB *siopcb)
{
    return(uart_read(siopcb->siopinib->reg_base,UART_RBR));
}

/*
 *  M镶̏
 */
Inline void
uart_putchar(SIOPCB *siopcb, UB c)
{
    uart_write(siopcb->siopinib->reg_base, UART_THR, c);
}

/*
 *  M݋
 */
Inline void
uart_enable_send(SIOPCB *siopcb)
{
    uart_write(siopcb->siopinib->reg_base, UART_IER,
                (uart_read(siopcb->siopinib->reg_base,UART_IER) | IER_TX));
}

/*
 *  M݋֎~
 */
Inline void
uart_disable_send(SIOPCB *siopcb)
{
    uart_write(siopcb->siopinib->reg_base, UART_IER,
                (uart_read(siopcb->siopinib->reg_base, UART_IER) & ~IER_TX));
                
}

/*
 *  M݋
 */
Inline void
uart_enable_rcv(SIOPCB *siopcb)
{
    uart_write(siopcb->siopinib->reg_base, UART_IER,
                (uart_read(siopcb->siopinib->reg_base,UART_IER) | IER_RX));
}

/*
 *  M݋֎~
 */
Inline void
uart_disable_rcv(SIOPCB *siopcb)
{
    uart_write(siopcb->siopinib->reg_base, UART_IER,
                (uart_read(siopcb->siopinib->reg_base, UART_IER) & ~IER_RX));
                
}


/*
 *  SIOhCȍ[`
 */
void
uart_initialize()
{
    SIOPCB  *siopcb;
    UINT    i;

    /*
     *  VAI/O|[gǗubN̏
     */
    for (siopcb = siopcb_table, i = 0; i < TNUM_SIOP_UART; siopcb++, i++) {
        siopcb->siopinib = &(siopinib_table[i]);
        siopcb->openflag = FALSE;
        siopcb->sendflag = FALSE;
    }
}

    
/*
 *
 */
void
uart_init_siopinib(const SIOPINIB *siopinib)
{

	/*
	 *  Blackfin ADSP-BF531/2/3, BF534/6/7, BF561̓UARTɌŗL̍ƁB
	 *  Power Down[h̉B
	 */
	if ( siopinib->set_ucen )
		uart_write(siopinib->reg_base, UART_GCTL, 
			   (uart_read(siopinib->reg_base, UART_GCTL) | GCTL_UCEN ));
    /*
     *  ̐ݒ
     */
    /* Divisor Enable */
    uart_write(siopinib->reg_base, UART_LCR,
                (uart_read(siopinib->reg_base, UART_LCR) | LCR_DL_MODE));
    uart_write(siopinib->reg_base, UART_DLL, siopinib->dll_val);
    uart_write(siopinib->reg_base, UART_DLM, siopinib->dlm_val);
    /* Divisor Disable */
    uart_write(siopinib->reg_base, UART_LCR,
                (uart_read(siopinib->reg_base, UART_LCR) & ~LCR_DL_MODE));

    /* [hݒ, peB 8bit data, 1 stop bit */
    uart_write(siopinib->reg_base, UART_LCR, LCR_NP_8_1);

    /* ݋֎~ */
    uart_write(siopinib->reg_base, UART_IER, 0x00);
}


/*
 *  J[lÑoi[o͗p̏
 */
void 
uart_init(void)
{
    int i;
	/*
	 * ׂĂuartBid 1TNUM_SIOP_UART܂ŁB
	 */
	for ( i=1; i<=TNUM_SIOP_UART; i++ )
	    uart_init_siopinib(get_siopinib(i));
}

/*
 * I[vĂ|[g邩
 */
BOOL
uart_openflag(void)
{
	int i;
	
	/*
	 * JĂ|[g0ԂBȂ0ԂB
	 */
	for ( i=0; i<TNUM_SIOP_UART; i++ )
		if (siopcb_table[0].openflag)
			return( 1 );
	return( 0 );
}


/*
 * VAI/O|[g̃I[v
 */
SIOPCB *
uart_opn_por(ID siopid, VP_INT exinf)
{
    SIOPCB      *siopcb;
    const SIOPINIB  *siopinib;

    siopcb = get_siopcb(siopid);
    siopinib = siopcb->siopinib;
    
    /*
     * 
     */
    uart_init_siopinib(siopcb->siopinib);
    
    /* M݋ */
    uart_write(siopcb->siopinib->reg_base, UART_IER, IER_RX);
    
    /* ݐCl[u */
    uart_write(siopcb->siopinib->reg_base, UART_MCR, MCR_INT_ENABLE);

    siopcb->exinf = exinf;
    siopcb->getready = siopcb->putready = FALSE;
    siopcb->openflag = TRUE;

    return(siopcb);
}

/*
 *  VAI/O|[g̃N[Y
 */
void
uart_cls_por(SIOPCB *siopcb)
{
    /* ݋֎~ */
    uart_write(siopcb->siopinib->reg_base, UART_IER, 0x00);   
    siopcb->openflag = FALSE;
}


/*
 *  VAI/O|[gւ̃|[Oł̏o
 */
void
uart_pol_putc(char c, ID siopid)
{
    const SIOPINIB *siopinib;
    
    siopinib = get_siopinib(siopid);
    
    while((uart_read(siopinib->reg_base, UART_LSR) & LSR_TX_EMPTY)
          != LSR_TX_EMPTY)
        ;
    uart_write(siopinib->reg_base, UART_THR, c);
}


/*
 *  VAI/O|[gւ̕M
 */
BOOL
uart_snd_chr(SIOPCB *siopcb, char c)
{
    if (uart_putready(siopcb)){
        uart_putchar(siopcb, c);
        return(TRUE);
    }
    return(FALSE);
}

/*
 *  VAI/O|[g̕M
 */
INT
uart_rcv_chr(SIOPCB *siopcb)
{
    if (uart_getready(siopcb)) {
        return((INT)(UB) uart_getchar(siopcb));
    }
    return(-1);
}





/*
 *  VAI/O|[g̃R[obN̋
 */
void
uart_ena_cbr(SIOPCB *siopcb, UINT cbrtn)
{

    switch (cbrtn) {
        case SIO_ERDY_SND:
            uart_enable_send(siopcb);
            break;
        case SIO_ERDY_RCV:
            uart_enable_rcv(siopcb);
            break;
    }
}

/*
 *  VAI/O|[g̃R[obN̋֎~
 */
void
uart_dis_cbr(SIOPCB *siopcb, UINT cbrtn)
{
    switch (cbrtn) {
        case SIO_ERDY_SND:
            uart_disable_send(siopcb);
            break;
        case SIO_ERDY_RCV:
            uart_disable_rcv(siopcb);
            break;
    }
}

/*
 *  VAI/O|[gɑ΂銄ݏ
 */
static void
uart_rx_isr_siop(SIOPCB *siopcb)
{
    if (uart_getready(siopcb)) {
        /*
         *  MʒmR[obN[`ĂяoD
         */
        uart_ierdy_rcv(siopcb->exinf);
    }
}

static void
uart_tx_isr_siop(SIOPCB *siopcb)
{
    if (uart_putready(siopcb)) {
        /*
         *  M\R[obN[`ĂяoD
         */
        uart_ierdy_snd(siopcb->exinf);
    }
}

/*
 *  SIO̊݃T[rX[`
 *	ADSP-BF533̓UART͑ɕʁX̊ݗvo߁A
 *  ISRĂB܂AADSP-BF537̂悤ɓȏ
 *  UARTꍇlāAuart0̂悤Ƀ|[gԍ
 *  OɃn[hR[hĂB
 *  Ã|[gԍƂ́ASIÕ|[gԍłāA
 *  n[hEFAUARTԍƓƂ͌ȂB
 */

/*
 ***** UART0
 */
void
uart0_rx_isr()
{
		/* ʂ̎MĂ */
    uart_rx_isr_siop(&(siopcb_table[0]));
}

void
uart0_tx_isr()
{
		/* ʂ̑MĂ */
    uart_tx_isr_siop(&(siopcb_table[0]));
}

/*
 ***** UART1
 */
void
uart1_rx_isr()
{
		/* ʂ̎MĂ */
    uart_rx_isr_siop(&(siopcb_table[1]));
}

void
uart1_tx_isr()
{
		/* ʂ̑MĂ */
    uart_tx_isr_siop(&(siopcb_table[1]));
}

/*
 ***** UART2
 */
void
uart2_rx_isr()
{
		/* ʂ̎MĂ */
    uart_rx_isr_siop(&(siopcb_table[2]));
}

void
uart2_tx_isr()
{
		/* ʂ̑MĂ */
    uart_tx_isr_siop(&(siopcb_table[2]));
}





/*
 * UART̑Ŋ݂LꍇîقʓIj́A
 * ̃[`ł͂Ȃ݃T[rX[`ƂĎgB
 */
void
uart0_isr()
{
		/* ʂ̎MĂ */
    uart_rx_isr_siop(&(siopcb_table[0]));
		/* ʂ̑MĂ */
    uart_tx_isr_siop(&(siopcb_table[0]));
}

void
uart1_isr()
{
		/* ʂ̎MĂ */
    uart_rx_isr_siop(&(siopcb_table[1]));
		/* ʂ̑MĂ */
    uart_tx_isr_siop(&(siopcb_table[1]));
}

void
uart2_isr()
{
		/* ʂ̎MĂ */
    uart_rx_isr_siop(&(siopcb_table[2]));
		/* ʂ̑MĂ */
    uart_tx_isr_siop(&(siopcb_table[2]));
}
