/*
 * Decompiled with CFR 0.152.
 */
package com.ozacc.mail.trotter;

import com.ozacc.mail.trotter.Column;
import com.ozacc.mail.trotter.DBConfig;
import java.io.UnsupportedEncodingException;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import org.w3c.dom.Element;

class Config {
    private String host = "localhost";
    private int port = 25;
    private String senderName;
    private String senderAddress;
    private String returnPath;
    private String subject = "";
    private long interval = 500L;
    private boolean monitored;
    private String listType;
    private String listFileName;
    private String bodyFileName = "";
    private String bodyEncoding = System.getProperty("file.encoding");
    private List columnList = new Vector();
    private DBConfig dbConfig;
    private Properties headers;
    private Element log4jConfig;

    Config() {
    }

    void addColumn(Column column) {
        this.columnList.add(column);
    }

    Column getColumn(String string) {
        Iterator iterator = this.columnList.iterator();
        while (iterator.hasNext()) {
            Column column = (Column)iterator.next();
            if (!column.getName().equals(string)) continue;
            return column;
        }
        return null;
    }

    List getColumnList() {
        return this.columnList;
    }

    String getHost() {
        return this.host;
    }

    int getPort() {
        return this.port;
    }

    String getReturnPath() {
        if (this.returnPath != null) {
            return this.returnPath;
        }
        return this.senderAddress;
    }

    String getSenderAddress() {
        return this.senderAddress;
    }

    String getSenderName() {
        return this.senderName;
    }

    InternetAddress getInternetAddress() throws AddressException {
        try {
            if (this.getSenderName() != null) {
                InternetAddress internetAddress = new InternetAddress(this.getSenderAddress(), this.getSenderName(), "ISO-2022-JP");
                internetAddress.validate();
                return internetAddress;
            }
            return new InternetAddress(this.getSenderAddress(), true);
        }
        catch (AddressException addressException) {
            throw new AddressException("\u30e1\u30fc\u30eb\u30a2\u30c9\u30ec\u30b9\u304c\u6587\u6cd5\u7684\u306b\u8aa4\u3063\u3066\u3044\u308b\u53ef\u80fd\u6027\u304c\u3042\u308a\u307e\u3059\u3002");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new AddressException(unsupportedEncodingException.getMessage());
        }
    }

    String getSubject() {
        return this.subject;
    }

    void setHost(String string) {
        this.host = string;
    }

    void setPort(int n) {
        this.port = n;
    }

    void setReturnPath(String string) {
        this.returnPath = string;
    }

    void setSenderAddress(String string) {
        this.senderAddress = string;
    }

    void setSenderName(String string) {
        this.senderName = string;
    }

    void setSubject(String string) {
        this.subject = string;
    }

    String getListFileName() {
        return this.listFileName;
    }

    void setListFileName(String string) {
        this.listFileName = string;
    }

    String getListType() {
        return this.listType;
    }

    void setListType(String string) {
        this.listType = string;
    }

    long getInterval() {
        return this.interval;
    }

    void setInterval(long l) {
        this.interval = l;
    }

    List getReplaceColumnList() {
        Vector<Column> vector = new Vector<Column>();
        Iterator iterator = this.columnList.iterator();
        while (iterator.hasNext()) {
            Column column = (Column)iterator.next();
            if (!column.isReplace()) continue;
            vector.add(column);
        }
        return vector;
    }

    boolean needReplace() {
        List list = this.getReplaceColumnList();
        return list.size() > 0;
    }

    DBConfig getDbConfig() {
        return this.dbConfig;
    }

    void setDbConfig(DBConfig dBConfig) {
        this.dbConfig = dBConfig;
    }

    String getBodyEncoding() {
        return this.bodyEncoding;
    }

    String getBodyFileName() {
        return this.bodyFileName;
    }

    void setBodyEncoding(String string) {
        this.bodyEncoding = string;
    }

    void setBodyFileName(String string) {
        this.bodyFileName = string;
    }

    Element getLog4jConfig() {
        return this.log4jConfig;
    }

    void setLog4jConfig(Element element) {
        this.log4jConfig = element;
    }

    boolean isMonitored() {
        return this.monitored;
    }

    void setMonitored(boolean bl) {
        this.monitored = bl;
    }

    void addHeader(String string, String string2) {
        if (this.headers == null) {
            this.headers = new Properties();
        }
        this.headers.setProperty(string, string2);
    }

    Properties getHeaders() {
        return this.headers;
    }
}

