/*
 * Decompiled with CFR 0.152.
 */
package com.ozacc.mail.trotter;

import com.ozacc.mail.trotter.Config;
import com.ozacc.mail.trotter.ConfigParser;
import java.io.File;
import java.io.IOException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

class DomConfigParser
extends ConfigParser {
    private DocumentBuilder builder;

    DomConfigParser() throws ParserConfigurationException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        this.builder = documentBuilderFactory.newDocumentBuilder();
    }

    Config parse(File file) throws IOException {
        try {
            Document document = this.builder.parse(file);
            this.config = new Config();
            this.parseSmtp(document);
            this.parseSender(document);
            this.parseSubject(document);
            this.parseReturnPath(document);
            this.parseList(document);
            return this.getConfig();
        }
        catch (SAXException sAXException) {
            throw new IOException(sAXException.getMessage());
        }
        catch (DOMException dOMException) {
            throw new IOException(dOMException.getMessage());
        }
    }

    private void parseSmtp(Document document) {
        try {
            NodeList nodeList = document.getElementsByTagName("smtp");
            Node node = nodeList.item(0);
            if (node != null && node.hasChildNodes()) {
                nodeList = node.getChildNodes();
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    Node node2 = nodeList.item(i);
                    if (node2.getNodeName().equalsIgnoreCase("host")) {
                        this.config.setHost(node2.getFirstChild().getNodeValue());
                        continue;
                    }
                    if (!node2.getNodeName().equalsIgnoreCase("port")) continue;
                    this.config.setPort(Integer.parseInt(node2.getFirstChild().getNodeValue()));
                }
            }
        }
        catch (DOMException dOMException) {
            dOMException.printStackTrace();
        }
    }

    private void parseSender(Document document) {
        try {
            NodeList nodeList = document.getElementsByTagName("sender");
            Node node = nodeList.item(0);
            if (node != null && node.hasChildNodes()) {
                nodeList = node.getChildNodes();
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    Node node2 = nodeList.item(i);
                    if (node2.getNodeName().equalsIgnoreCase("name")) {
                        this.config.setSenderName(node2.getFirstChild().getNodeValue());
                        continue;
                    }
                    if (!node2.getNodeName().equalsIgnoreCase("email")) continue;
                    this.config.setSenderAddress(node2.getFirstChild().getNodeValue());
                }
            }
        }
        catch (DOMException dOMException) {
            dOMException.printStackTrace();
        }
    }

    private void parseSubject(Document document) {
        try {
            Node node;
            NodeList nodeList = document.getElementsByTagName("subject");
            if (nodeList.getLength() > 0 && (node = nodeList.item(0)).hasChildNodes()) {
                this.config.setSubject(node.getFirstChild().getNodeValue());
            }
        }
        catch (DOMException dOMException) {
            dOMException.printStackTrace();
        }
    }

    private void parseReturnPath(Document document) {
        try {
            Node node;
            NodeList nodeList = document.getElementsByTagName("return-path");
            if (nodeList != null && nodeList.getLength() > 0 && (node = nodeList.item(0)).hasChildNodes()) {
                this.config.setReturnPath(node.getFirstChild().getNodeValue());
            }
        }
        catch (DOMException dOMException) {
            dOMException.printStackTrace();
        }
    }

    private void parseList(Document document) {
        try {
            NodeList nodeList = document.getElementsByTagName("list");
            Element element = (Element)nodeList.item(0);
            if (element != null) {
                String string = element.getAttribute("type");
                this.config.setListType(string);
                if (string.equalsIgnoreCase("plain")) {
                    nodeList = element.getChildNodes();
                    for (int i = 0; i < nodeList.getLength(); ++i) {
                        Node node = nodeList.item(i);
                        if (!node.getNodeName().equalsIgnoreCase("filepath")) continue;
                        String string2 = node.getFirstChild().getNodeValue();
                        this.config.setListFileName(string2);
                    }
                }
            }
        }
        catch (DOMException dOMException) {
            dOMException.printStackTrace();
        }
    }

    public static void main(String[] stringArray) {
        try {
            DomConfigParser domConfigParser = new DomConfigParser();
            Config config = domConfigParser.parse(stringArray[0]);
            System.out.println("SMTP host is " + config.getHost());
            System.out.println("SMTP port is " + config.getPort());
            System.out.println("Sender name is " + config.getSenderName());
            System.out.println("Sender address is " + config.getSenderAddress());
            System.out.println("Subject is " + config.getSubject());
            System.out.println("Return-Path is " + config.getReturnPath());
            System.out.println("ListType is " + config.getListType());
            System.out.println("ListFileName is " + config.getListFileName());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

