/*
 * Decompiled with CFR 0.152.
 */
package com.ozacc.mail.trotter;

import com.ozacc.mail.trotter.Column;
import com.ozacc.mail.trotter.Config;
import com.ozacc.mail.trotter.ConfigParser;
import com.ozacc.mail.trotter.DBConfig;
import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.w3c.dom.NodeList;

class JDOMConfigParser
extends ConfigParser {
    JDOMConfigParser() {
    }

    Config parse(File file) throws IOException {
        this.config = new Config();
        try {
            SAXBuilder sAXBuilder = new SAXBuilder();
            Document document = sAXBuilder.build(file);
            Element element = document.getRootElement();
            this.parseSmtp(element);
            this.parseSender(element);
            this.parseSubject(element);
            this.parseBody(element);
            this.parseInterval(element);
            this.parseMonitor(element);
            this.parseReturnPath(element);
            this.parseList(element);
            this.parseOptionHeader(element);
            this.parseLog4jConfig(file);
        }
        catch (JDOMException jDOMException) {
            throw new IOException(jDOMException.getMessage());
        }
        return this.config;
    }

    private void parseReturnPath(Element element) {
        String string = element.getChildTextNormalize("return-path");
        if (string != null && !string.equals("")) {
            this.config.setReturnPath(string);
        }
    }

    private void parseSubject(Element element) {
        String string = element.getChildTextNormalize("subject");
        if (string != null && !string.equals("")) {
            this.config.setSubject(string);
        }
    }

    private void parseBody(Element element) {
        Element element2 = element.getChild("body");
        if (element2 == null) {
            return;
        }
        Iterator iterator = element2.getChildren().iterator();
        while (iterator.hasNext()) {
            String string;
            Element element3 = (Element)iterator.next();
            if (element3.getName().equals("filepath")) {
                string = element3.getTextNormalize();
                if (string == null || string.equals("")) continue;
                this.config.setBodyFileName(string);
                continue;
            }
            if (!element3.getName().equals("encoding") || (string = element3.getTextNormalize()) == null || string.equals("")) continue;
            this.config.setBodyEncoding(string);
        }
    }

    private void parseInterval(Element element) {
        String string = element.getChildTextNormalize("interval");
        if (string != null && !string.equals("")) {
            this.config.setInterval(Long.parseLong(string));
        }
    }

    private void parseMonitor(Element element) {
        String string;
        Element element2 = element.getChild("monitor");
        if (element2 != null && ((string = element2.getAttributeValue("value")) == null || string.equalsIgnoreCase("true") || string.equals("1"))) {
            this.config.setMonitored(true);
        }
    }

    private void parseSmtp(Element element) {
        Element element2 = element.getChild("smtp");
        if (element2 == null) {
            return;
        }
        Iterator iterator = element2.getChildren().iterator();
        while (iterator.hasNext()) {
            String string;
            element2 = (Element)iterator.next();
            if (element2.getName().equals("host")) {
                string = element2.getTextNormalize();
                if (string == null || string.equals("")) continue;
                this.config.setHost(element2.getTextNormalize());
                continue;
            }
            if (!element2.getName().equals("port") || (string = element2.getTextNormalize()) == null || string.equals("")) continue;
            this.config.setPort(Integer.parseInt(element2.getTextNormalize()));
        }
    }

    private void parseSender(Element element) throws JDOMException {
        Element element2 = element.getChild("sender");
        if (element2 == null) {
            throw new JDOMException("\u9001\u4fe1\u8005\u304c\u8a2d\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002");
        }
        Iterator iterator = element2.getChildren().iterator();
        while (iterator.hasNext()) {
            element2 = (Element)iterator.next();
            if (element2.getName().equals("name")) {
                this.config.setSenderName(element2.getTextNormalize());
                continue;
            }
            if (!element2.getName().equals("email")) continue;
            this.config.setSenderAddress(element2.getTextNormalize());
        }
    }

    private void parseList(Element element) throws JDOMException {
        Element element2 = element.getChild("list");
        if (element2 == null) {
            throw new JDOMException("\u30ea\u30b9\u30c8\u304c\u8a2d\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002");
        }
        String string = element2.getAttributeValue("type");
        if (string == null || string.equals("")) {
            throw new JDOMException("\u30ea\u30b9\u30c8\u30bf\u30a4\u30d7\u304c\u8a2d\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002");
        }
        if (string.equals("plain")) {
            this.config.setListType("plain");
            this.parsePlainList(element2);
        } else if (string.equals("csv")) {
            this.config.setListType("csv");
            this.parseCSVList(element2);
            this.parseReplaceList(element);
        } else if (string.equals("database")) {
            this.config.setListType("database");
            this.parseDatabaseList(element2);
            this.parseReplaceList(element);
        }
    }

    private void parsePlainList(Element element) throws JDOMException {
        String string = element.getChildTextNormalize("filepath");
        if (string == null || string.equals("")) {
            throw new JDOMException("\u30ea\u30b9\u30c8\u30d5\u30a1\u30a4\u30eb\u306e\u30d1\u30b9\u304c\u8a2d\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002");
        }
        this.config.setListFileName(string);
    }

    private void parseCSVList(Element element) throws JDOMException {
        String string = element.getChildTextNormalize("filepath");
        if (string == null || string.equals("")) {
            throw new JDOMException("\u30ea\u30b9\u30c8\u30d5\u30a1\u30a4\u30eb\u306e\u30d1\u30b9\u304c\u8a2d\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002");
        }
        this.config.setListFileName(string);
        Element element2 = element.getChild("schema");
        if (element2 == null) {
            throw new JDOMException("CSV\u30b9\u30ad\u30fc\u30de\u304c\u8a2d\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002");
        }
        this.parseSchema(element2);
    }

    private void parseSchema(Element element) throws JDOMException {
        Iterator iterator = element.getChildren().iterator();
        while (iterator.hasNext()) {
            Element element2 = (Element)iterator.next();
            String string = element2.getAttributeValue("name");
            String string2 = element2.getAttributeValue("type");
            if (string == null) {
                throw new JDOMException("\u30b9\u30ad\u30fc\u30de\u306ecolumn\u306bname\u5c5e\u6027\u304c\u30bb\u30c3\u30c8\u3055\u308c\u3066\u3044\u306a\u3044\u3082\u306e\u304c\u3042\u308a\u307e\u3059\u3002");
            }
            Column column = new Column(string);
            if (string2 != null && string2.equals("name")) {
                column.setType(1);
            } else if (string2 != null && string2.equals("email")) {
                column.setType(2);
            } else {
                column.setType(3);
            }
            this.config.addColumn(column);
        }
    }

    private void parseReplaceList(Element element) {
        Element element2 = element.getChild("replace-list");
        if (element2 == null) {
            return;
        }
        Iterator iterator = element2.getChildren().iterator();
        while (iterator.hasNext()) {
            Column column;
            Element element3 = (Element)iterator.next();
            if (!element3.getName().equals("replace")) continue;
            String string = element3.getAttributeValue("column");
            String string2 = this.escapeForRegex(element3.getAttributeValue("source"));
            if (string == null || string.equals("") || string2 == null || string2.equals("") || (column = this.config.getColumn(string)) == null) continue;
            column.setSource(string2);
        }
    }

    private String escapeForRegex(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = string.length();
        block8: for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '[': {
                    stringBuffer.append("\\[");
                    continue block8;
                }
                case ']': {
                    stringBuffer.append("\\]");
                    continue block8;
                }
                case '(': {
                    stringBuffer.append("\\(");
                    continue block8;
                }
                case ')': {
                    stringBuffer.append("\\)");
                    continue block8;
                }
                case '{': {
                    stringBuffer.append("\\{");
                    continue block8;
                }
                case '}': {
                    stringBuffer.append("\\}");
                    continue block8;
                }
                default: {
                    stringBuffer.append(c);
                }
            }
        }
        return stringBuffer.toString();
    }

    private void parseDatabaseList(Element element) throws JDOMException {
        String string;
        Element element2;
        Element element3 = element.getChild("setting");
        if (element3 == null) {
            throw new JDOMException("\u30c7\u30fc\u30bf\u30d9\u30fc\u30b9\u306e\u8a2d\u5b9a\u304c\u884c\u308f\u308c\u3066\u3044\u307e\u305b\u3093\u3002");
        }
        String string2 = element3.getAttributeValue("product");
        String string3 = element3.getAttributeValue("driver");
        if (string3 == null || string3.equals("") || string2 == null || string2.equals("")) {
            throw new JDOMException("\u30c7\u30fc\u30bf\u30d9\u30fc\u30b9\u540d\u3001\u307e\u305f\u306f\u30c9\u30e9\u30a4\u30d0\u304c\u8a2d\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002");
        }
        DBConfig dBConfig = new DBConfig();
        dBConfig.setDriver(string3);
        dBConfig.setSubprotocol(string2);
        Iterator iterator = element3.getChildren().iterator();
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        while (iterator.hasNext()) {
            element2 = (Element)iterator.next();
            if (element2.getName().equals("host")) {
                string = element2.getTextNormalize();
                if (string == null) continue;
                dBConfig.setHost(string);
                continue;
            }
            if (element2.getName().equals("port")) {
                string = element2.getTextNormalize();
                if (string == null) continue;
                dBConfig.setPort(Integer.parseInt(string));
                continue;
            }
            if (element2.getName().equals("database")) {
                string = element2.getTextNormalize();
                if (string == null || string.equals("")) {
                    throw new JDOMException("\u30c7\u30fc\u30bf\u30d9\u30fc\u30b9\u540d\u304c\u8a2d\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002");
                }
                dBConfig.setDatabase(string);
                bl = true;
                continue;
            }
            if (element2.getName().equals("user")) {
                string = element2.getTextNormalize();
                if (string == null) {
                    throw new JDOMException("\u30c7\u30fc\u30bf\u30d9\u30fc\u30b9\u30e6\u30fc\u30b6\u540d\u304c\u8a2d\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002");
                }
                dBConfig.setUser(string);
                bl2 = true;
                continue;
            }
            if (!element2.getName().equals("password")) continue;
            string = element2.getTextNormalize();
            if (string == null) {
                throw new JDOMException("\u30c7\u30fc\u30bf\u30d9\u30fc\u30b9\u30d1\u30b9\u30ef\u30fc\u30c9\u304c\u8a2d\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002");
            }
            dBConfig.setPassword(string);
            bl3 = true;
        }
        if (!(bl && bl2 && bl3)) {
            throw new JDOMException("\u30c7\u30fc\u30bf\u30d9\u30fc\u30b9\u306e\u8a2d\u5b9a\u3067\u6b20\u3051\u3066\u3044\u308b\u9805\u76ee\u304c\u3042\u308a\u307e\u3059\u3002");
        }
        element2 = element.getChild("sql");
        if (element2 == null) {
            throw new JDOMException("SQL\u30af\u30a8\u30ea\u304c\u8a2d\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002");
        }
        string = element2.getTextNormalize();
        if (string == null || string.equals("")) {
            throw new JDOMException("SQL\u30af\u30a8\u30ea\u304c\u8a2d\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002");
        }
        dBConfig.setSql(string);
        this.config.setDbConfig(dBConfig);
        Element element4 = element.getChild("schema");
        if (element4 == null) {
            throw new JDOMException("\u30c7\u30fc\u30bf\u30d9\u30fc\u30b9\u30b9\u30ad\u30fc\u30de\u304c\u8a2d\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002");
        }
        this.parseSchema(element4);
    }

    private void parseLog4jConfig(File file) {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            org.w3c.dom.Document document = documentBuilder.parse(file);
            NodeList nodeList = document.getElementsByTagName("log4j:configuration");
            org.w3c.dom.Element element = (org.w3c.dom.Element)nodeList.item(0);
            this.config.setLog4jConfig(element);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void parseOptionHeader(Element element) {
        Element element2 = element.getChild("option-header");
        if (element2 == null) {
            return;
        }
        Iterator iterator = element2.getChildren("header").iterator();
        while (iterator.hasNext()) {
            Element element3 = (Element)iterator.next();
            String string = element3.getAttributeValue("name");
            String string2 = element3.getAttributeValue("value");
            if (string == null || string.equals("") || string2 == null || string2.equals("")) continue;
            this.config.addHeader(string, string2);
        }
    }

    public static void main(String[] stringArray) {
        try {
            Object object;
            Object object2;
            JDOMConfigParser jDOMConfigParser = new JDOMConfigParser();
            Config config = jDOMConfigParser.parse(stringArray[0]);
            System.out.println("Host: " + config.getHost());
            System.out.println("Port: " + config.getPort());
            System.out.println("SenderName: " + config.getSenderName());
            System.out.println("SenderAddress: " + config.getSenderAddress());
            System.out.println("Subject: " + config.getSubject());
            System.out.println("BodyFile: " + config.getBodyFileName());
            System.out.println("BodyEncoding: " + config.getBodyEncoding());
            System.out.println("Interval: " + config.getInterval());
            System.out.println("Monitor: " + config.isMonitored());
            System.out.println("Return-Path: " + config.getReturnPath());
            System.out.println("ListType: " + config.getListType());
            System.out.println("ListFile: " + config.getListFileName());
            System.out.println("Log4jElement: " + config.getLog4jConfig());
            if (config.getHeaders() != null) {
                System.out.println("----- OptionHeader -----");
                object2 = config.getHeaders();
                Enumeration<Object> enumeration = ((Properties)object2).keys();
                while (enumeration.hasMoreElements()) {
                    String string = (String)enumeration.nextElement();
                    object = ((Properties)object2).getProperty(string);
                    System.out.println("Header: " + string + " / Value: " + (String)object);
                }
            }
            if (config.getListType().equals("csv")) {
                int n;
                System.out.println("----- CSV -----");
                object2 = config.getColumnList();
                int n2 = object2.size();
                for (n = 0; n < n2; ++n) {
                    object = (Column)object2.get(n);
                    System.out.println("Column Type: " + ((Column)object).getType());
                    System.out.println("Column Name: " + ((Column)object).getName());
                }
                System.out.println("----- Replace -----");
                object2 = config.getReplaceColumnList();
                n2 = object2.size();
                for (n = 0; n < n2; ++n) {
                    object = (Column)object2.get(n);
                    System.out.println("Replace Source: " + ((Column)object).getSource());
                    System.out.println("Replace Column Name: " + ((Column)object).getName());
                }
            } else if (config.getListType().equals("database")) {
                System.out.println("----- Database -----");
                object2 = config.getColumnList();
                int n = object2.size();
                for (int i = 0; i < n; ++i) {
                    object = (Column)object2.get(i);
                    System.out.println("Column Type: " + ((Column)object).getType());
                    System.out.println("Column Name: " + ((Column)object).getName());
                }
                DBConfig dBConfig = config.getDbConfig();
                System.out.println("----- DB Setting -----");
                System.out.println("Driver: " + dBConfig.getDriver());
                System.out.println("Subprotocol: " + dBConfig.getSubprotocol());
                System.out.println("Host: " + dBConfig.getHost());
                System.out.println("Port: " + dBConfig.getPort());
                System.out.println("Database: " + dBConfig.getDatabase());
                System.out.println("URL: " + dBConfig.getURL());
                System.out.println("User: " + dBConfig.getUser());
                System.out.println("Password: " + dBConfig.getPassword());
                System.out.println("SQL Query: " + dBConfig.getSql());
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

