/*
 * Decompiled with CFR 0.152.
 */
package com.ozacc.mail.trotter;

import com.ozacc.mail.trotter.CSVListReader;
import com.ozacc.mail.trotter.Config;
import com.ozacc.mail.trotter.DBListReader;
import com.ozacc.mail.trotter.ListReader;
import com.ozacc.mail.trotter.PlainListReader;

class ListReaderFactory {
    private Config config;

    ListReaderFactory() {
    }

    void setConfig(Config config) {
        this.config = config;
    }

    ListReader newListReader(Config config) {
        this.setConfig(config);
        return this.newListReader();
    }

    ListReader newListReader() {
        if (this.config == null) {
            return null;
        }
        if (this.config.getListType().equalsIgnoreCase("plain")) {
            return PlainListReader.getInstance(this.config);
        }
        if (this.config.getListType().equalsIgnoreCase("csv")) {
            return CSVListReader.getInstance(this.config);
        }
        if (this.config.getListType().equalsIgnoreCase("database")) {
            return DBListReader.getInstance(this.config);
        }
        return null;
    }
}

