/*
 * Decompiled with CFR 0.152.
 */
package com.ozacc.mail.trotter.emp;

import com.ozacc.mail.trotter.emp.Config;
import com.ozacc.mail.trotter.emp.Mail;
import com.ozacc.mail.trotter.emp.MailReader;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.NoSuchElementException;
import java.util.Properties;
import javax.mail.Flags;
import javax.mail.Folder;
import javax.mail.MessagingException;
import javax.mail.Part;
import javax.mail.Session;
import javax.mail.Store;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.apache.log4j.Logger;

class InternetMailReader
implements MailReader {
    private Config config;
    private Store store;
    private Folder currentFolder;
    private int total;
    private int count = 1;
    private static Logger logger = Logger.getLogger((String)(class$com$ozacc$mail$trotter$emp$InternetMailReader == null ? (class$com$ozacc$mail$trotter$emp$InternetMailReader = InternetMailReader.class$("com.ozacc.mail.trotter.emp.InternetMailReader")) : class$com$ozacc$mail$trotter$emp$InternetMailReader).getName());
    static /* synthetic */ Class class$com$ozacc$mail$trotter$emp$InternetMailReader;

    InternetMailReader(Config config) {
        this.config = config;
    }

    public boolean open() {
        Session session = Session.getInstance((Properties)new Properties(), null);
        try {
            this.store = session.getStore(this.config.getProtocol());
            this.connect();
        }
        catch (Exception exception) {
            logger.fatal((Object)("\u30e1\u30fc\u30eb\u30b5\u30fc\u30d0\u306e\u63a5\u7d9a\u306b\u5931\u6557\u3002" + exception.getMessage()));
            return false;
        }
        try {
            this.setCurrentFolder("INBOX");
        }
        catch (MessagingException messagingException) {
            // empty catch block
        }
        logger.debug((Object)"\u30e1\u30fc\u30eb\u30b5\u30fc\u30d0\u306b\u63a5\u7d9a\u3002");
        return true;
    }

    private void connect() throws MessagingException {
        this.store.connect(this.config.getHost(), this.config.getUser(), this.config.getPassword());
    }

    private void setCurrentFolder(String string) throws MessagingException {
        if (this.currentFolder != null && this.currentFolder.isOpen()) {
            this.currentFolder.close(true);
        }
        this.currentFolder = this.store.getFolder(string);
        try {
            this.currentFolder.open(2);
        }
        catch (MessagingException messagingException) {
            this.currentFolder.open(1);
        }
        this.total = this.currentFolder.getMessageCount();
        logger.debug((Object)("\u30e1\u30fc\u30eb\u30dc\u30c3\u30af\u30b9\u5185\u306e\u7dcf\u30e1\u30fc\u30eb\u6570: " + this.total));
    }

    public void close() {
        if (this.currentFolder != null && this.currentFolder.isOpen()) {
            try {
                this.currentFolder.close(true);
            }
            catch (MessagingException messagingException) {
                System.err.println(messagingException.getMessage());
            }
        }
        this.currentFolder = null;
        this.count = 1;
        try {
            this.store.close();
            logger.debug((Object)"\u30e1\u30fc\u30eb\u30b5\u30fc\u30d0\u3068\u306e\u63a5\u7d9a\u3092\u5207\u65ad\u3002");
        }
        catch (MessagingException messagingException) {
            logger.error((Object)("\u30e1\u30fc\u30eb\u30b5\u30fc\u30d0\u306e\u5207\u65ad\u306b\u5931\u6557\u3002" + messagingException.getMessage()));
        }
    }

    public synchronized Mail next() {
        if (this.currentFolder == null) {
            try {
                this.setCurrentFolder("INBOX");
            }
            catch (MessagingException messagingException) {
                // empty catch block
            }
        }
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        MimeMessage mimeMessage = null;
        try {
            mimeMessage = (MimeMessage)this.currentFolder.getMessage(this.count);
            mimeMessage.setFlag(Flags.Flag.DELETED, this.config.isDelete());
        }
        catch (MessagingException messagingException) {
            logger.error((Object)("\u30e1\u30fc\u30eb\u306e\u53d6\u5f97\u306b\u5931\u6557\u3002" + messagingException.getMessage()));
            return null;
        }
        Mail mail = null;
        try {
            mail = this.generateMail(mimeMessage);
            mail.addMessage(mimeMessage);
        }
        catch (Exception exception) {
            logger.error((Object)("Mail \u306e\u53d6\u5f97\u306b\u5931\u6557\u3002" + exception.getMessage()));
        }
        ++this.count;
        return mail;
    }

    public boolean hasNext() {
        return this.total >= this.count;
    }

    private Mail generateMail(MimeMessage mimeMessage) throws MessagingException, IOException {
        Object object = null;
        try {
            object = mimeMessage.getContent();
        }
        catch (IOException iOException) {
            return this.parse(this.generateTextContent((Part)mimeMessage));
        }
        if (mimeMessage.getContentType().equals("text/plain") || object instanceof String) {
            return this.parse((String)object);
        }
        return this.parse((MimeMultipart)object);
    }

    private Mail parse(MimeMultipart mimeMultipart) throws MessagingException {
        int n;
        try {
            n = mimeMultipart.getCount();
        }
        catch (MessagingException messagingException) {
            throw new MessagingException("Part \u6570\u3092\u5224\u5225\u3067\u304d\u307e\u305b\u3093\u3002");
        }
        for (int i = 0; i < n; ++i) {
            try {
                MimeBodyPart mimeBodyPart = (MimeBodyPart)mimeMultipart.getBodyPart(i);
                if (!mimeBodyPart.isMimeType("message/rfc822") && !mimeBodyPart.isMimeType("text/rfc822-headers")) continue;
                return this.parse(this.generateTextContent((Part)mimeBodyPart));
            }
            catch (MessagingException messagingException) {
                throw new MessagingException("MimeType \u304c\u4e0d\u660e\u3002");
            }
            catch (IOException iOException) {
                throw new MessagingException("InputStream \u53d6\u5f97\u306b\u5931\u6557\u3002");
            }
        }
        throw new MessagingException("MimeType \u304c\u4e0d\u660e\u3002");
    }

    private String generateTextContent(Part part) throws IOException, MessagingException {
        return this.generateTextContent(part.getInputStream());
    }

    private String generateTextContent(InputStream inputStream) throws IOException, MessagingException {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        StringBuffer stringBuffer = new StringBuffer();
        String string = null;
        while ((string = bufferedReader.readLine()) != null) {
            stringBuffer.append(string);
            stringBuffer.append("\n");
        }
        bufferedReader.close();
        return stringBuffer.toString().trim();
    }

    private Mail parse(String string) {
        Mail mail = new Mail();
        mail.setContent(string);
        return mail;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

