open OUnit

let assert_equal_c = assert_equal ~cmp:Cstrs.equal ~printer:Cstrs.to_string 

let test_of_list _ =
  begin
    assert_equal_c Cstrs.empty (Cstrs.of_list []);
    assert_equal_c
      (Cstrs.add (Cstrs.Subtype(Type.base "Integer",Type.var 12)) Cstrs.empty)
      (Cstrs.of_list [Cstrs.Subtype(Type.base "Integer", Type.var 12)]);
  end

let test_transitives _ =
  let c1 = (Cstrs.of_list [(Cstrs.Subtype (Type.var 1, Type.var 2)); 
			   (Cstrs.Subtype (Type.var 2, Type.var 3));
			   (Cstrs.Subtype (Type.var 3, Type.var 4));]) in
    begin
      assert_equal_c
	(Cstrs.of_list [(Cstrs.Subtype (Type.var 1, Type.var 4))])
	(snd (Cstrs.remove_transitives (fun _ -> true) c1));
    end
    
let test_to_string _ =
  begin
    assert_equal "{}" (Cstrs.to_string Cstrs.empty);
  end

let test_union _ =
  begin
    assert_equal_c Cstrs.empty (Cstrs.union Cstrs.empty Cstrs.empty);
    assert_equal_c
      (Cstrs.of_list [Cstrs.Subtype(Type.var 2, Type.var 1);
		      Cstrs.Subtype(Type.top, Type.var 3);
		      Cstrs.Subtype(Type.base "Integer", Type.base "Hoge")])
      (Cstrs.union_n [(Cstrs.of_list [Cstrs.Subtype(Type.var 2, Type.var 1)]);
		      (Cstrs.of_list [Cstrs.Subtype(Type.top, Type.var 3);
				      Cstrs.Subtype(Type.base "Integer", Type.base "Hoge")])]);
  end

let test_trans _ =
  let c1 = (Cstrs.of_list [(Cstrs.Subtype (Type.var 1, Type.var 2));
			   (Cstrs.Subtype (Type.var 2, Type.var 1));
			   (Cstrs.Subtype (Type.var 1, Type.var 3))]) in
    begin
      assert_equal_c
	(Cstrs.of_list [(Cstrs.Subtype (Type.var 2, Type.var 3))]) 
	(snd (Cstrs.remove_transitives (fun _ -> true) c1));
    end

let suite = "Test Cstrs module" >:::
	      [
		"test_from_list" >:: test_of_list;
		"test_to_string" >:: test_to_string;
		"test_union" >:: test_union;
		"test_transitives" >:: test_transitives;
		"test_trans2" >:: test_trans;
	      ]

