open OUnit

let assert_equal_db = assert_equal ~cmp:(SigDB.equal (Sig.equal (=))) ~printer:SigDB.string_of

let test_load _ =
  let db = (SigDB.load "../sig.db/stdlib.txt") in
    assert_equal true true

let test_load1 _ =
  let expected_db = SigDB.add (Sig.base "Class1") (Sig.new_struct [("bar",(Sig.new_entry [] Sig.nil))]) SigDB.empty in
    assert_equal_db expected_db (SigDB.load "../sig.db/sample.txt")

let test_load2 _ =
  let db = SigDB.add (Sig.base "Hoge") (Sig.new_struct [("bar", (Sig.new_entry [Sig.base "Integer"] (Sig.base "String")))]) SigDB.empty in
    assert_equal_db db (SigDB.load "../sig.db/sample2.txt")

let test_load3 _ =
  let db = (SigDB.add (Sig.base "Hoge") (Sig.new_struct [("bar", (Sig.new_entry [Sig.base "Integer"; Sig.base "Hoge"] (Sig.base "String")))]) SigDB.empty) in
    assert_equal_db db (SigDB.load "../sig.db/sample3.txt")

let test_load4 _ =
  let db = (SigDB.add 
	      (Sig.base "Hoge") 
	      (Sig.new_struct [("bar", (Sig.new_entry [Sig.base "Integer"; Sig.base "Hoge"] (Sig.base "String")));
				     ("bar", (Sig.new_entry [] Sig.nil))])
	      SigDB.empty) in
  let db2 = (SigDB.add 
	      (Sig.base "Hoge") 
	      (Sig.new_struct [
		 ("bar", (Sig.new_entry [] Sig.nil));
		 ("bar", (Sig.new_entry [Sig.base "Integer"; Sig.base "Hoge"] (Sig.base "String")))
	       ])
	      SigDB.empty) in
    assert_equal_db db (SigDB.load "../sig.db/sample4.txt")

let test_load5 _ =
  let db = 
    let ent1 = (Sig.new_struct [("bar", (Sig.new_entry [Sig.base "Integer"; Sig.base "Hoge"] (Sig.base "String")));
				      ("bar", (Sig.new_entry [] Sig.nil))]) in
    let ent2 = (Sig.new_struct [("baz", (Sig.new_entry [Sig.base "String"] (Sig.base "Array")))]) in
      (SigDB.add (Sig.base "Hoge") ent1
	 (SigDB.add (Sig.base "Huga") ent2 
	    SigDB.empty))
  in
    assert_equal_db db (SigDB.load "../sig.db/sample5.txt")

let test_merge _ =
  let db1 = (SigDB.load "../sig.db/sample.txt") in
  let db2 = (SigDB.load "../sig.db/sample2.txt") in
  let merged_db = (SigDB.add (Sig.base "Hoge") 
		     (Sig.new_struct 
			[("bar", (Sig.new_entry [Sig.base "Integer"] (Sig.base "String")))]) db1) in
    assert_equal_db merged_db (SigDB.merge db1 db2)


let suite = "SigDB module" >:::
	      [
		"test load done without error" >:: test_load;
		"test load (1)" >:: test_load1;
		"test load (2)" >:: test_load2;
		"test load (3)" >:: test_load3;
		"test load (4)" >:: test_load4;
		"test load (5)" >:: test_load5;
		"test merge" >:: test_merge;
	      ]

