open OUnit


let assert_equal_v = 
  let cmp (asts1,cs1) (asts2,cs2) = (Cstrs.equal cs1 cs2) in
  let printer (asts,cstrs) = (Cstrs.to_string cstrs) in
    assert_equal ~cmp:cmp ~printer:printer

let empty = (Cstrs.empty, Cstrs.empty)

let test_empty _ = 
  begin
    assert_equal_v empty (Ti.solve Ti.Env.empty);
  end

let test_vars _ =
  let v = (SigDB.empty, TypeEnv.empty, (Cstrs.of_list [Cstrs.Subtype (Type.var 1, Type.var 2)]), PMap.empty) in
    begin
      assert_equal_v
	(Cstrs.empty, (Cstrs.of_list [(Cstrs.Subtype (Type.var 1, Type.var 2))]))
	(Ti.solve v);
    end

let test_transitive _ =
  let v = (SigDB.empty, TypeEnv.empty, (Cstrs.of_list [(Cstrs.Subtype (Type.var 1, Type.var 2)); 
						       (Cstrs.Subtype (Type.var 2, Type.var 3));]), PMap.empty) in
  let ev = (Cstrs.empty, (Cstrs.of_list [(Cstrs.Subtype (Type.var 1, Type.var 3))])) in
    begin
      assert_equal_v ev (Ti.solve v);
    end



let suite = "Test constraint solver module" >:::
	      [
		"empty" >:: test_empty;
		"test_vars" >:: test_vars;
		"test_transitive" >:: test_transitive;
	      ]


