open OUnit

let assert_equal_ss = assert_equal ~cmp:Subst.Src.equal ~printer:Subst.Src.to_string

let test_src_of_list _ = 
  begin
    assert_equal_ss Subst.Src.empty (Subst.Src.of_list []);
    assert_equal_ss
      (Subst.Src.add (Type.var 12, Type.var 13) Subst.Src.empty)
      (Subst.Src.of_list [(Type.var 12, Type.var 13)]);
  end

let test_subst _ =
  let t1 = Type.var 1 in
  let t2 = Type.var 2 in
  let src = Subst.Src.of_list [(Type.var 1, Type.var 2); (Type.var 3, Type.base "Boolean")] in
  let s = Subst.create src in
    begin
      assert_equal t2 (s t1);
      assert_equal Type.top (s Type.top);
    end


let suite = "Test Subst module" >:::
	      [
		"Src.of_list" >:: test_src_of_list;
		"test_subst" >:: test_subst;
	      ]


