open OUnit

let assert_equal_e = assert_equal ~cmp:TypeEnv.equal ~printer:TypeEnv.to_string

let test_union _ =
  let env1 = TypeEnv.of_list [("x", Type.var 1); ("y", Type.var 2); ("z", Type.var 3)] in
  let env2 = TypeEnv.of_list [("x", Type.var 2); ("y", Type.var 3)] in
  let env3 = TypeEnv.of_list [("x", Type.var 199)] in
    begin
      assert_equal_e
	(TypeEnv.of_list [("x", Type.var 199); ("y", Type.var 3); ("z", Type.var 3)])
	(TypeEnv.union [env1;env2;env3]);
    end

let test_mgu _ =
  let env1 = TypeEnv.of_list [("x", Type.base "Integer"); ("y", Type.var 2); ("z", Type.var 1)] in
  let env2 = TypeEnv.of_list [("x", Type.var 1); ("y", Type.base "String"); ("z", Type.var 100)] in
  let s = (Subst.create (TypeEnv.mgu [env1; env2])) in
  let enve = TypeEnv.of_list [("x", Type.base "Integer"); ("y", Type.base "String"); ("z", Type.base "Integer")] in
    begin
      assert_equal_e enve (TypeEnv.map s env1);
      assert_equal_e enve (TypeEnv.map s env2);
    end

let suite = "Test TypeEnv module" >:::
	      [
		"union" >:: test_union;
		"mgu" >:: test_mgu;
	      ]


