open OUnit

let assert_equal_c = assert_equal ~cmp:Subst.Src.equal ~printer:Subst.Src.to_string

let test_mgu _ =
  let src_list = [(Type.var 0, Type.var 0);
		  (Type.var 1, Type.var 2);
		  (Type.base "Integer", Type.var 3);
		  (Type.var 4, Type.base "Float");
		  (Type.top, Type.var 130);
		  (Type.var 140, Type.top);] in
    begin
      assert_equal_c
	(Subst.Src.of_list [(Type.var 1, Type.var 2);
			    (Type.var 3, Type.base "Integer");
			    (Type.var 4, Type.base "Float");
			    (Type.var 130, Type.top);
			    (Type.var 140, Type.top);])
	(Util.mgu src_list);
    end

let test_mgu_failed _ =
  let src_list = [(Type.base "Integer", Type.base "Float")] in
    begin
      assert_raises
	(Util.UnificationFailed (Type.base "Integer", Type.base "Float"))
	(fun _ -> Util.mgu src_list);
    end

let suite = "Test Util module" >:::
	      [
		"mgu" >:: test_mgu;
		"mgu failure" >:: test_mgu_failed;
	      ]


