(* Abstract Syntax Tree of Ruby's subset *)

(* variable scope level *)
type var_level = LocalVar
		 | GlobalVar
		 | InstanceVar

type rb_name = int * string

(* anything is expression *)
type expr = NilExpr               (* no expr here *)
	    | IntExpr of int
	    | SymbolExpr of int
	    | FloatExpr of float
	    | StringExpr of string
	    | ArrayExpr of expr list
	    | HashExpr of (expr * expr) list
	    | BlockExpr of expr list
	    | VarExpr of rb_name * var_level
	    | AssignExpr of rb_name * var_level * expr
	    | ConstExpr of rb_name
	    | CdeclExpr of rb_name * expr
	    | IfExpr of expr * expr * expr
	    | VCallExpr of string
	    | CallExpr of expr * rb_name * (expr list)
	    | FCallExpr of rb_name * (expr list)
	    | ReturnExpr of expr
	    | DefExpr of rb_name * int * expr
	    | ClassExpr of rb_name * (expr list)
	    | NewlineExpr of (string * int) * expr

