open ExtLib
open ExtList

type type_constraint = 
  | Subtype of Type.rb_type * Type.rb_type
      
module CstrSet = Set.Make(
  struct
    type t = type_constraint
    let compare = compare
  end)

include CstrSet

type t_set = t

let union_n = List.fold_left union empty

let map f set = fold (fun tc cs -> add (f tc) cs) set empty
let map_l f set = fold (fun tc lis -> (f tc)::lis) set []
let maps f set = 
  let mapc fe = function
    | Subtype (t1,t2) -> Subtype ((fe t1),(fe t2))
  in
    map (mapc f) set

let to_string cs =
  let string_of_constraint = function
    | Subtype (s1,s2) -> Type.to_string s1 ^ " <= " ^ Type.to_string s2
  in
  let strings = map_l string_of_constraint cs in
    "{" ^ (String.concat "\n " strings) ^ "}"

let of_list lis = List.fold_right add lis empty

let merge sets = List.fold_right union sets empty


let remove_transitives is_removable cstrs =
  let find_transitives (Subtype (t1,t2)) cs =
    if (is_removable t2)
    then
      begin
	if (exists (fun (Subtype (t3,t4)) -> t3 = t2) cstrs) 
	then
	  Subst.Src.of_list [(t2,t1)]
	else
	  Subst.Src.empty
      end
    else
      Subst.Src.empty
  in
  let rec rm_tr (ss,cs1,cs2) = 
    if (is_empty cs1)
    then (ss, cs2)
    else
      begin
	let c1 = max_elt cs1 in
	let cs1 = remove c1 cs1 in
	let ss1 = find_transitives c1 cs2 in
	  if (Subst.Src.is_empty ss1)
	  then rm_tr (ss, cs1, add c1 cs2)
	  else
	    let s1 = Subst.create ss1 in
	      rm_tr ((Subst.Src.union ss1 ss), (maps s1 cs1), (maps s1 cs2))
      end
  in
  let (src, cstrs) = rm_tr (Subst.Src.empty, cstrs, empty) in
    (src, cstrs)
