(**
   Constraints on types and operations for constraint set.
*)

(** Constraints on types *)
type type_constraint = 
  | Subtype of Type.rb_type * Type.rb_type

(** Set of type constraints *)
include Set.S with type elt = type_constraint
type t_set = t

val to_string : t_set -> string
val of_list : type_constraint list -> t_set
val union_n : t_set list -> t_set

val map : (type_constraint -> type_constraint) -> t_set -> t_set
val map_l : (type_constraint -> 'a) -> t_set -> 'a list
val maps : (Type.rb_type -> Type.rb_type) -> t_set -> t_set

val merge : t_set list -> t_set
val remove_transitives : (Type.rb_type -> bool) -> t_set -> (Subst.Src.t * t_set)

