{
  open ParseDB
}

let char = ['a'-'z' 'A'-'Z' '+' '-' '/' '*' '_' '0'-'9' '=' '&' '|' '^'] 

rule token = parse
  | '{'                        { LPAREN }
  | '}'                        { RPAREN }
  | '<'                        { INHERITS }
  | "->"                       { ARROW }
  | "unit"                     { UNIT }
  | "nil"                      { NIL }
  | [' ' '\n' '\t']            { token lexbuf }
  | ':'                        { COLON }
  | char +                     { STRING(Lexing.lexeme lexbuf) }
  | eof                        { EOF }
