{
  open ParseRuby
}

let dig = '-'? ['0'-'9']+
let char = ['a'-'z' 'A'-'Z' '+' '-' '/' '*' '.' '=' '>' '<' '.' '?' '_' '$' '@' '\''] 

rule token = parse
    "NodeDump V0.9 tRuby"      { NODEDUMP }
  | [' ' '\t' ':' '\n']        { token lexbuf }
  | "NODE_NEWLINE"             { NODE_NEWLINE }
  | "NODE_LIT"                 { NODE_LIT }
  | "NODE_ARRAY"               { NODE_ARRAY }
  | "NODE_CALL"                { NODE_CALL }
  | "NODE_STR"                 { NODE_STR }
  | "NODE_HASH"                { NODE_HASH }
  | "NODE_BLOCK"               { NODE_BLOCK }
  | "NODE_LVAR"                { NODE_LVAR }
  | "NODE_LASGN"               { NODE_LASGN }
  | "NODE_GVAR"                { NODE_GVAR }
  | "NODE_GASGN"               { NODE_GASGN }
  | "NODE_IVAR"                { NODE_IVAR }
  | "NODE_IASGN"               { NODE_IASGN }
  | "NODE_IF"                  { NODE_IF }
  | "NODE_VCALL"               { NODE_VCALL }
  | "NODE_FCALL"               { NODE_FCALL }
  | "NODE_RETURN"              { NODE_RETURN }
  | "NODE_SCOPE"               { NODE_SCOPE }
  | "NODE_DEFN"                { NODE_DEFN }
  | "NODE_ARGS"                { NODE_ARGS }
  | "NODE_CLASS"               { NODE_CLASS }
  | "NODE_CONST"               { NODE_CONST }
  | "NODE_CDECL"               { NODE_CDECL }
  | "NODE_NIL"                 { NODE_NIL }
  | "Fixnum"                   { NODE_Fixnum }
  | "Symbol"                   { NODE_Symbol }
  | "end"                      { NODE_end }
  | "Receiver"                 { NODE_Receiver }
  | "Parameters"               { NODE_Parameters }
  | "then"                     { NODE_then }
  | "else"                     { NODE_else }
  | "end"                      { NODE_end }
  | "=>"                       { NODE_hash_arrow }
  | '('                        { LPAREN }
  | ')'                        { RPAREN }
  | '['                        { LPAREN1 }
  | ']'                        { RPAREN1 }
  | eof                        { EOF }
  | dig                        { INT(int_of_string (Lexing.lexeme lexbuf)) }
  | dig '.' dig                { FLOAT(float_of_string (Lexing.lexeme lexbuf)) }
  | '\"' (dig|char|' ')* '\"'  { RSTRING(Lexing.lexeme lexbuf) }
  | char (dig|char)*           { STRING(Lexing.lexeme lexbuf) }
