%{
%}

%token SHARP
%token INHERITS
%token ARROW
%token COLON
%token UNIT
%token NIL
%token LPAREN
%token RPAREN
%token<string> STRING

%token EOF

%start sig_db
%type <((Type.rb_type list) * (Type.rb_type * Sig.sig_struct)) list> sig_db

%%
sig_db:
  sig_definitions EOF { $1 }
;
sig_definitions:
    /* empty */                       { [] }
  | sig_definition sig_definitions    { $1 :: $2 }
;
sig_definition:
  STRING inheritances LPAREN method_defs RPAREN { ($2, ((Type.base $1),$4)) }
;
inheritances:
    /* empty */                       { [] }
  | INHERITS string_list              { List.map Type.base $2 }
;
string_list:
    /* empty */                       { [] }
  | STRING string_list                { $1::$2 }
;
method_defs:
    /* empty */                                 { Sig.empty  }
  | STRING COLON dom ARROW range method_defs    { Sig.add $1 (Sig.Entry.create $3 $5) $6 }
;
dom:
    doms                              { $1 }
  | UNIT                              { [] }
;
doms:
    /* empty */                       { [] }
  | STRING doms                       { (Type.base $1)::$2 }
;
range:
    NIL                               { Type.base "Nil" }
  | STRING                            { Type.base $1 }
;
