open ExtList

module Entry = struct
  type entry = (Type.rb_type list) * Type.rb_type
  let create d r = (d,r)
  let dom (dm,_) = dm
  let range (_,rg) = rg
  let var_count (dm,rg) =
    let var_count1 = function
      | Type.VarType _ -> 1
      | _ -> 0
    in
    let sum = List.fold_left (+) 0 in
    let dom_cnt = sum (List.map var_count1 dm) in
      dom_cnt + (var_count1 rg)
  let to_string (dm,rg) =
    let dm_str = match dm with
      | [] -> "()" 
      | dm -> String.concat "*" (List.map Type.to_string dm) in
      dm_str ^ "->" ^ Type.to_string rg
  let map f (dm,rg) = ((List.map f dm), f rg)
end

include PMap

type sig_struct = (string, Entry.entry) t

let create es = 
  let add (name,entry) = add name entry in
    List.fold_right add es empty
let var_count s = fold (fun entry sum -> (Entry.var_count entry)+sum) s 0

let to_string s = 
  let to_str_entry en et lis = (en ^ ":" ^ Entry.to_string et)::lis in
  let str_list = foldi to_str_entry s [] in
    String.concat ", " str_list

(*
  merge entries in str2 into str1.
*)
let merge str1 str2 = foldi add str2 str1

(* check s1 is subset of s2 or not *)
let is_subset s1 s2 = foldi (fun k v b -> b && (mem k s2) && (v = (find k s2))) s1 true

let equal s1 s2 = (is_subset s1 s2) && (is_subset s2 s1)

module StrSet = Set.Make(String)

exception IncompatibleSignatures of sig_struct * sig_struct

let mgu2 s1 s2 = 
  let sigs (dm,rg) = dm@[rg] in
  let method_names s = 
    let add_name name _ = StrSet.add name in
      foldi add_name s StrSet.empty
  in
    if (equal s1 s2) then
      Subst.Src.empty
    else
      let s1_methods = method_names s1 in
      let s2_methods = method_names s2 in
      let methods_inter = StrSet.inter s1_methods s2_methods in
      let get_type_pairs (dm1,rg1) (dm2,rg2) = 
	if (List.length dm1) = (List.length dm2) then
	  (rg1,rg2)::(List.combine dm1 dm2)
	else
	  raise (IncompatibleSignatures (s1,s2))
      in
      let pairs = StrSet.fold (fun name ps -> (get_type_pairs (find name s1) (find name s2))@ps) methods_inter [] in
	Util.mgu pairs

let maps = map

