module Entry :
  sig
    type entry
    val create : Type.rb_type list -> Type.rb_type -> entry
    val dom : entry -> Type.rb_type list
    val range : entry -> Type.rb_type
    val var_count : entry -> int
    val to_string : entry -> string
    val map : (Type.rb_type -> Type.rb_type) -> entry -> entry
  end

type sig_struct

val empty : sig_struct
val is_empty : sig_struct -> bool
val add : string -> Entry.entry -> sig_struct -> sig_struct
val find : string -> sig_struct -> Entry.entry
val remove : string -> sig_struct -> sig_struct
val mem : string -> sig_struct -> bool
val exists : string -> sig_struct -> bool

val iter : (string -> Entry.entry -> unit) -> sig_struct -> unit
val map : (Entry.entry -> 'b) -> sig_struct -> (string, 'b) PMap.t
val mapi : (string -> Entry.entry -> 'c) -> sig_struct -> (string, 'c) PMap.t
val maps : (Entry.entry -> Entry.entry) -> sig_struct -> sig_struct
val fold : (Entry.entry -> 'b -> 'b) -> sig_struct -> 'b -> 'b
val foldi : (string -> Entry.entry -> 'c -> 'c) -> sig_struct -> 'c -> 'c

val create : (string * Entry.entry) list -> sig_struct
val var_count : sig_struct -> int
val to_string : sig_struct -> string
val merge : sig_struct -> sig_struct -> sig_struct
val is_subset : sig_struct -> sig_struct -> bool
val equal : sig_struct -> sig_struct -> bool

val mgu2 : sig_struct -> sig_struct -> Subst.Src.src

exception IncompatibleSignatures of sig_struct * sig_struct

