open ExtList

include PMap

type t_private_db = (Type.rb_type list) * (Type.rb_type * Sig.sig_struct)
type db = (Type.rb_type, Sig.sig_struct) t

let load file_name = 
  let db_from_list lis = 
    let mk_db_ign_inhs (_, (t, strct)) db = (add t strct db) in
    let inh_db = List.fold_right mk_db_ign_inhs lis empty in
      inh_db 
  in
  let private_list =
    let lexbuf = Lexing.from_channel (open_in file_name) in
      ParseDB.sig_db LexDB.token lexbuf in
    db_from_list private_list
      
let to_string db =
  let string_of_db_entry s e lis = (Type.to_string s ^ " = {" ^ (Sig.to_string e) ^ "}"):: lis in
  let str_list = foldi string_of_db_entry db [] in
    "{" ^ String.concat "\n " str_list ^ "}"

(*
  merge db2 on db1
*)
let merge2 (db1:db) (db2:db) =
  let fold_fun key str2 db =
    if (mem key db1) then
      let str1 = find key db in
      let merge_str = (Sig.merge str1 str2) in
	add key merge_str db
    else
      add key str2 db
  in
    foldi fold_fun db2 db1

let merge dbs = List.fold_right merge2 dbs empty

let of_list lis = List.fold_left (fun db (n,e) -> add n e db) empty lis

let maps f db = foldi (fun t s db -> add (f t) (Sig.maps (Sig.Entry.map f) s) db) db empty

let equal db1 db2 = to_string db1 = to_string db2

