type db

val empty : db
val is_empty : db -> bool
val add : Type.rb_type -> Sig.sig_struct -> db -> db
val find : Type.rb_type -> db -> Sig.sig_struct
val remove : Type.rb_type -> db -> db
val mem : Type.rb_type -> db -> bool
val exists : Type.rb_type -> db -> bool
val iter : (Type.rb_type -> Sig.sig_struct -> unit) -> db -> unit

val map : (Sig.sig_struct -> Sig.sig_struct) -> db -> db
val mapi : (Type.rb_type -> Sig.sig_struct -> Sig.sig_struct) -> db -> db

val fold : (Sig.sig_struct -> 'a -> 'a) -> db -> 'a -> 'a
val foldi : (Type.rb_type -> Sig.sig_struct -> 'a -> 'a) -> db -> 'a -> 'a

val load : string -> db
val to_string : db -> string
val merge2 : db -> db -> db
val merge : db list -> db
val of_list : (Type.rb_type * Sig.sig_struct) list -> db
val maps : (Type.rb_type -> Type.rb_type) -> db -> db

val equal : db -> db -> bool
