open ExtLib
open ExtList

module SS = Set.Make(
  struct
    type t = Type.rb_type * Type.rb_type
    let compare = compare
  end)

module Src = struct
  include SS
  type src = t
  type src_elt = elt
  let of_list elts = List.fold_right add elts empty
  let to_string src = 
    let elt_to_string (s,d) = "[" ^ Type.to_string d ^ "/" ^ Type.to_string s ^ "]" in
    let strs = fold (fun e ss -> (elt_to_string e)::ss) src [] in
      "{" ^ (String.concat "; " strs) ^ "}"
  let map f src = fold (fun elt src -> add (f elt) src) src empty
end
  

let subst (s,d) t = if t = s then d else t
let subst_n src t = Src.fold subst src t

let create src = subst_n src
