exception IncompatibleSignatures of Cstrs.type_constraint
exception SignatureEntryNotFound of string

(**
   tests is t1 a subtype of t2 or not?
   If exactly t1 <= t2, returns TypePairSet.empty.
   If t1 <= t2 under some assertions, returns the assertions.
   If not t1 <= t2, throws IncompatibleSignatures exception.

   This function will implements the Amadio and Cardelli's subtyping algorithm.
*)
let rec test db c asts cstrs = 
  begin
    match c with
      | Cstrs.Subtype(Type.TopType, Type.TopType) -> (asts,cstrs)
      | Cstrs.Subtype(_, Type.TopType) -> (asts,cstrs)
      | Cstrs.Subtype(Type.TopType, _) -> raise (IncompatibleSignatures c)
      | Cstrs.Subtype(t1,t2) when Cstrs.mem c asts -> (asts, cstrs)
      | Cstrs.Subtype(t1,t2) when t1=t2 -> (asts, cstrs)
      | Cstrs.Subtype(t1,t2) when not (SigDB.mem t1 db) || not (SigDB.mem t2 db) -> (asts, (Cstrs.add c cstrs))
      | Cstrs.Subtype(t1,t2) -> 
	  try
	    begin
	      let asts = (Cstrs.add c asts) in
	      let s1 = SigDB.find t1 db in
	      let s2 = SigDB.find t2 db in
	      let pairs = list_type_pairs (s1,s2) in
		List.fold_right (fun (t1,t2) (asts,cstrs) -> (test db (Cstrs.Subtype(t1,t2)) asts cstrs)) pairs (asts, cstrs)
	    end
	  with
	    | SignatureEntryNotFound(_) -> raise (IncompatibleSignatures c)
  end
and list_type_pairs (s1,s2) =
  let foldee name entry2 pairs =
    if (Sig.mem name s1) 
    then
      try
	begin
	  let entry1 = (Sig.find name s1) in
	  let dom1 = (Sig.Entry.dom entry1) in
	  let dom2 = (Sig.Entry.dom entry2) in
	  let dom_pairs = List.combine dom2 dom1 in
	  let rg_pairs = ((Sig.Entry.range entry1), (Sig.Entry.range entry2)) in
	    rg_pairs::dom_pairs@pairs
	end
      with
	| Invalid_argument("List.combine") -> raise (SignatureEntryNotFound name)
    else
      raise (SignatureEntryNotFound name)
  in
    Sig.foldi foldee s2 []

