let parse_ruby ic = 
  let lexbuf = Lexing.from_channel ic in
    ParseRuby.rb_dump LexRuby.token lexbuf

let parse_db = SigDB.load

let main _ =
  let db = SigDB.add (Type.var 0) (Sig.create []) (parse_db "../sig.db/stdlib.txt") in
  let v0 = (db, TypeEnv.empty, Cstrs.empty, PMap.empty) in
  let program = parse_ruby stdin in
  let _ = Type.init() in
  let (v,t) = (Ti.ti program) in
  let v1 = Ti.Env.merge [v0;v] in
    begin
      Printf.printf "%s\n" (Ti.Env.to_string v1);
      Printf.printf "----\n";
      flush stdout;
      try
	let asts,cstrs = (Ti.solve v1) in
	  Printf.printf "OK: the program may not crash by type errors.\n";
	  Printf.printf "----\n";
	  Printf.printf "%s\n" (Cstrs.to_string cstrs);
      with
	| (Subtype.IncompatibleSignatures(Cstrs.Subtype (t1,t2))) -> 
	    begin
	      Printf.printf "NG: the program will crash by type errors.\n";
	      Printf.printf "Unresolvable constraint found: %s <= %s\n" (Type.to_string t1) (Type.to_string t2);
	    end
    end      
	
let _ = main ()

