type rb_type =
  | VarType of int
  | BaseType of string
  | TopType

let cnt = ref 0

let reset () =
  let _ = 
    cnt := 0
  in
    !cnt

let fresh () =
  let _ = 
    cnt := !cnt+1
  in
    !cnt

let to_string = function
  | VarType(i) -> ".t" ^ (string_of_int i)
  | BaseType(name) -> name
  | TopType -> ".top"

let init () = let _ = reset() in ()

let var id = VarType id
let base name = BaseType name
let top = TopType

let fresh_var () = var (fresh())

type t = rb_type
let compare = compare

