(* the type of signature *)
type rb_type =
  | VarType of int
  | BaseType of string
  | TopType

(* reset for fresh_var *)
val init : unit -> unit

(* t_sig factory *)
val var : int -> rb_type
val base : string -> rb_type
val top : rb_type

(* create uniq VarSig *)
val fresh_var : unit -> rb_type

(* for debug or ... *)
val to_string : rb_type -> string

(* Map.OrderdType *)
type t = rb_type
val compare : t -> t -> int
