open ExtList
include PMap

module StrSet = Set.Make(String)

type env = (string, Type.rb_type) t

let to_string sigenv = 
  let str_list = foldi (fun k v strs -> ("(" ^ k ^ ":" ^ (Type.to_string v) ^ ")") :: strs) sigenv [] in
    "{" ^ String.concat "," str_list ^ "}"

let of_list lis = List.fold_right (fun (n,s) env -> add n s env) lis empty

let key_inter se1 se2 = 
  foldi (fun k v ss -> if (mem k se2) then (StrSet.add k ss) else ss) se1 StrSet.empty

let mgu envs = 
  let get_pairs se1 se2 =
    let inter_keys = key_inter se1 se2 in
      StrSet.fold (fun k pairs -> ((find k se1), (find k se2))::pairs) inter_keys [] in
  let pairs_n = function
    | [] -> []
    | env1::es -> List.fold_left (fun pairs env2 -> (get_pairs env1 env2)@pairs) [] es 
  in
    Util.mgu (pairs_n envs)

let union2 se1 se2 = foldi add se2 se1
let union sig_envs = List.fold_left union2 empty sig_envs

(* substitution on TypeEnv.env *)
let subst s env = map s env

(* ;-) *)
let equal env1 env2 = ((to_string env1) = (to_string env2))

let merge = union
