type ('a, 'b) t = ('a, 'b) PMap.t
val empty : ('a, 'b) t
val is_empty : ('a, 'b) t -> bool
val create : ('a -> 'a -> int) -> ('a, 'b) t
val add : 'a -> 'b -> ('a, 'b) t -> ('a, 'b) t
val find : 'a -> ('a, 'b) t -> 'b
val remove : 'a -> ('a, 'b) t -> ('a, 'b) t
val mem : 'a -> ('a, 'b) t -> bool
val exists : 'a -> ('a, 'b) t -> bool
val iter : ('a -> 'b -> unit) -> ('a, 'b) t -> unit
val map : ('a -> 'b) -> ('c, 'a) t -> ('c, 'b) t
val mapi : ('a -> 'b -> 'c) -> ('a, 'b) t -> ('a, 'c) t
val fold : ('a -> 'b -> 'b) -> ('c, 'a) t -> 'b -> 'b
val foldi : ('a -> 'b -> 'c -> 'c) -> ('a, 'b) t -> 'c -> 'c
val enum : ('a, 'b) t -> ('a * 'b) Enum.t
val of_enum : ?cmp:('a -> 'a -> int) -> ('a * 'b) Enum.t -> ('a, 'b) t
module StrSet :
  sig
    type elt = String.t
    type t = Set.Make(String).t
    val empty : t
    val is_empty : t -> bool
    val mem : elt -> t -> bool
    val add : elt -> t -> t
    val singleton : elt -> t
    val remove : elt -> t -> t
    val union : t -> t -> t
    val inter : t -> t -> t
    val diff : t -> t -> t
    val compare : t -> t -> int
    val equal : t -> t -> bool
    val subset : t -> t -> bool
    val iter : (elt -> unit) -> t -> unit
    val fold : (elt -> 'a -> 'a) -> t -> 'a -> 'a
    val for_all : (elt -> bool) -> t -> bool
    val exists : (elt -> bool) -> t -> bool
    val filter : (elt -> bool) -> t -> t
    val partition : (elt -> bool) -> t -> t * t
    val cardinal : t -> int
    val elements : t -> elt list
    val min_elt : t -> elt
    val max_elt : t -> elt
    val choose : t -> elt
    val split : elt -> t -> t * bool * t
  end
type env = (string, Type.rb_type) t
val to_string : (string, Type.rb_type) t -> string
val of_list : ('a * 'b) list -> ('a, 'b) t
val key_inter : (StrSet.elt, 'a) t -> (StrSet.elt, 'b) t -> StrSet.t
val mgu : (StrSet.elt, Type.rb_type) t list -> Subst.Src.src
val union2 : ('a, 'b) t -> ('a, 'b) t -> ('a, 'b) t
val union : ('a, 'b) t list -> ('a, 'b) t
val subst : ('a -> 'b) -> ('c, 'a) t -> ('c, 'b) t
val equal : (string, Type.rb_type) t -> (string, Type.rb_type) t -> bool

val merge : env list -> env
