
exception UnificationFailed of Type.rb_type * Type.rb_type

let subst_pair s (p1,p2) = (s p1, s p2)

let default_sort (s1,s2) = match (s1,s2) with
  | Type.BaseType _, Type.BaseType _ -> raise (UnificationFailed (s1,s2))
  | Type.BaseType _, _ -> (s2,s1)
  | _, Type.BaseType _ -> (s1,s2)
  | _, Type.TopType -> (s1,s2)
  | Type.TopType, _ -> (s2,s1)
  | _, _ -> (s1,s2)
  
let mgu2 sort pairs = 
  let rec mgu1 pairs src = match pairs with
    | [] -> [], src
    | (s1,s2)::ss -> 
	if s1=s2 then
	  (mgu1 ss src)
	else
	  let subst_elt = sort (s1,s2) in
	  let s = (Subst.create src) in
	  let sl = List.map (subst_pair s) ss in
	  let ssrc = Subst.Src.map (subst_pair s) src in
	    (mgu1 sl (Subst.Src.add subst_elt src))
  in
    snd (mgu1 pairs Subst.Src.empty)

let mgu pairs = mgu2 default_sort pairs
