/*
 * Coverage class.
 *
 * Copyright (C) 2007 SATOH Takayuki All Rights Reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */
package ts.tester.coverage;

import ts.util.Trio;
import com.sun.jdi.Bootstrap;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.Location;
import com.sun.jdi.Type;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.Method;
import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.connect.Connector;
import com.sun.jdi.connect.LaunchingConnector;
import com.sun.jdi.connect.IllegalConnectorArgumentsException;
import com.sun.jdi.connect.VMStartException;
import com.sun.jdi.event.BreakpointEvent;
import com.sun.jdi.event.ClassPrepareEvent;
import com.sun.jdi.event.MethodEntryEvent;
import com.sun.jdi.event.MethodExitEvent;
import com.sun.jdi.event.Event;
import com.sun.jdi.event.EventIterator;
import com.sun.jdi.event.EventQueue;
import com.sun.jdi.event.EventSet;
import com.sun.jdi.event.VMStartEvent;
import com.sun.jdi.event.VMDeathEvent;
import com.sun.jdi.event.VMDisconnectEvent;
import com.sun.jdi.request.BreakpointRequest;
import com.sun.jdi.request.ClassPrepareRequest;
import com.sun.jdi.request.MethodEntryRequest;
import com.sun.jdi.request.MethodExitRequest;
import com.sun.jdi.request.EventRequest;
import com.sun.jdi.request.EventRequestManager;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Collection;
import java.util.Map;
import java.util.HashMap;
import java.util.List;
import java.util.LinkedList;

/**
 * JobW̌vsNXB
 *
 * @author  V. 
 * @version $Revision: 1.2 $, $Date: 2007/02/16 16:12:48 $
 */
public abstract class Coverage 
{
  /** NXpXB */
  private StringBuffer classPath_ = new StringBuffer();

  /** sVMɓnIvVB */
  private String vmOptions_ = "";

  /** sNXB */
  private Class<?> execClass_ ;
  
  /** sNX<code>main</code>֐ɓnR}hCB */
  private String commandArgs_ ;

  /** \[Xt@C̊i[̃x[XfBNgB */
  private String sourceBasePath_ ;

  /** v̑ΏۂƂȂNX̃p^[̃XgB */
  private List<String> targetClassPatternLst_ = new LinkedList<String>();

  /** v̑ΏۊOƂNX̃p^[̃XgB */
  private List<String> exclusionClassPatternLst_ = new LinkedList<String>();

  /** NXp^[̃tB^O̎ށB */
  private FilterType classFilterType_ = FilterType.ALLOW_DENY_ALLOW;

  /** tB^O̎ނ̗񋓌^B */
  public enum FilterType { ALLOW_DENY_ALLOW, DENY_ALLOW_DENY };
  
  /** JobWsvZX̕Wo͐{@link java.io.OutputStream
   * OutputStream}IuWFNgB*/
  private OutputStream outputStream_ = System.out;

  /** JobWsvZX̕WG[o͐{@link java.io.OutputStream
   * OutputStream}IuWFNgB */
  private OutputStream errorStream_ = System.err;

  /** JobWsvZX̃IuWFNgo͐{@link
   * ts.tester.coverage.ObjectWriter ObjectWriter}IuWFNgB */
  private ObjectWriter objectWriter_ = DEFAULT_OBJECT_WRITER;

  /** ftHg {@link ts.tester.coverage.ObjectWriter ObjectWriter}
   * IuWFNgB */
  private static ObjectWriter DEFAULT_OBJECT_WRITER = new ObjectWriter();

  /** JobWvʂo͂IuWFNgB */
  private CoveragePrinter printer_ = CoveragePrinter.NULL;

  /** \bho^Cxg̗LtOB */
  private boolean eventOfEntryMethodEnabled_ = true;

  /** \bhICxg̗LtOB */
  private boolean eventOfExitMethodEnabled_ = true;

  /**
   * sNXɂƂRXgN^B
   *
   * @param  execClass sNXB
   * @throws AssertionError k̏ꍇifobO[ĥ݁jB
   */
  public Coverage(Class<?> execClass)
  {
    setExecClass(execClass, "");
  }

  /**
   * sNXƂ<code>main</code>֐ɓnR}hC
   * ɂƂRXgN^B
   *
   * @param  execClass sNXB
   * @param  commandArgs R}hCB
   * @throws AssertionError k̏ꍇifobO[ĥ݁jB
   */
  public Coverage(Class<?> execClass, String commandArgs)
  {
    setExecClass(execClass, commandArgs);
  }

  /**
   * JobW̌vʂo͂{@link ts.tester.coverage.CoveragePrinter
   * CoveragePrinter}IuWFNgݒ肷B
   *
   * @param  printer {@link ts.tester.coverage.CoveragePrinter CoveragePrinter}
   *           IuWFNgB
   * @throws AssertionError k̏ꍇifobO[ĥ݁jB
   */
  public void setPrinter(CoveragePrinter printer)
  {
    assert (printer != null) :"@param:printer is null.";

    printer_ = printer;
  }

  /**
   * NXp^[̃tB^O̎ނݒ肷B
   *
   * @param  filterType tB^O̎ށB
   */
  public void setClassFilterType(FilterType filterType)
  {
    assert (filterType != null) : "@param:filterType is null.";

    classFilterType_ = filterType;
  }

  /**
   * NXpXǉB
   * <br>
   * t@CpXZp[^ŋ؂ꂽÃNXpX̘A
   * w肵Ă悢B
   *
   * @param  path  NXpXB
   * @throws AssertionError k̏ꍇifobO[ĥ݁jB
   */
  public void addClassPath(String path)
  {
    assert (path != null) : "@param:path is null.";

    if (classPath_.length() > 0) {
      classPath_.append(File.pathSeparator);
    }
    classPath_.append(path);
  }

  /**
   * v̑ΏۂƂȂNXǉB
   * <br>
   * w肵p^[ɍvNXɊւCxgLb`悤ɂB
   *
   * @param  classPattern NX̃p^[B
   * @throws AssertionError k̏ꍇifobO[ĥ݁jB
   */
  public void addTargetClassPattern(String classPattern)
  {
    assert (classPattern != null) : "@param:classPattern is null.";

    targetClassPatternLst_.add(classPattern);
  }

  /**
   * v̑ΏۊOƂNXǉB
   * <br>
   * w肵p^[ɍvNXɊւCxgLb`ȂȂ̂ŁA
   * mɑΏۊOƂNXw肷邱ƂɂAv\シ\
   * B
   *
   * @param  classPattern NX̃p^[B
   * @throws AssertionError k̏ꍇifobO[ĥ݁jB
   */
  public void addExclusionClassPattern(String classPattern)
  {
    assert (classPattern != null) : "@param:classPattern is null.";

    exclusionClassPatternLst_.add(classPattern);
  }

  /**
   * \bho^Cxg̗LtOݒ肷B
   * <br>
   * LtO<tt>false</tt>ɐݒ肵ꍇ́A
   * \bho^Cxg̒ʒmsȂȂA
   * {@link ts.tester.coverage.Coverage#entryMethod(com.sun.jdi.Method)
   * entryMethod}\bȟĂяosȂȂB
   * <br>
   * \bho^Cxg͐\ɉe^邽߁AgpȂꍇ͔
   * Ȃ悤ɂƂ悢B
   *
   * @param  enable LtOB
   */
  public void setEventOfEntryMethodEnabled(boolean enable)
  {
    eventOfEntryMethodEnabled_ = enable;
  }

  /**
   * \bhICxg̗LtOݒ肷B
   * <br>
   * LtO<tt>false</tt>ɐݒ肵ꍇ́A
   * \bhICxg̒ʒmsȂȂA
   * {@link ts.tester.coverage.Coverage#exitMethod(com.sun.jdi.Method)
   * exitMethod}\bȟĂяosȂȂB
   * <br>
   * \bhICxg͐\ɉe^邽߁AgpȂꍇ͔
   * Ȃ悤ɂƂ悢B
   *
   * @param  enable LtOB
   */
  public void setEventOfExitMethodEnabled(boolean enable)
  {
    eventOfExitMethodEnabled_ = enable;
  }

  /**
   * sVMɓnIvVݒ肷B
   *
   * @param  options sVMɓnIvVB
   * @throws AssertionError k̏ꍇifobO[ĥ݁jB
   */
  public void setVMOptions(String options)
  {
    assert (options != null) : "@param:options is null.";

    vmOptions_ = options;
  }

  /**
   * sNXƂ<code>main</code>֐ɓnR}hCݒ
   * B
   *
   * @param  execClass sNXB
   * @param  commandArgs R}hCB 
   * @throws AssertionError k̏ꍇA͈̎sNXC֐
   *           ȂꍇifobO[ĥ݁jB
   */
  public void setExecClass(Class<?> execClass, String commandArgs)
  {
    assert (execClass != null) : "@param:execClass is null.";
    assert (commandArgs != null) : "@param:commandArgs is null.";
    assert hasMainFunction(execClass) :
      "@param;execClass does not have main function.";

    execClass_ = execClass;
    commandArgs_ = commandArgs;
  }

  /**
   * \[Xt@C̊i[̃x[XfBNgݒ肷B
   *
   * @param  path \[Xt@C̊i[̃x[XfBNgB
   * @throws AssertionError k̏ꍇifobO[ĥ݁jB
   */
  public void setSourceBasePath(String path)
  {
    assert (path != null) : "@param:path is null.";

    sourceBasePath_ = path;
  }

  /**
   * sNXɃC֐݂邩ǂ𒲂ׂB
   * <br>
   * k̏ꍇ́A<tt>false</tt>ԂB
   *
   * @param  execClass sNXB
   * @return C֐݂ꍇ<tt>true</tt>ԂB
   */
  private boolean hasMainFunction(Class<?> execClass)
  {
    try {
      java.lang.reflect.Method method;
      method = execClass.getDeclaredMethod("main", String[].class);
      int modif = method.getModifiers();
      if (! java.lang.reflect.Modifier.isStatic(modif))
        return false;

      return true;
    }
    catch (Exception e) {
      return false;
    }
  }

  /**
   * JobWsvZX̕Wo͐ƂȂ{@link java.io.OutputStream
   * OutputStream}IuWFNgݒ肷B
   *
   * @param  outstream Wo͐{@link java.io.OutputStream OutputStream}
   *           IuWFNgB
   * @throws AssertionError k̏ꍇifobO[ĥ݁jB
   */
  public void setOutputStream(OutputStream outstream)
  {
    assert (outstream != null) : "@param:outstream is null.";

    outputStream_ = outstream;
  }

  /**
   * JobWsvZX̕WG[o͐ƂȂ
   * {@link java.io.OutputStream OutputStream}IuWFNgݒ肷B
   *
   * @param  errstream WG[o͐{@link java.io.OutputStream
   *           OutputStream}IuWFNgB
   * @throws AssertionError k̏ꍇifobO[ĥ݁jB
   */
  public void setErrorStream(OutputStream errstream)
  {
    assert (errstream != null) : "@param:errstream is null.";

    errorStream_ = errstream;
  }

  /**
   * JobWsvZX̃IuWFNg̏o͐ƂȂ
   * {@link ts.tester.coverage.ObjectWriter ObjectWriter}IuWFNgݒ
   * B
   *
   * @param  objWriter IuWFNgo͐{@link
   *           ts.tester.coverage.ObjectWriter OutputWriter}IuWFNgB
   * @throws AssertionError k̏ꍇifobO[ĥ݁jB
   */
  public void setObjectWriter(ObjectWriter objWriter)
  {
    assert (objWriter != null) : "@param:objWriter is null.";

    objectWriter_ = objWriter;
  }

  /**
   * JobW̌vsB
   *
   * @throws Exception v̎sɗOꍇB
   */
  public void run() throws Exception
  {
    VirtualMachine vm = launchVM();
    prepareVM(vm);
    executeVM(vm);
  }

  /**
   * JobWvɎgpVMNグB
   *
   * @return JobWvpVMB
   * @throws IOException VM̋NɎsꍇB
   * @throws VMStartException VM ͐ɋNAڑ̊mɎsꍇB
   */
  protected VirtualMachine launchVM() throws IOException, VMStartException
  {
    LaunchingConnector connector =
      Bootstrap.virtualMachineManager().defaultConnector();

    Map<String, ? extends Connector.Argument> args;
    args = connector.defaultArguments();

    Connector.Argument argOfMain = args.get("main");

    StringBuffer buf = new StringBuffer();
    if (classPath_.length() > 0) {
      buf.append("-classpath \"").append(classPath_).append("\" ");
    }
    buf.append(vmOptions_).append(" ");
    buf.append(execClass_.getName());
    if (commandArgs_.length() > 0) {
      buf.append(" ").append(commandArgs_);
    }
    argOfMain.setValue(buf.toString());

    try {
      return connector.launch(args);
    }
    catch (VMStartException e) {
      throw e;
    }
    catch (IOException e) {
      throw e;
    }
    catch (Exception e) {
      IOException ex = new IOException();
      ex.setStackTrace(e.getStackTrace());
      throw ex;
    }
  }

  /**
   * VM̏sB
   *
   * @param  vm JobWvpVMB
   * @throws AssertionError k̏ꍇifobO[ĥ݁jB
   */
  protected void prepareVM(final VirtualMachine vm)
  {
    assert (vm != null) : "@param:vm is null.";

    vm.setDebugTraceMode(VirtualMachine.TRACE_NONE);
    enableEventRequest(vm);

    printer_.prepareCoverage(this);
  }

  /**
   * Cxgnh֐ő\ȃCxgo^B
   *
   * @param  vm JobWvpVMB
   */
  private void enableEventRequest(VirtualMachine vm)
  {
    EventRequestManager mgr = vm.eventRequestManager();

    if (FilterType.ALLOW_DENY_ALLOW.equals(classFilterType_)) {
      ClassPrepareRequest cpr0 = mgr.createClassPrepareRequest();
      MethodEntryRequest mer0 = mgr.createMethodEntryRequest();
      MethodExitRequest mxr0 = mgr.createMethodExitRequest();

      cpr0.setSuspendPolicy(EventRequest.SUSPEND_ALL);
      mer0.setSuspendPolicy(EventRequest.SUSPEND_ALL);
      mxr0.setSuspendPolicy(EventRequest.SUSPEND_ALL);

      for (String pattern : exclusionClassPatternLst_) {
        cpr0.addClassExclusionFilter(pattern);
        mer0.addClassExclusionFilter(pattern);
        mxr0.addClassExclusionFilter(pattern);
      }

      cpr0.enable();
      mer0.setEnabled(eventOfEntryMethodEnabled_);
      mxr0.setEnabled(eventOfExitMethodEnabled_);

      for (String pattern : targetClassPatternLst_) {
        ClassPrepareRequest cpr = mgr.createClassPrepareRequest();
        MethodEntryRequest mer = mgr.createMethodEntryRequest();
        MethodExitRequest mxr = mgr.createMethodExitRequest();
  
        cpr.setSuspendPolicy(EventRequest.SUSPEND_ALL);
        mer.setSuspendPolicy(EventRequest.SUSPEND_ALL);
        mxr.setSuspendPolicy(EventRequest.SUSPEND_ALL);
  
        cpr.addClassFilter(pattern);
        mer.addClassFilter(pattern);
        mxr.addClassFilter(pattern);
  
        cpr.enable();
        mer.setEnabled(eventOfEntryMethodEnabled_);
        mxr.setEnabled(eventOfExitMethodEnabled_);
      }
    }
    else {
      ClassPrepareRequest cpr0 = mgr.createClassPrepareRequest();
      MethodEntryRequest mer0 = mgr.createMethodEntryRequest();
      MethodExitRequest mxr0 = mgr.createMethodExitRequest();
  
      cpr0.setSuspendPolicy(EventRequest.SUSPEND_ALL);
      mer0.setSuspendPolicy(EventRequest.SUSPEND_ALL);
      mxr0.setSuspendPolicy(EventRequest.SUSPEND_ALL);
  
      cpr0.addClassExclusionFilter("*");
      mer0.addClassExclusionFilter("*");
      mxr0.addClassExclusionFilter("*");
  
      cpr0.enable();
      mer0.setEnabled(eventOfEntryMethodEnabled_);
      mxr0.setEnabled(eventOfExitMethodEnabled_);

      for (String pattern : targetClassPatternLst_) {
        ClassPrepareRequest cpr = mgr.createClassPrepareRequest();
        MethodEntryRequest mer = mgr.createMethodEntryRequest();
        MethodExitRequest mxr = mgr.createMethodExitRequest();
  
        cpr.setSuspendPolicy(EventRequest.SUSPEND_ALL);
        mer.setSuspendPolicy(EventRequest.SUSPEND_ALL);
        mxr.setSuspendPolicy(EventRequest.SUSPEND_ALL);
  
        cpr.addClassFilter(pattern);
        mer.addClassFilter(pattern);
        mxr.addClassFilter(pattern);

        for (String pattern1 : exclusionClassPatternLst_) {
          cpr.addClassExclusionFilter(pattern1);
          mer.addClassExclusionFilter(pattern1);
          mxr.addClassExclusionFilter(pattern1);
        }

        cpr.enable();
        mer.setEnabled(eventOfEntryMethodEnabled_);
        mxr.setEnabled(eventOfExitMethodEnabled_);
      }
    }
  }

  /**
   * JobW̌vsB
   *
   * @param  vm JobWvpVMB
   * @throws Exception v̎sɗOꍇB
   * @throws AssertionError k̏ꍇifobO[ĥ݁jB
   */
  protected void executeVM(VirtualMachine vm) throws Exception
  {
    assert (vm != null) : "@param:vm is null.";

    Process process = vm.process();

    StreamRedirectThread outThread = new StreamRedirectThread(
      process.getInputStream(), outputStream_);
    StreamRedirectThread errThread = new StreamRedirectThread(
      process.getErrorStream(), errorStream_);

    outThread.start();
    errThread.start();
   
    boolean connected = true;
    while (connected) {
      EventQueue queue = vm.eventQueue();
      EventSet eventSet = null;
      try {
        eventSet = queue.remove();

        for (Event event : eventSet) {
          handleEvent(event);

          if (event instanceof VMDisconnectEvent
          ||  event instanceof VMDeathEvent
          ) {
            connected = false;
            break;
          }
        }
      }
      catch (Exception e) {
        connected = false;
        throw e;
      }
      finally {
        // EventQueueɂVMXbh~̂ŁAċNĂ
        if (eventSet != null) {
          eventSet.resume();
        }
      }
    }

    outThread.join();
    errThread.join();

    printer_.postCoverage(this);
  }

  /**
   * CxgLb`āAɑ΂鑀sB
   *
   * @param  event CxgB
   * @throws Exception ɗOꍇB
   */
  protected void handleEvent(Event event) throws Exception
  {
    if (event instanceof ClassPrepareEvent) {
      ClassPrepareEvent cpe = (ClassPrepareEvent) event;
      ReferenceType refType = cpe.referenceType();

      entryClass(refType);
      printer_.entryClass(refType);

      VirtualMachine vm = refType.virtualMachine();
      EventRequestManager mgr = vm.eventRequestManager();

      for (Location location : refType.allLineLocations()) {
        BreakpointRequest bpr = mgr.createBreakpointRequest(location);
        bpr.setSuspendPolicy(EventRequest.SUSPEND_ALL);
        bpr.enable();

        entryLine(location);
        printer_.entryLine(location);
      }
    }
    else if (event instanceof MethodEntryEvent) {
      MethodEntryEvent mee = (MethodEntryEvent) event;
      Method method = mee.method();

      entryMethod(method);
      printer_.entryMethod(method);
    }
    else if (event instanceof MethodExitEvent) {
      MethodExitEvent mxe = (MethodExitEvent) event;
      Method method = mxe.method();

      exitMethod(method);
      printer_.exitMethod(method);
    }
    else if (event instanceof BreakpointEvent) {
      BreakpointEvent bpe = (BreakpointEvent) event;

      passLine(bpe.location());
      printer_.passLine(bpe.location());
    }
  }

  /**
   * JobW̏ɂāA\[XR[h̊es̓o^s߂ɌĂ΂
   * \bhłB
   *
   * @param  location  \[XR[h̍sIuWFNgB
   */
  protected abstract void entryLine(Location location);

  /**
   * JobWvɂāA\[XR[h̊esʉ߂ۂɌĂ΂郁\bh
   * łB
   *
   * @param location  \[XR[h̍sIuWFNgB
   */
  protected abstract void passLine(Location location);

  /**
   * JobWvɂāANX̓o^ɌĂ΂郁\bhłB
   *
   * @param  refType o^ꂽNX̓C^[tFCXIuWFNgB
   */
  protected abstract void entryClass(ReferenceType refType);

  /** 
   * JobWvɂāA\bȟĂяoɌĂ΂郁\bhłB
   *
   * @param  method Ăяoꂽ\bhB
   */
  protected abstract void entryMethod(Method method);

  /**
   * JobWvɂāA\bh̏IɌĂ΂郁\bhłB
   *
   * @param  method sꂽ\bhB
   */
  protected abstract void exitMethod(Method method);

  /**
   * JobW̑ΏۂƂȂS\[Xt@C̃RNV擾B
   *
   * @return \[Xt@Ci[RNVB
   */
  public abstract Collection<String> allSourcePaths();

  /**
   * JobW̑ΏۂƂȂSNX̖ÕRNV擾B
   *
   * @return NXi[RNVB
   */
  public abstract Collection<String> allClassNames();

  /**
   * w肳ꂽNXɐ錾Ă郁\bhɑ΂郁\bhEL[̃Xg
   * 擾B
   * <br>
   * \bhEL[́A\bhƈNX񋓕ێĂB
   *
   * @param  className NXB
   * @return \bhEL[i[郊XgB
   */
  public abstract Collection<MethodKey> methodKeysOf(String className);


  /* -- inner class -- */

  /**
   * ̓Xg[o̓Xg[ւ̃f[^̎󂯓nsNXłB
   */
  private class StreamRedirectThread extends Thread
  {
    /** ̓Xg[̓ǂݍ݃IuWFNgB*/
    private final InputStreamReader streamReader_ ;

    /** o̓Xg[̏oIuWFNgB */
    private final OutputStreamWriter streamWriter_ ;

    /** f[^̎󂯓nɎgpobt@̃TCYB */
    private static final int BUFFER_SIZE = 1024 * 512;

    /**
     * ̓Xg[Əo̓Xg[ɂƂRXgN^B
     *
     * @param  in ̓Xg[B
     * @param  out o̓Xg[B
     * @throws AssertionError k̏ꍇifobO[ĥ݁jB
     */
    StreamRedirectThread(InputStream in, OutputStream out)
    {
      assert (in != null) : "@param:in is null.";
      assert (out != null) : "@param:outin is null.";

      streamReader_ = new InputStreamReader(in);
      streamWriter_ = new OutputStreamWriter(out);
    }

    /**
     * ̓Xg[o̓Xg[ւ̃f[^̎󂯓nsB
     */
    public void run()
    {
      objectWriter_.setStreamWriter(streamWriter_);

      char[] cBuf = new char[ BUFFER_SIZE ];

      while (true) {
        synchronized (streamReader_) {
          try {
            int cLen = streamReader_.read(cBuf, 0, cBuf.length);
            if (cLen < 0) {
              break;
            }
            objectWriter_.writeObjectOrStream(cBuf, cLen);
          }
          catch (Exception e) {
            e.printStackTrace(System.err);
          }
        }
      }
    }
  }

  /**
   * \bh̃JobWvʂi[}bṽL[ƂȂNXB
   */
  public static class MethodKey
    extends Trio<String,String,String> implements Comparable
  {
    /** VAԍB */
    static final long serialVersionUID = -8984651534984062853L;

    /**
     * NXA\bhANX񋓕ɂƂRXgN^B
     *
     * @param  className NXB
     * @param  methodName \bhB
     * @param  argTypeNames NX񋓕iJ}؂jB
     * @throws AssertionError k̏ꍇifobO[ĥ݁jB
     */
    public MethodKey(String className, String methodName, String argTypeNames)
    {
      assert (className != null) : "@param:className is null.";
      assert (methodName != null) : "@param:methodName is null.";
      assert (argTypeNames != null) : "@param:argTypeNames is null.";

      set(className, methodName, argTypeNames);
    }

    /**
     * NX擾B
     *
     * @return NXB
     */
    public String getClassName()
    {
      return getFirst();
    }

    /**
     * \bh擾B
     *
     * @return \bhB
     */
    public String getMethodName()
    {
      return getSecond();
    }

    /**
     * NX񋓕擾B
     *
     * @return NX񋓕B
     */
    public String getArgTypeNames()
    {
      return getThird();
    }

    /**
     * ̃IuWFNgƑ召rB
     *
     * @param  obj rIuWFNgB
     * @return ̃IuWFNg̃IuWFNgꍇ͕lA
     *         傫ꍇ͐lAꍇ̓[B
     * @throws NullPointerException k̏ꍇB
     * @throws ClassCastException <code>MethodKey</code>IuWFNg
     *           ȂꍇB
     */
    public int compareTo(Object obj)
      throws NullPointerException, ClassCastException
    {
      MethodKey mk = (MethodKey) obj;

      int ret = getFirst().compareTo(mk.getFirst()) ;
      if (ret != 0) {
        return ret;
      }
      ret = getSecond().compareTo(mk.getSecond());
      if (ret != 0) {
        return ret;
      }
      return getThird().compareTo(mk.getThird());
    }
  }
}
