/*
 * CoveragePrinter class.
 *
 * Copyright (C) 2007 SATOH Takayuki All Rights Reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */
package ts.tester.coverage;

import com.sun.jdi.ReferenceType;
import com.sun.jdi.Method;
import com.sun.jdi.Location;
import java.io.OutputStream;

/**
 * JobW̌vʂo͂邽߂̃\bh錾C^[tFCXB 
 *
 * @author  V. 
 * @version $Revision: 1.2 $, $Date: 2007/02/16 16:12:48 $
 */
public interface CoveragePrinter
{
  /** ̃C^[tFCX̃kEIuWFNgB */
  public static CoveragePrinter NULL = new CoveragePrinter() 
  {
    public void prepareCoverage(Coverage coverage)
    {}
    public void postCoverage(Coverage coverage)
    {}
    public void entryClass(ReferenceType refType)
    {}
    public void entryLine(Location location)
    {}
    public void entryMethod(Method method)
    {}
    public void exitMethod(Method method)
    {}
    public void passLine(Location location)
    {}
  };

  /**
   * JobWv̏sB
   *
   * @param  coverage JobWvIuWFNgB
   */
  void prepareCoverage(Coverage coverage);

  /**
   * JobWv̌㏈sB
   *
   * @param  coverage JobWvIuWFNgB
   */
  void postCoverage(Coverage coverage);

  /**
   * NX̓o^ɌĂяo郁\bhB
   *
   * @param refType o^ꂽNX̓C^[tFCX
   *          {@link com.sun.jdi.ReferenceType ReferenceType}IuWFNgB
   */
  void entryClass(ReferenceType refType);

  /**
   * s̓o^ɌĂяo郁\bhB
   *
   * @param  location  o^ꂽs{@link com.sun.jdi.Location Location}
   *           IuWFNgB
   */
  void entryLine(Location location);

  /**
   * \bhĂяoɌĂяo郁\bhB
   *
   * @param  method Ăяoꂽ\bh{@link com.sun.jdi.Method Method}
   *           IuWFNgB
   */
  void entryMethod(Method method);

  /**
   * \bhIɌĂяo郁\bhB
   *
   * @param  method I\bh{@link com.sun.jdi.Method Method}
   *           IuWFNgB
   */
  void exitMethod(Method method);

  /**
   * s̒ʉߎɌĂяo郁\bhB
   *
   * @param  location ʉ߂s{@link com.sun.jdi.Location Location}
   *           IuWFNgB
   */
  void passLine(Location location);
}
