/*
 * PassResult class.
 *
 * Copyright (C) 2007 SATOH Takayuki All Rights Reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */
package ts.tester.coverage;

import java.util.Enumeration;
import java.util.Map;
import java.util.TreeMap;
import java.util.List;
import java.util.ArrayList;
import java.util.Collections;

/**
 * ʉ߉񐔂i[NXB 
 *
 * @author  V. 
 * @version $Revision: 1.2 $, $Date: 2007/02/16 16:12:49 $
 */
public class PassResult<K> extends Result<K>
{
  /** ʃL[ƒʉ߉񐔂̑ΉÂi[}bvB */
  private Map<K, PassCounter> passMap_ = new TreeMap<K, PassCounter>();

  /** ʉߍς݂̃P[XB */
  private int passedResultCount_ = 0;

  /**
   * ftHgRXgN^B
   */
  public PassResult()
  {}

  /**
   * ʉ߉񐔂i[錋ʃIuWFNgǍʃL[ɑΉÂēo^B
   * <br>
   * łʃL[Ƃ́AႦ΍sJobWvꍇȂ΍sԍ
   * ȂǂłB
   * <br>
   * ̃L[ɑΉ錋ʃIuWFNgɓo^Ăꍇ͉ȂB
   *
   * @param  resultKey ʃL[B
   * @throws AssertionError k̏ꍇifobO[ĥ݁jB
   */
  @Override public void addResult(K resultKey)
  {
    assert (resultKey != null) : "@param:resultKey is null.";

    if (passMap_.containsKey(resultKey)) {
      return;
    }
    passMap_.put(resultKey, new PassCounter());
  }

  /**
   * ̃IuWFNgi[ĂSʐ擾B
   *
   * @return SʐB
   */
  @Override public int countAllResults()
  {
    return passMap_.size();
  }

  /**
   * ̃IuWFNgi[Ăʉߍς݂̌ʐ擾B
   *
   * @return ʉߍς݂̌ʐB
   */
  @Override public int countPassedResults()
  {
    return passedResultCount_ ;
  }

  /**
   * ̌ʃL[ɑΉ錋ʃIuWFNgʉߐPZB
   * <br>
   * ̌ʃL[ɑΉ錋ʃIuWFNg݂Ȃꍇ͉ȂB
   *
   * @param  resultKey ʃL[B
   * @throws AssertionError k̏ꍇifobO[ĥ݁jB
   */
  @Override public void incrementPassCountOfResult(K resultKey)
  {
    assert (resultKey != null) : "@param:resultKey is null.";

    PassCounter c = passMap_.get(resultKey);
    if (c == null) {
      return;
    }

    if (c.countPassed() == 0) {
      passedResultCount_ ++ ;
    }

    c.incrementPassCount();
  }

  /**
   * ̃L[ɑΉP[Xv̑ΏۂǂmFB
   * <br>
   * v̑Ώۂłꍇ́A<tt>true</tt>ԂB
   *
   * @param  resultKey P[X̃L[B
   * @return ̃L[ɑΉP[Xv̑Ώۂłꍇ<tt>true</tt>B
   * @throws AssertionError k̏ꍇifobO[ĥ݁jB
   */
  @Override public boolean containsKeyOfResult(K resultKey)
  {
    assert (resultKey != null) : "@param:resultKey is null.";

    return passMap_.containsKey(resultKey);
  }

  /**
   * ̌ʃL[ɑΉ錋ʃIuWFNg̒ʉߐ擾B
   * <br>
   * ̌ʃL[ɑΉ錋ʃIuWFNg݂Ȃꍇ̓[ԂB
   *
   * @param  resultKey ʃL[B
   * @return ʉߐB
   * @throws AssertionError k̏ꍇifobO[ĥ݁jB
   */
  @Override public int getPassCountOfResult(K resultKey)
  {
    assert (resultKey != null) : "@param:resultKey is null.";

    PassCounter c = passMap_.get(resultKey);
    return (c != null) ? c.countPassed() : 0;
  }

  /**
   * ̃IuWFNgɊi[ĂSĂ̌ʃL[i[񋓃IuWFNg
   * ԂB
   *
   * @return SČʃL[i[񋓃IuWFNgB
   */
  @Override public Enumeration<K> enumAllResultKeys()
  {
    return Collections.enumeration(passMap_.keySet());
  }

  /**
   * ʉߍς݂̌ʃIuWFNǧʃL[i[񋓃IuWFNgԂB
   *
   * @return ʉߍς݂̌ʃIuWFNg̃L[i[񋓃IuWFNgB
   */
  @Override public Enumeration<K> enumPassedResultKeys()
  {
    List<K> keyLst = new ArrayList<K>(passMap_.size());
    for (Map.Entry<K,PassCounter> entry : passMap_.entrySet()) {
      if (entry.getValue().countPassed() > 0) {
        keyLst.add(entry.getKey());
      }
    }
    return Collections.enumeration(keyLst);
  }

  /**
   * ʉ߂̌ʃIuWFNǧʃL[i[񋓃IuWFNgԂB
   *
   * @return ʉ߂̌ʃIuWFNg̃L[i[񋓃IuWFNgB
   */
  @Override public Enumeration<K> enumNotPassedResultKeys()
  {
    List<K> keyLst = new ArrayList<K>(passMap_.size());
    for (Map.Entry<K,PassCounter> entry : passMap_.entrySet()) {
      if (entry.getValue().countPassed() <= 0) {
        keyLst.add(entry.getKey());
      }
    }
    return Collections.enumeration(keyLst);
  }

  /* -- inner class -- */

  /**
   * ʉߐi[邽߂̃NXB
   */
  private class PassCounter
  {
    /** ʉ߉񐔁B */
    private int passCount_ = 0;

    /** 
     * ʉ߉񐔂擾B
     *
     * @return ʉ߉񐔁B
     */
    int countPassed()
    {
      return passCount_ ;
    }

    /**
     * ʉ߉񐔂PZB
     */
    void incrementPassCount()
    {
      passCount_ ++;
    }
  }
}
