/*
 * ConsolePrinterTest class.
 *
 * Copyright (C) 2007 SATOH Takayuki All Rights Reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */
package ts.tester.function.print;

import ts.tester.function.coverage.FunctionTester;
import ts.tester.function.print.*;
import ts.tester.coverage.*;
import ts.tester.coverage.Coverage.MethodKey;
import com.sun.jdi.*;
import java.util.*;
import java.io.*;

/**
 * <code>ConsolePrinter</code>NX̋@\NXB
 *
 * @author  V. 
 * @version $Revision: 1.2 $, $Date: 2007/02/16 16:12:51 $
 */
public class ConsolePrinterTest extends FunctionTester
{
  public static void main(String[] args)
  {
    try {
      PrinterGroup group = new PrinterGroup();
      group.addPrinter(new HtmlPrinter("SATOH Takayuki"));
      group.addPrinter(new ConsolePrinter());
      setPrinter(group);

      run(ConsolePrinterTest.class, (args.length == 0) ? null : args[0]);
    }
    catch (Exception e) {
      e.printStackTrace();
    }
  }

  protected void preTesting()
  {
    MSG("ConsolePrinterNX̋@\sB");
  }

  /* -- test case -- */

  public void constructor()
  {
    MSG("ftHgRXgN^̎B");

    ConsolePrinter printer = new ConsolePrinter();
    NOTNULL(printer);
    TRUE(printer instanceof Printer);
    TRUE(printer instanceof ConsolePrinterBase);
    TRUE(printer instanceof CoveragePrinter);
  }

  public void constructor_writer()
  {
    MSG("o̓IuWFNgɂƂRXgN^B");

    PrintWriter writer = new PrintWriter(new CharArrayWriter());
    ConsolePrinter printer = new ConsolePrinter(writer);
    NOTNULL(printer);
  }

  public void constructor_writer_01()
  {
    MSG("o̓IuWFNgɂƂRXgN^B");
    MSG("k̏ꍇB");

    try {
      ConsolePrinter printer =  new ConsolePrinter(null);
      NG();
    } catch (AssertionError e) {
      OK(e);
    } catch (Exception e) {
      NG(e);
    }
  }

  public void prepareCoverage()
  {
    MSG("JobWv̏B");
    MSG("{ɂΉĂȂB");

    ConsolePrinter printer = new ConsolePrinter();
    printer.prepareCoverage(new LineCoverage(this.getClass()));
    OK();

    printer.prepareCoverage(null);
    OK();
  }

  public void postCoverage()
  {
    MSG("JobWv̌㏈B");
    MSG("LineCoveragȅꍇprintLineCoverage()ĂяoB");
    MSG("LineCoveragȅꍇ");

    ConsolePrinter printer = new ConsolePrinter();
    printer.postCoverage(new LineCoverage(this.getClass()));
    OK();
  }

  public void postCoverage_01()
  {
    MSG("JobWv̌㏈B");
    MSG("LineCoveragełȂꍇ");

    ConsolePrinter printer = new ConsolePrinter();
    printer.postCoverage(new Coverage(this.getClass()) {
      @Override protected void entryLine(Location location) {}
      @Override protected void passLine(Location location) {}
      @Override protected void entryClass(ReferenceType refType) {}
      @Override protected void entryMethod(Method method) {}
      @Override protected void exitMethod(Method method) {}
      @Override public Collection<String> allSourcePaths() { return null; }
      @Override public Collection<String> allClassNames() { return null; }
      @Override public Collection<MethodKey> methodKeysOf(String cls)
      { return null; }
    });
    OK();
  }

  public void postCoverage_02()
  {
    MSG("k̏ꍇ");

    ConsolePrinter printer = new ConsolePrinter();
    try {
      printer.postCoverage(null);
      NG();
    } catch (AssertionError e) {
      OK(e);
    } catch (Exception e) {
      NG(e);
    }
  }

  public void entryClass()
  {
    MSG("NX̓o^B");
    MSG("ʏ̏ꍇB");

    ReferenceTypeEx refType = new ReferenceTypeEx();

    ConsolePrinter printer = new ConsolePrinter();
    printer.entryClass(refType);

    refType.sourcePathLst_.add("ts.tester.Tester");
    printer.entryClass(refType);

    refType.sourcePathLst_.add("ts.tester.function.CheckResult");
    printer.entryClass(refType);

    refType.sourcePathLst_.add("ts.tester.Tester");
    printer.entryClass(refType);

    OK();
  }

  public void entryClass_1()
  {
    MSG("NX̓o^B");
    MSG("k̏ꍇB");

    try {
      ConsolePrinter printer = new ConsolePrinter();
      printer.entryClass(null);
      NG();
    } catch (AssertionError e) {
      OK(e);
    } catch (Exception e) {
      NG(e);
    }
  }

  public void entryLine()
  {
    MSG("s̓o^B");
    MSG("ۂɂΉĂȂB");

    ConsolePrinter printer = new ConsolePrinter();
    printer.entryLine(null);
    OK();
  }

  public void entryMethod()
  {
    MSG("\bh̓o^B");
    MSG("ۂɂΉĂȂB");

    ConsolePrinter printer = new ConsolePrinter();
    printer.entryMethod(null);
    OK();
  }

  public void exitMethod()
  {
    MSG("\bh̏IB");
    MSG("ۂɂΉĂȂB");

    ConsolePrinter printer = new ConsolePrinter();
    printer.exitMethod(null);
    OK();
  }

  public void passLine()
  {
    MSG("s̒ʉߎB");
    MSG("ۂɂΉĂȂB");

    ConsolePrinter printer = new ConsolePrinter();
    printer.passLine(null);
    OK();
  }

  public void printLineCoverage()
  {
    MSG("sJobW̌vʂ\B");

    LineCoverage cv = new LineCoverage(this.getClass()) {
      @Override public PassResult<Integer> getPassResult(String s) { 
        return new PassResult<Integer>() {
          @Override public float passedRatio() { return 0.9f; }
          @Override public int countPassedResults() { return 10; }
          @Override public int countAllResults() { return 20; }
          @Override public Enumeration<Integer> enumNotPassedResultKeys() {
            List<Integer> l = new LinkedList<Integer>();
            l.add(1); l.add(3); l.add(5);
            System.out.println("list size = " + l.size());
            return Collections.enumeration(l);
          }
          public int getPassCountOfResult() { return 0; }
        };
      }
    };

    ConsolePrinter printer = new ConsolePrinter(
      new PrintWriter(new OutputStreamWriter(System.out)));
    printer.printLineCoverage(cv);

    ReferenceTypeEx rte = new ReferenceTypeEx();
    rte.sourcePathLst_.add("ts.tester.Tester");
    rte.sourcePathLst_.add("ts.tester.function.FunctionTester");
    printer.entryClass(rte);
    printer.printLineCoverage(cv);

    OK();
  }

  /* -- inner class -- */

  class ReferenceTypeEx implements ReferenceType {
    List<String> sourcePathLst_ = new LinkedList<String>();
    public String name() { return ""; }
    public String genericSignature() { return ""; }
    public ClassLoaderReference classLoader() { return null; }
    public String sourceName() throws AbsentInformationException
    { return null; }
    public List<String> sourceNames(String s)
    throws AbsentInformationException { return null; }
    public List<String> sourcePaths(String s)
    throws AbsentInformationException { return sourcePathLst_; }
    public String sourceDebugExtension() throws AbsentInformationException
    { return null; }
    public boolean isStatic() { return true; }
    public boolean isAbstract() { return true; }
    public boolean isFinal() { return true; }
    public boolean isPrepared() { return true; }
    public boolean isVerified() { return true; }
    public boolean isInitialized() { return true; }
    public boolean failedToInitialize() { return true; }
    public List<Field> fields() { return null; }
    public List<Field> visibleFields() { return null; }
    public List<Field> allFields() { return null; }
    public Field fieldByName(String s) { return null; }
    public List<Method> methods() { return null; }
    public List<Method> visibleMethods() { return null; }
    public List<Method> allMethods() { return null; }
    public List<Method> methodsByName(String s) { return null; }
    public List<Method> methodsByName(String s, String t) { return null; }
    public List<ReferenceType> nestedTypes() { return null; }
    public Value getValue(Field f) { return null; }
    public Map<Field, Value> getValues(List l) { return null; }
    public ClassObjectReference classObject() { return null; }
    public List<Location> allLineLocations() throws AbsentInformationException
    { return null; }
    public List<Location> allLineLocations(String s, String t)
    throws AbsentInformationException { return null; }
    public List<Location> locationsOfLine(int n)
    throws AbsentInformationException { return null; }
    public List<Location> locationsOfLine(String s, String t, int n)
    throws AbsentInformationException { return null; }
    public List<String> availableStrata() { return null; }
    public String defaultStratum() { return null; }
    public boolean equals(Object o) { return true; }
    public int hashCode() { return 0; }
    public String signature() { return ""; }
    public VirtualMachine virtualMachine() { return null; }
    public int compareTo(ReferenceType r) { return 0; }
    public int modifiers() { return 0; }
    public boolean isPrivate() { return false; }
    public boolean isPackagePrivate() { return false; }
    public boolean isProtected() { return false; }
    public boolean isPublic() { return false; }
    // for JDK1.6
    public List<com.sun.jdi.ObjectReference> instances(long v) { return null; }
    public int majorVersion() { return 0; }
    public int minorVersion() { return 0; }
    public int constantPoolCount() { return 0; }
    public byte[] constantPool() { return new byte[0]; }
  }
}
