/*
 * HtmlPrinterBase class.
 *
 * Copyright (C) 2007 SATOH Takayuki All Rights Reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */
package ts.tester.function.print;

import ts.tester.function.Result;
import ts.tester.function.ResultType;
import ts.tester.function.CaseResult;
import ts.tester.function.CheckResult;
import ts.util.resource.Resource;
import ts.util.resource.PropertyResource;
import java.io.InputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.LinkedList;
import java.util.Map;
import java.util.HashMap;

/**
 * ʂHTML`ŏo͂{@link ts.tester.function.print.Printer Printer}
 * NX̔hNXłB
 * <br>
 * @\sNX̎ʂHTML`̃t@Cɏo͂B
 * o͐̃t@CyHTMLev[ǵARXgN^̈Ɏw肵
 * \[Xt@C̒ɋLqB
 * <br>
 * \[Xt@CŎw\Ȃ\[XL[̈ꗗ\Ɏ:
 * <table border="1">
 * <tr>
 *  <th>L[</th>
 *  <th></th>
 * </tr>
 * <tr>
 *  <td>printer.html.toFile</td>
 *  <td>o͐̃t@C</td>
 * </tr>
 * <tr>
 *  <td>printer.html.format.header</td>
 *  <td>o͂HTMLev[g̃wb_</td>
 * </tr>
 * <tr>
 *  <td>printer.html.format.precases</td>
 *  <td>printer.html.format.casȇOɏo͂HTMLev[gB</td>
 * </tr>
 * <tr>
 *  <td>printer.html.format.case</td>
 *  <td>@\s\bh̐JԂHTMLev[gB</td>
 * </tr>
 * <tr>
 *  <td>printer.html.format.postcases</td>
 *  <td>printer.html.format.casěɏo͂HTMLev[gB</td>
 * </tr>
 * <tr>
 *  <td>printer.html.format.footer</td>
 *  <td>o͂HTMLev[g̃tb^B</td>
 * </tr>
 * </table>
 * <p>
 * HTMLev[g̍\́Aȉ̐}̂悤ɂȂB
 * <blockquote>
 *  <table border="1" cellspacing="0" cellpadding="5">
 *  <tr>
 *   <td align="center">&nbsp; printer.html.format.header &nbsp;</td>
 *  </tr>
 *  <tr>
 *   <td align="center">&nbsp; printer.html.format.precases &nbsp;</td>
 *  </tr>
 *  <tr>
 *   <td align="center">:<br>&nbsp; printer.html.format.case &nbsp;<br>:</td>
 *  </tr>
 *  <tr>
 *   <td align="center">&nbsp; printer.html.format.postcases &nbsp;</td>
 *  </tr>
 *  <tr>
 *   <td align="center">&nbsp; printer.html.format.footer &nbsp;</td>
 *  </tr>
 *  </table>
 * </blockquote>
 * <p>
 * HTMLev[gŎgpł鏑wqɂ́Aȉ̂̂:
 * <table border="1">
 * <tr>
 *  <th>wq</th>
 *  <th></th>
 * </tr>
 * <tr>
 *  <td>${test.name}</td>
 *  <td>@\i= @\sNXj</td>
 * </tr>
 * <tr>
 *  <td>${test.lastname}</td>
 *  <td>@\sNX̖</td>
 * </tr>
 * <tr>
 *  <td>${test.package-dir}</td>
 *  <td>@\sNX̃pbP[WEpX</td>
 * </tr>
 * <tr>
 *  <td>${test.message}</td>
 *  <td>@\̐</td>
 * </tr>
 * <tr>
 *  <td>${test.tester}</td>
 *  <td>@\̎{Җ</td>
 * </tr>
 * <tr>
 *  <td>${test.date[,<i>simple-date-format</i>]}</td>
 *  <td>@\̎{</td>
 * </tr>
 * <tr>
 *  <td>${test.judge}</td>
 *  <td>@\Ŝ̔茋{"pass"|"reject"}</td>
 * </tr>
 * <tr>
 *  <td>${test.check}</td>
 *  <td>@\Ŝ̔萔</td>
 * </tr>
 * <tr>
 *  <td>${test.good}</td>
 *  <td>@\Ŝ̍i</td>
 * </tr>
 * <tr>
 *  <td>${test.nogood}</td>
 *  <td>@\Ŝ̕si</td>
 * </tr>
 * <tr>
 *  <td>${test.knownbug}</td>
 *  <td>@\Ŝ̊ms</td>
 * </tr>
 * <tr>
 *  <td>${test.child}</td>
 *  <td>@\Ŝ̔茋ʐ</td>
 * </tr>
 * <tr>
 *  <td>${test.empty}</td>
 *  <td>@\Ŝ̋󃁃\bh</td>
 * </tr>
 * <tr>
 *  <td>${test.incomplete}</td>
 *  <td>@\Ŝ̎r\bh</td>
 * </tr>
 * <tr>
 *  <td>${case.name}</td>
 *  <td>@\P[Xi= @\s\bhj</td>
 * </tr>
 * <tr>
 *  <td>${case.message}</td>
 *  <td>@\P[X̐</td>
 * </tr>
 * <tr>
 *   <td>${case.judge}</td>
 *   <td>@\P[X̔茋{"pass"|"reject"}</td>
 * </tr>
 * <tr>
 *  <td>${case.check}</td>
 *  <td>@\P[X̔萔</td>
 * </tr>
 * <tr>
 *  <td>${case.good}</td>
 *  <td>@\P[X̍i</td>
 * </tr>
 * <tr>
 *  <td>${case.nogood}</td>
 *  <td>@\P[X̕si</td>
 * </tr>
 * <tr>
 *  <td>${case.knownbug}</td>
 *  <td>@\P[X̊ms</td>
 * </tr>
 * <tr>
 *  <td>${case.child}</td>
 *  <td>@\P[X̉ʂ̔萔</td>
 * </tr>
 * <tr>
 *  <td>${case.empty}</td>
 *  <td>@\P[X̋󃁃\bh</td>
 * </tr>
 * <tr>
 *  <td>${case.incomplete}</td>
 *  <td>@\P[X̎r\bh</td>
 * </tr>
 * <tr>
 *  <td>${case.index}</td>
 *  <td>@\P[X̃CfbNX</td>
 * </tr>
 * </table>
 *
 * @author  V. 
 * @version $Revision: 1.2 $, $Date: 2007/02/16 16:12:51 $
 */
public class HtmlPrinterBase extends AbstractPrinter
{
  /** o͂HTMLy[W̃t@C̃\[XL[B */
  protected static final String KEY_TOFILE = "printer.html.toFile";

  /** HTMLy[W̃wb_̃\[XL[B */
  protected static final String KEY_HEADER = "printer.html.format.header";

  /** HTMLy[W̎P[XÕ\[XL[B */
  protected static final String KEY_PRECASES = "printer.html.format.precases";

  /** HTMLy[W̎P[X̃\[XL[B */
  protected static final String KEY_CASE = "printer.html.format.case";

  /** HTMLy[W̎P[X㕔̃\[XL[B */
  protected static final String KEY_POSTCASES = "printer.html.format.postcases";

  /** HTMLy[W̃tb_̃\[XL[B */
  protected static final String KEY_FOOTER = "printer.html.format.footer";


  /** wq̐擪B */
  protected static final char PREFIX_CHAR = '%';

  /** sB */
  protected static final String EOL = System.getProperty("line.separator");


  /** sNXwqB */
  protected static final String FMT_TEST = "test";

  /** s\bhwqB*/
  protected static final String FMT_CASE = "case";

  /** OwqB */
  protected static final String OPT_NAME = ".name";

  /** NXwqB */
  protected static final String OPT_LASTNAME = ".lastname";

  /** NX̃pbP[WEpXwqB */
  protected static final String OPT_PACKAGEDIR = ".package-dir";

  /** {҂wqB */
  protected static final String OPT_TESTER = ".tester";

  /** {twqB */
  protected static final String OPT_DATE = ".date";

  /** ʔwqB */
  protected static final String OPT_JUDGE = ".judge";

  /** 萔wqB */
  protected static final String OPT_CHECK = ".check";

  /** iwqB */
  protected static final String OPT_GOOD = ".good";

  /** siwqB */
  protected static final String OPT_NOGOOD = ".nogood";

  /** mswqB */
  protected static final String OPT_KNOWNBUG = ".knownbug";

  /** ʂ̔萔wqB */
  protected static final String OPT_CHILD = ".child";

  /** 󃁃\bhwqB */
  protected static final String OPT_EMPTY = ".empty";

  /** r̃\bhwqB */
  protected static final String OPT_INCOMPLETE = ".incomplete";

  /** \bh̃CfbNXwqB */
  protected static final String OPT_INDEX = ".index";

  /** bZ[WwqB */
  protected static final String OPT_MESSAGE = ".message";

  /** {ҖB */ 
  private String testerName_ = "";

  /** \[XIuWFNgB */
  private Resource htmlRes_ = Resource.EMPTY;


  /**
   * ftHgRXgN^B
   */
  protected HtmlPrinterBase()
  {}

  /**
   * ftHg̃\[Xt@C[hāÃNX̃CX^X쐬
   * RXgN^B
   *
   * @param  testerName {ҖB
   * @throws AssertionError k̏ꍇifobO[h̏ꍇjB
   */
  public HtmlPrinterBase(String testerName)
  {
    setTesterName(testerName);
    loadDefaultResource();
  }

  /**
   * ftHg̃\[Xt@C[hB
   */
  protected void loadDefaultResource()
  {
    final String PATH = "ts/tester/function/print/html.properties";

    try {
      htmlRes_ = new PropertyResource(PATH) {
        protected InputStream getInputStream(String path) 
          throws FileNotFoundException, IOException
        {
          return ClassLoader.getSystemResourceAsStream(PATH);
        }
      };
    }
    catch (Exception e) {
      System.err.println(e.toString());
      htmlRes_ = Resource.EMPTY;
    }
  }

  /**
   * {ҖHTMLev[g`郊\[XIuWFNgɂƂ
   * RXgN^B
   *
   * @param  testerName {ҖB
   * @param  resource HTMLev[g`郊\[XIuWFNgB
   * @throws AssertionError k̏ꍇifobO[h̏ꍇjB
   */
  public HtmlPrinterBase(String testerName, Resource resource)
  {
    assert (resource != null) : "@param:resource is null.";

    setTesterName(testerName);
    htmlRes_ = resource;
  }

  /**
   * HTMLev[g`\[XIuWFNg擾B
   *
   * @return \[XIuWFNgB 
   */
  protected Resource getResource()
  {
    return htmlRes_ ;
  }

  /**
   * {҂̖Oݒ肷B
   *
   * @param  testerName {ҁB
   * @throws AssertError k̏ꍇB
   */
  public void setTesterName(String testerName)
  {
    assert (testerName != null) : "@param:testerName is null.";

    testerName_ = testerName;
  }

  /**
   * {Җ擾B
   *
   * @return {ҖB
   */
  protected String getTesterName()
  {
    return testerName_ ;
  }

  /**
   * w肳ꂽO̎P[X茋ʃIuWFNg쐬B
   *
   * @param  name P[XB
   * @param  parent e̎P[X茋ʃIuWFNgB
   * @return P[X茋ʃIuWFNgB
   * @throws AssertionError k̏ꍇifobO[h̏ꍇjB
   */
  public CaseResult createCaseResult(String name, CaseResult parent)
  {
    return new _CaseResult(name, parent);
  }

  /**
   * Ŝ̏IɌĂяo郁\bhB
   *
   * @param  root ŏʂ̎P[X茋ʃIuWFNgB
   * @throws AssertionError k͕sȏꍇifobO[h̏ꍇjB
   */
  @Override
  public void testEnded(CaseResult root)
  {
    assert (root != null) : "@param:root is null.";
    assert (root instanceof _CaseResult) :
      "@param:root is an instance of unsupported CaseResult class.";

    Map<String, Object> objMap = new HashMap<String, Object>();
    objMap.put(FMT_TEST, root);
    for (Result r : ((_CaseResult) root).resultList()) {
      objMap.put(FMT_CASE, r);
      break;
    }

    outputHtmlFile(objMap);
  }

  /**
   * ʂHTMLt@Cɏo͂B 
   * <br>
   * wqulIuWFNg}bvɊi[āA
   * {@link ts.tester.function.print.HtmlPrinter#getReplacedString
   * getReplacedString}ɓnĂB
   *
   * @param  objMap wquli[}bvB
   * @throws AssertionError k̏ꍇifobO[h̏ꍇjB
   */
  protected void outputHtmlFile(Map<String, Object> objMap)
  {
    FileWriter fw = null;
    try {
      String path = getReplacedString(KEY_TOFILE, objMap);
      File file = new File(path);
      File dir = file.getParentFile();
      if (dir != null && !dir.exists()) {
        dir.mkdirs();
      }

      fw = new FileWriter(path);
      PrintWriter pw = new PrintWriter(fw);

      pw.println(getReplacedString(KEY_HEADER, objMap));
      pw.flush();

      pw.println(getReplacedString(KEY_PRECASES, objMap));
      pw.flush();

      _CaseResult testResult = (_CaseResult) objMap.get(FMT_TEST);
      for (Result caseResult : testResult.resultList()) {
        Object old = objMap.put(FMT_CASE, caseResult);
        pw.println(getReplacedString(KEY_CASE, objMap));
        pw.flush();
        objMap.put(FMT_CASE, old);
      }

      pw.println(getReplacedString(KEY_POSTCASES, objMap));
      pw.flush();

      pw.println(getReplacedString(KEY_FOOTER, objMap));
      pw.flush();
    }
    catch (Exception e) {
      System.out.println(e.toString());
    }
    finally {
      if (fw != null) try { fw.close(); } catch (Exception e) {}
    }
  }

  /**
   * HTMLo͗pɕϊB
   * <br>
   * ̕񒆂ɑ݂HTMLꕶAQƂɕϊB
   *
   * @param  s ϊ镶B
   * @return ϊ̕B
   * @throws AssertionError k̏ꍇifobO[h̏ꍇjB
   */
  String convertToHtml(String s)
  {
    assert (s != null) : "@param:s is null.";

    StringBuffer buf = new StringBuffer(s.length());
    for (int i=0; i<s.length(); i++) {
      char ch = s.charAt(i);
      if (ch == '<') {
        buf.append("&#60;");
      }
      else if (ch == '>') {
        buf.append("&#62;");
      }
      else if (ch == '&') {
        buf.append("&#38;");
      }
      else if (s.substring(i).startsWith(EOL)) {
        buf.append("<BR>");
        i += EOL.length() - 1;
      }
      else {
        buf.append(ch);
      }
    }
    return buf.toString();
  }

  /**
   * w肳ꂽ̏wqϊԂB
   *
   * @param  key ̃L[B
   * @param  objMap wquli[}bvB
   * @return ϊ̕B
   * @throws AssertionError k̏ꍇifobO[ĥ݁jB
   */
  protected String getReplacedString(String key, Map<String, Object> objMap)
  {
    assert (key != null) : "@param:key is null.";
    assert (objMap != null) : "@param:objMap is null.";

    String fmt = getResource().getFirstValue(key);

    StringBuffer buf = new StringBuffer();
    boolean isArg = false;
    for (int i=0; i<fmt.length(); i++) {
      char ch = fmt.charAt(i);
      if (isArg) {
        if (ch == PREFIX_CHAR) {
          buf.append(PREFIX_CHAR);
        }
        else {
          i = replaceArgument(buf, fmt, i - 1, objMap);
        }
        isArg = false;
      }
      else {
        if (ch == PREFIX_CHAR) {
          isArg = true;
        }
        else {
          buf.append(ch);
        }
      }
    }
    return buf.toString();
  }

  /**
   * wqۂ̒lɕϊB
   * <br>
   * JnCfbNXɈʒu镶wqł邱ƂOƂĂB
   *
   * @param  buf ui[镶obt@B
   * @param  fmt B
   * @param  idx 񒆂̏wq̊JnCfbNXB
   * @param  objMap wquli[}bvB
   * @return ϊICfbNXB
   * @throws AssertionError k̏ꍇA̓CfbNXsȏꍇ
   *          ifobO[ĥ݁jB
   */
  int replaceArgument(StringBuffer buf,
    String fmt, int idx, Map<String, Object> objMap)
  {
    assert (buf != null) : "@param:buf is null.";
    assert (fmt != null) : "@param:fmt is null.";
    assert (objMap != null) : "@param:objMap is null.";
    assert (idx >= 0) : "@param:fmt is negative.";
    assert (idx <= fmt.length()) : "@param:fmt is out of bounds.";

    if (fmt.length() == 0) {
      return 0;
    }

    if (fmt.charAt(idx + 1) != '{') {
      buf.append(fmt.substring(idx, idx + 2));
      return idx + 1;
    }

    int end = fmt.indexOf('}', idx + 2);
    if (end < 0) {
      buf.append(fmt.substring(idx));
      return (fmt.length() - 1);
    }

    String arg = fmt.substring(idx + 2, end).trim();
    buf.append(convertToHtml(replaceArgument(arg, objMap)));
    return end;
  }

  /**
   * wqۂ̒lɕϊB
   * <br>
   * wqulIuWFNǵÃ}bvɑ΂Ĉȉ
   * wqw肷邱ƂɂĎoƂłB
   * <table>
   * <tr>
   *  <td>{@link ts.tester.function.print.HtmlPrinterBase#FMT_TEST
   *      FMT_TEST}B</td>
   *  <td>sNXɑ΂{@link
   *      ts.tester.function.print.HtmlPrinterBase._CaseResult _CaseResult}
   *      IuWFNgB</td>
   * </tr>
   * <tr>
   *  <td>{@link ts.tester.function.print.HtmlPrinterBase#FMT_CASE
   *      FMT_CASE}</td>
   *  <td>s\bhɑ΂{@link
   *      ts.tester.function.print.HtmlPrinterBase._CaseResult}IuWFNg</td>
   * </tr>
   * </table>
   *
   * @param  arg wqB
   * @param  objMap wquli[}bvB
   * @return ϊ̕B
   * @throws AssertionError k̏ꍇifobO[ĥ݁jB
   */
  protected String replaceArgument(String arg, Map<String, Object> objMap)
  {
    assert (arg != null) : "@param:arg is null.";
    assert (objMap != null) : "@param:objMap is null.";

    if (arg.startsWith(FMT_CASE)) {
      Object obj = objMap.get(FMT_CASE);
      if (obj == null || ! (obj instanceof _CaseResult)) {
        return "--";
      }
      _CaseResult caze = (_CaseResult) obj;

      String opt = arg.substring(FMT_CASE.length());
      if (opt.equals(OPT_NAME)) {
        return caze.getName();
      }
      else if (opt.equals(OPT_MESSAGE)) {
        return caze.getMessage();
      }
      else if (opt.equals(OPT_JUDGE)) {
        return (caze.count(ResultType.NG) > 0) ? "reject" : "pass";
      }
      else if (opt.equals(OPT_CHECK)) {
        return String.valueOf(caze.countOfCheckResults());
      }
      else if (opt.equals(OPT_GOOD)) {
        return String.valueOf(caze.count(ResultType.OK));
      }
      else if (opt.equals(OPT_NOGOOD)) {
        return String.valueOf(caze.count(ResultType.NG));
      }
      else if (opt.equals(OPT_KNOWNBUG)) {
        return String.valueOf(caze.count(ResultType.KnownBug));
      }
      else if (opt.equals(OPT_CHILD)) {
        return String.valueOf(caze.countOfResults());
      }
      else if (opt.equals(OPT_EMPTY)) {
        return String.valueOf(caze.count(ResultType.Empty));
      }
      else if (opt.equals(OPT_INCOMPLETE)) {
        return String.valueOf(caze.count(ResultType.Incomplete));
      }
      else if (opt.equals(OPT_INDEX)) {
        return String.valueOf(caze.getIndex());
      }
    }
    else if (arg.startsWith(FMT_TEST)) {
      Object obj = objMap.get(FMT_TEST);
      if (obj == null || ! (obj instanceof _CaseResult)) {
        return "--";
      }
      _CaseResult test = (_CaseResult) obj;

      String opt = arg.substring(FMT_TEST.length());
      if (opt.equals(OPT_NAME)) {
        return test.getName();
      }
      else if (opt.equals(OPT_LASTNAME)) {
        return getClassLastName(test.getName());
      }
      else if (opt.equals(OPT_PACKAGEDIR)) {
        return getPackageDir(test.getName());
      }
      else if (opt.equals(OPT_MESSAGE)) {
        return test.getMessage();
      }
      else if (opt.equals(OPT_TESTER)) {
        return testerName_;
      }
      else if (opt.startsWith(OPT_DATE)) {
        if (opt.length() == OPT_DATE.length()) {
          SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
          return df.format(new Date());
        }
        else {
          try {
            int comma = opt.indexOf(',', OPT_DATE.length());
            String s = opt.substring(comma + 1).trim();
            SimpleDateFormat df = new SimpleDateFormat(s);
            return df.format(new Date());
          }
          catch (Exception e) {
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            return df.format(new Date());
          }
        }
      }
      else if (opt.equals(OPT_JUDGE)) {
        return (test.count(ResultType.NG) > 0) ? "reject" : "pass";
      }
      else if (opt.equals(OPT_CHECK)) {
        return String.valueOf(test.countOfCheckResults());
      }
      else if (opt.equals(OPT_GOOD)) {
        return String.valueOf(test.count(ResultType.OK));
      }
      else if (opt.equals(OPT_NOGOOD)) {
        return String.valueOf(test.count(ResultType.NG));
      }
      else if (opt.equals(OPT_KNOWNBUG)) {
        return String.valueOf(test.count(ResultType.KnownBug));
      }
      else if (opt.equals(OPT_CHILD)) {
        return String.valueOf(test.countOfResults());
      }
      else if (opt.equals(OPT_EMPTY)) {
        return String.valueOf(test.count(ResultType.Empty));
      }
      else if (opt.equals(OPT_INCOMPLETE)) {
        return String.valueOf(test.count(ResultType.Incomplete));
      }
    }

    return "--";
  }

  /* -- inner case -- */

  /**
   * {@link ts.tester.function.print.HtmlPrinterBase HtmlPrinterBase}p
   * P[X茋ʃNXB
   */
  protected class _CaseResult extends CaseResult
  {
    /** 茋ʂi[郊XgB */
    private List<Result> resultLst_ = new LinkedList<Result>();

    /** P[XCfbNXB */
    private int index_ = 0;

    /**
     * P[XƐe̎P[X茋ʃIuWFNgɂƂ
     * RXgN^B
     *
     * @param  name P[XB
     * @param  parent e̎P[X茋ʃIuWFNgB
     * @throws AssertionError k̏ꍇifobO[ĥ݁jB
     */
    _CaseResult(String name, CaseResult parent)
    {
      super(name, parent);
    }

    /**
     * ̃IuWFNgɊi[Ă锻茋ʃIuWFNg̃Xg
     * 擾B
     *
     * @return ̃IuWFNgɊi[Ă锻茋ʃIuWFNg̃XgB
     */
    public List<Result> resultList()
    {
      return resultLst_;
    }

    /**
     * w肳ꂽʃ^Cv̌ʐ擾B
     *
     * @param  type ʃ^CvB
     * @return 茋ʐB
     * @throws AssertionError k̏ꍇifobO[ĥ݁jB
     */
    @Override
    public int count(ResultType type)
    {
      assert (type != null) : "@param:type is null.";

      int cnt = 0;
      for (Result r : resultList()) {
        cnt += r.count(type);
      }
      return cnt;
    }

    /**
     * w肳ꂽ茋ʃIuWFNg̕sȂǂZB
     *
     * @param  result 茋ʃIuWFNgB
     * @throws AssertionError k͕sȏꍇifobO[ĥ݁jB
     */
    @Override
    public void addChildResult(Result result)
    {
      assert (result != null) : "@param:result is null.";
      assert (result != this) : "@param:result == this";
      
      resultLst_.add(result);

      if (result instanceof _CaseResult) {
        _CaseResult c = (_CaseResult) result;
        c.index_ = resultLst_.size();
      }
    }

    /**
     * P[X̃CfbNX擾B
     *
     * @return P[X̃CfbNXB
     */
    int getIndex()
    {
      return index_ ;
    }

    /**
     * ʂ̔茋ʂ̐擾B
     *
     * @return ʂ̔茋ʂ̐B
     */
    int countOfResults()
    {
      return resultLst_.size();
    }

    /**
     * ̃IuWFNgɊi[Ă{@link ts.tester.function.CheckResult
     * CheckResult}IuWFNg̐擾B
     *
     * @return ̃IuWFNgɊi[Ă{@link
     *           ts.tester.function.CheckResult CheckResult}IuWFNgB
     */
    int countOfCheckResults()
    {
      return countOfCheckResults(this);
    }

    /**
     * {@link ts.tester.function.Result Result}IuWFNgɊi[
     * {@link ts.tester.function.CheckResult CheckResult}IuWFNg
     * 擾B
     *
     * @param  result {@link ts.tester.function.Result Result}IuWFNgB
     * @return {@link ts.tester.function.CheckResult CheckResult}IuWFNg
     *         B
     * @throws AssertionError k̏ꍇifobO[ĥ݁jB
     */
    int countOfCheckResults(Result result)
    {
      assert (result != null) : "@param:result is null.";

      if (result instanceof CheckResult) {
        return 1;
      }
      else if (result instanceof _CaseResult) {
        _CaseResult c = (_CaseResult) result;
        int cnt = 0;
        for (Result r : c.resultLst_) {
          cnt += countOfCheckResults(r);
        }
        return cnt;
      }
      else {
        return 0;
      }
    }
  }

  /**
   * NXApbP[WEfBNg߂B
   *
   * @param  className NXB
   * @return NX̃pbP[WEfBNgB
   * @throws AssertionError k̏ꍇifobO[ĥ݁jB
   */
  protected String getPackageDir(String className)
  {
    assert (className != null) : "@param:className is null.";

    int index = className.lastIndexOf('.');
    if (index <= 0) {
      return ".";
    }
    else {
      return className.substring(0, index).replace('.', '/');
    }
  }

  /**
   * NXA̖𒊏oB
   *
   * @param  className NXB
   * @return NX̖B
   * @throws AssertionError k̏ꍇifobO[ĥ݁jB
   */
  protected String getClassLastName(String className)
  {
    assert (className != null) : "@param:className is null.";

    int index = className.lastIndexOf('.');
    if (index < 0) {
      return className;
    }
    else if (index >= className.length() - 1) {
      return "";
    }
    else {
      return className.substring(index + 1);
    }
  }
}
