/*
 * ObjectSerializerTest class.
 *
 * Copyright (C) 2007 SATOH Takayuki All Rights Reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */
package ts.tester.util;

import ts.tester.function.coverage.FunctionTester;
import ts.tester.function.print.*;
import java.util.*;

/**
 * <code>ObjectSerializer</code>NX̋@\NXB
 *
 * @author  V. 
 * @version $Revision: 1.2 $, $Date: 2007/02/16 16:12:52 $
 */
public class ObjectSerializerTest extends FunctionTester
{
  public static void main(String[] args)
  {
    try {
      PrinterGroup group = new PrinterGroup();
      group.addPrinter(new ConsolePrinter());
      group.addPrinter(new HtmlPrinter("SATOH Takayuki"));
      setPrinter(group);

      run(ObjectSerializerTest.class, (args.length == 0) ? null : args[0]);
    }
    catch (Exception e) {
      e.printStackTrace();
    }
  }

  /* -- test case -- */

  public void constructor()
  {
    MSG("ftHgRXgN^̏ꍇ");
    ObjectSerializer os = new ObjectSerializer();
    NOTNULL(os);
  }

  public void serialize_and_deserialize()
  {
    MSG("SerializableIuWFNg̃VACY - IntegerIuWFNg");
    ObjectSerializer os = new ObjectSerializer();
    try {
      byte[] bseq = os.serializeToByteArray(new Integer(1534941));

      Object obj = os.deserialize(bseq);
      EQUAL(obj.getClass(), Integer.class);
      EQUAL(obj, new Integer(1534941));
    } catch (Exception e) {
      NG(e);
    }
  }

  public void serialize_and_deserialize_1()
  {
    MSG("SerializableIuWFNg̃VACY - StringIuWFNg");
    ObjectSerializer os = new ObjectSerializer();
    try {
      byte[] bseq = os.serializeToByteArray("");

      Object obj = os.deserialize(bseq);
      EQUAL(obj.getClass(), String.class);
      EQUAL(obj, "");
    } catch (Exception e) {
      NG(e);
    }
  }

  public void serialize_and_deserialize_2()
  {
    MSG("SerializableIuWFNg̃VACY - VectorIuWFNg");
    ObjectSerializer os = new ObjectSerializer();
    try {
      Vector<Number> vec = new Vector<Number>();
      vec.add(new Integer(123));
      vec.add(new Long(987L));
      vec.add(new Byte((byte) 0x01));
      vec.add(new Double(0.1234));
      byte[] bseq = os.serializeToByteArray(vec);

      Object obj = os.deserialize(bseq);
      EQUAL(obj.getClass(), Vector.class);

      Vector vec2 = Vector.class.cast(obj);
      EQUAL(vec2.size(), 4);
      EQUAL(vec2.get(0), new Integer(123));
      EQUAL(vec2.get(1), new Long(987L));
      EQUAL(vec2.get(2), new Byte((byte) 0x01));
      EQUAL(vec2.get(3), new Double(0.1234));
    } catch (Exception e) {
      NG(e);
    }
  }

  public void serialize_and_deserialize_string()
  {
    MSG("ւ̃VACY - IntegerIuWFNg");
    ObjectSerializer os = new ObjectSerializer();
    try {
      String str = os.serializeToString(new Integer(1534941));

      Object obj = os.deserialize(str);
      EQUAL(obj.getClass(), Integer.class);
      EQUAL(obj, new Integer(1534941));
    } catch (Exception e) {
      NG(e);
    }
  }

  public void serialize_and_deserialize_string_1()
  {
    MSG("ւ̃VACY - StringIuWFNg");
    ObjectSerializer os = new ObjectSerializer();
    try {
      String str = os.serializeToString("");

      Object obj = os.deserialize(str);
      EQUAL(obj.getClass(), String.class);
      EQUAL(obj, "");
    } catch (Exception e) {
      NG(e);
    }
  }

  public void serialize_and_deserialize_string_2()
  {
    MSG("ւ̃VACY - VectorIuWFNg");
    ObjectSerializer os = new ObjectSerializer();
    try {
      Vector<Number> vec = new Vector<Number>();
      vec.add(new Integer(123));
      vec.add(new Long(987L));
      vec.add(new Byte((byte) 0x01));
      vec.add(new Double(0.1234));
      String str = os.serializeToString(vec);

      Object obj = os.deserialize(str);
      EQUAL(obj.getClass(), Vector.class);

      Vector vec2 = Vector.class.cast(obj);
      EQUAL(vec2.size(), 4);
      EQUAL(vec2.get(0), new Integer(123));
      EQUAL(vec2.get(1), new Long(987L));
      EQUAL(vec2.get(2), new Byte((byte) 0x01));
      EQUAL(vec2.get(3), new Double(0.1234));
    } catch (Exception e) {
      NG(e);
    }
  }
}
