/*
 * CaseResult class.
 *
 * Copyright (C) 2007 SATOH Takayuki All Rights Reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */
package ts.tester.function;

/**
 * P[XƂ̌ʂi[NXB
 * <br>
 * P[X\bh⎎P[XNX̒Ŏsꂽ̌ʃIuWFNg
 * 󂯎肵AWvsB
 * i[鎎ʃIuWFNǵAۃNX
 * {@link ts.tester.function.Result Result}NX̃CX^XłB
 * ̃NX̂
 * {@link ts.tester.function.Result Result}NX̔hNXłA
 * {@link ts.tester.function.CaseResult CaseResult}IuWFNgɂ
 * i[邱Ƃ\łB
 * <br>
 * P[X́A̓eo͂
 * {@link ts.tester.function.print.Printer Printer}IuWFNgɂĐ
 * B́Aʂ̏o͕@ɂāAʂ̏WvlێĂ
 * 悢̂AƂP[X̓eKw\܂ŕێKv̂ȂǁA
 * ߂@\قȂ邩łB
 *
 * @author  V. 
 * @version $Revision: 1.2 $, $Date: 2007/02/16 16:12:49 $
 */
public abstract class CaseResult extends Result
{
  /** e̎P[X茋ʃIuWFNgB */
  private CaseResult parent_ ;

  /** bZ[WB*/
  private StringBuffer messageBuf_ = new StringBuffer();

  /**
   * kӖ鎎P[XʃIuWFNgB
   * eA{@link ts.tester.function.CaseResult#getParentCaseResult
   * getParentCaseResult}\bhs
   * {@link java.lang.UnsupportedOperationException
   * UnsupportedOperationException}OX[B
   */
  public static CaseResult NULL = new CaseResult() {
    @Override public CaseResult getParentCaseResult() {
      return this;
    }
    @Override public int count(ResultType type) {
      return 0;
    }
    @Override public void addChildResult(Result result) {}
  };

  /**
   * ftHgRXgN^B
   */
  private CaseResult() 
  {
    parent_ = null;
  }

  /**
   * P[XƐe̎P[XʃIuWFNgɂƂ
   * RXgN^B
   *
   * @param  name P[XB
   * @param  parent e̎P[XʃIuWFNgB
   * @throws AssertionError Ƀkw肳ꂽꍇifobO[ĥ݁jB
   */
  public CaseResult(String name, CaseResult parent)
  {
    setName(name);

    assert (parent != null) : "@param;parent is null.";
    parent_ = parent;
  }

  /**
   * bZ[WǉB
   *
   * @param msg bZ[WB
   */
  public void addMessage(String msg)
  {
    messageBuf_.append(msg).append(System.getProperty("line.separator"));
  }

  /**
   * bZ[W擾B
   *
   * @return bZ[WB
   */
  public String getMessage()
  {
    return messageBuf_.toString();
  }

  /**
   * e̎P[XʃIuWFNg擾B
   *
   * @return e̎P[XʃIuWFNgB
   */
  public CaseResult getParentCaseResult()
  {
    return parent_ ;
  }

  /**
   * q̔茋ʃIuWFNgǉB
   * <br>
   * ̃\bh͒ۃ\bhłAs⎎P[X̏IA
   * Ŝ̏IɌĂ΂B
   * hNXɂāAႦ΁AsNXZAqIuWFNgƂ
   * ܂Ȃǂ̎s߂̃\bhłB
   *
   * @param  result 茋ʃIuWFNgB
   */
  public abstract void addChildResult(Result result);
}
